/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.interfaces.IHeatingCoil;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public abstract class GT_MetaTileEntity_AbstractMultiFurnace
extends GT_MetaTileEntity_MultiBlockBase {
    private static final int CASING_INDEX = 11;

    protected GT_MetaTileEntity_AbstractMultiFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected GT_MetaTileEntity_AbstractMultiFurnace(String aName) {
        super(aName);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    protected HeatingCoilLevel getInitialHeatLevel(IGregTechTileEntity aBaseMetaTileEntity, int xDir, int zDir) {
        Block coil = aBaseMetaTileEntity.getBlockOffset(xDir + 1, 1, zDir);
        if (!(coil instanceof IHeatingCoil)) {
            return null;
        }
        IHeatingCoil heatingCoil = (IHeatingCoil)coil;
        byte tUsedMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir + 1, 1, zDir);
        return heatingCoil.getCoilHeat(tUsedMeta);
    }

    protected boolean checkStructure(HeatingCoilLevel heatingCap, int xDir, int zDir, IGregTechTileEntity aBaseMetaTileEntity) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (!this.checkTopLayer(i, j, xDir, zDir, aBaseMetaTileEntity)) {
                    return false;
                }
                if (!this.checkBottomLayer(i, j, xDir, zDir, aBaseMetaTileEntity)) {
                    return false;
                }
                if (this.checkCoils(heatingCap, i, j, xDir, zDir, aBaseMetaTileEntity)) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract boolean checkTopLayer(int var1, int var2, int var3, int var4, IGregTechTileEntity var5);

    protected abstract boolean checkCoils(HeatingCoilLevel var1, int var2, int var3, int var4, int var5, IGregTechTileEntity var6);

    protected boolean checkBottomLayer(int i, int j, int xDir, int zDir, IGregTechTileEntity aBaseMetaTileEntity) {
        if (xDir + i == 0 && zDir + j == 0) {
            return true;
        }
        IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 0, zDir + j);
        if (this.addMaintenanceToMachineList(tTileEntity, 11)) {
            return true;
        }
        if (this.addInputToMachineList(tTileEntity, 11)) {
            return true;
        }
        if (this.addOutputToMachineList(tTileEntity, 11)) {
            return true;
        }
        if (this.addEnergyInputToMachineList(tTileEntity, 11)) {
            return true;
        }
        if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 0, zDir + j) != GregTech_API.sBlockCasings1) {
            return false;
        }
        return aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 0, zDir + j) == 11;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 20;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

