/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.long_distance;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.long_distance.GT_MetaTileEntity_LongDistancePipelineBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class GT_MetaTileEntity_LongDistancePipelineItem
extends GT_MetaTileEntity_LongDistancePipelineBase {
    static final int[] emptyIntArray = new int[0];

    public GT_MetaTileEntity_LongDistancePipelineItem(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, "Sends Items over long distances");
    }

    public GT_MetaTileEntity_LongDistancePipelineItem(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public boolean isSameClass(GT_MetaTileEntity_LongDistancePipelineBase other) {
        return other instanceof GT_MetaTileEntity_LongDistancePipelineItem;
    }

    @Override
    public int getPipeMeta() {
        return 1;
    }

    public IInventory getInventory() {
        IGregTechTileEntity tTile = this.mTarget.getBaseMetaTileEntity();
        TileEntity invTile = tTile.getTileEntityAtSide(tTile.getBackFacing());
        if (invTile instanceof IInventory) {
            return (IInventory)invTile;
        }
        return null;
    }

    @Override
    public ItemStack decrStackSize(int aSlot, int aDecrement) {
        IInventory iInventory;
        if (this.checkTarget() && (iInventory = this.getInventory()) != null) {
            return iInventory.decrStackSize(aSlot, aDecrement);
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int aSlot) {
        IInventory iInventory;
        if (this.checkTarget() && (iInventory = this.getInventory()) != null) {
            return iInventory.getStackInSlotOnClosing(aSlot);
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlot(int aSlot) {
        IInventory iInventory;
        if (this.checkTarget() && (iInventory = this.getInventory()) != null) {
            return iInventory.getStackInSlot(aSlot);
        }
        return null;
    }

    @Override
    public String getInventoryName() {
        IInventory iInventory;
        if (this.checkTarget() && (iInventory = this.getInventory()) != null) {
            return iInventory.getInventoryName();
        }
        return super.getInventoryName();
    }

    @Override
    public int getSizeInventory() {
        IInventory iInventory;
        if (this.checkTarget() && (iInventory = this.getInventory()) != null) {
            return iInventory.getSizeInventory();
        }
        return 0;
    }

    @Override
    public int getInventoryStackLimit() {
        IInventory iInventory;
        if (this.checkTarget() && (iInventory = this.getInventory()) != null) {
            return iInventory.getInventoryStackLimit();
        }
        return 0;
    }

    @Override
    public void setInventorySlotContents(int aSlot, ItemStack aStack) {
        IInventory iInventory;
        if (this.checkTarget() && (iInventory = this.getInventory()) != null) {
            iInventory.setInventorySlotContents(aSlot, aStack);
        }
    }

    @Override
    public boolean hasCustomInventoryName() {
        IInventory iInventory;
        if (this.checkTarget() && (iInventory = this.getInventory()) != null) {
            return iInventory.hasCustomInventoryName();
        }
        return false;
    }

    @Override
    public boolean isItemValidForSlot(int aSlot, ItemStack aStack) {
        IInventory iInventory;
        if (this.checkTarget() && (iInventory = this.getInventory()) != null) {
            return iInventory.isItemValidForSlot(aSlot, aStack);
        }
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(int aSide) {
        if (this.checkTarget()) {
            IGregTechTileEntity tTile = this.mTarget.getBaseMetaTileEntity();
            IInventory iInventory = this.getInventory();
            if (iInventory instanceof ISidedInventory) {
                return ((ISidedInventory)iInventory).getAccessibleSlotsFromSide((int)tTile.getBackFacing());
            }
            if (iInventory != null) {
                int[] tReturn = new int[iInventory.getSizeInventory()];
                for (int i = 0; i < tReturn.length; ++i) {
                    tReturn[i] = i;
                }
                return tReturn;
            }
        }
        return emptyIntArray;
    }

    @Override
    public boolean canInsertItem(int aSlot, ItemStack aStack, int aSide) {
        if (this.checkTarget()) {
            IGregTechTileEntity tTile = this.mTarget.getBaseMetaTileEntity();
            IInventory iInventory = this.getInventory();
            if (iInventory instanceof ISidedInventory) {
                return ((ISidedInventory)iInventory).canInsertItem(aSlot, aStack, (int)tTile.getBackFacing());
            }
            return iInventory != null;
        }
        return false;
    }

    @Override
    public boolean canExtractItem(int aSlot, ItemStack aStack, int aSide) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LongDistancePipelineItem(this.mName, (int)this.mTier, this.getDescription()[0], this.mTextures);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPELINE_ITEM_FRONT)};
        }
        if (aSide == GT_Utility.getOppositeSide(aFacing)) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPELINE_ITEM_BACK)};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPELINE_ITEM_SIDE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_PIPELINE_ITEM_SIDE_GLOW).glow().build()};
    }
}

