/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.ItemData;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_UndergroundOil;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_SeismicProspector
extends GT_MetaTileEntity_BasicMachine {
    boolean ready = false;

    public GT_MetaTileEntity_SeismicProspector(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "(DEPRECATED, DO NOT USE! SWAP TO ADVANCED VERSION USING SHAPELESS RECIPE!)", 1, 1, "Default.png", "", TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER_ACTIVE), TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER), TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER_ACTIVE), TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE_GLOW).glow().build()), TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER), TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER_ACTIVE), TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER));
    }

    public GT_MetaTileEntity_SeismicProspector(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
    }

    public GT_MetaTileEntity_SeismicProspector(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_SeismicProspector(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ItemStack aStack = aPlayer.getCurrentEquippedItem();
            ItemData stackData = GT_OreDictUnificator.getItemData(aStack);
            if (!this.ready && aStack != null && (aStack.getItem() == Item.getItemFromBlock((Block)Blocks.tnt) && aStack.stackSize >= 2 || aStack.getItem() == Ic2Items.industrialTnt.getItem() && aStack.stackSize >= 1 || aStack.getItem() == Ic2Items.dynamite.getItem() && aStack.stackSize >= 4 || stackData != null && stackData.mMaterial.mMaterial == Materials.Glyceryl && aStack.stackSize >= 1 || aStack.getItem() == ItemList.Block_Powderbarrel.getItem() && aStack.getItemDamage() == ItemList.Block_Powderbarrel.get(1L, new Object[0]).getItemDamage() && aStack.stackSize >= 8)) {
                if (!aPlayer.capabilities.isCreativeMode && aStack.stackSize != 111) {
                    aStack.stackSize = aStack.getItem() == Item.getItemFromBlock((Block)Blocks.tnt) ? (aStack.stackSize -= 2) : (aStack.getItem() == Ic2Items.industrialTnt.getItem() ? --aStack.stackSize : (aStack.getItem() == Ic2Items.dynamite.getItem() ? (aStack.stackSize -= 4) : (aStack.getItem() == ItemList.Block_Powderbarrel.getItem() && aStack.getItemDamage() == ItemList.Block_Powderbarrel.get(1L, new Object[0]).getItemDamage() ? (aStack.stackSize -= 8) : --aStack.stackSize)));
                }
                this.ready = true;
                this.mMaxProgresstime = 200;
            } else if (this.ready && this.mMaxProgresstime == 0 && aStack != null && aStack.stackSize == 1 && aStack.getItem() == ItemList.Tool_DataStick.getItem()) {
                this.ready = false;
                GT_Utility.ItemNBT.setBookTitle(aPlayer.getCurrentEquippedItem(), "Raw Prospection Data");
                ArrayList<String> tStringList = new ArrayList<String>();
                int min = -this.range();
                int max = this.range();
                int step = this.step();
                for (int i = this.getBaseMetaTileEntity().getYCoord(); i > 0; --i) {
                    for (int f = min; f <= max; f += step) {
                        for (int g = min; g <= max; g += step) {
                            Block tBlock = this.getBaseMetaTileEntity().getBlockOffset(f, -i, g);
                            if (tBlock instanceof GT_Block_Ores_Abstract) {
                                Materials tMaterial;
                                TileEntity tTileEntity = this.getBaseMetaTileEntity().getWorld().getTileEntity(this.getBaseMetaTileEntity().getXCoord() + f, this.getBaseMetaTileEntity().getYCoord() + -i, this.getBaseMetaTileEntity().getZCoord() + g);
                                if (!(tTileEntity instanceof GT_TileEntity_Ores) || ((GT_TileEntity_Ores)tTileEntity).mMetaData >= 16000 || (tMaterial = GregTech_API.sGeneratedMaterials[((GT_TileEntity_Ores)tTileEntity).mMetaData % 1000]) == null || tMaterial == Materials._NULL || tStringList.contains(tMaterial.mDefaultLocalName)) continue;
                                tStringList.add(tMaterial.mDefaultLocalName);
                                continue;
                            }
                            int tMetaID = this.getBaseMetaTileEntity().getWorld().getBlockMetadata(this.getBaseMetaTileEntity().getXCoord() + f, this.getBaseMetaTileEntity().getYCoord() + -i, this.getBaseMetaTileEntity().getZCoord() + g);
                            ItemData tAssotiation = GT_OreDictUnificator.getAssociation(new ItemStack(tBlock, 1, tMetaID));
                            if (tAssotiation == null || !tAssotiation.mPrefix.toString().startsWith("ore") || tStringList.contains(tAssotiation.mMaterial.mMaterial.mDefaultLocalName)) continue;
                            tStringList.add(tAssotiation.mMaterial.mMaterial.mDefaultLocalName);
                        }
                    }
                }
                if (tStringList.size() < 1) {
                    tStringList.add("No Ores found.");
                }
                FluidStack tFluid = GT_UndergroundOil.undergroundOilReadInformation(this.getBaseMetaTileEntity());
                String[] tStringArray = new String[tStringList.size()];
                for (int i = 0; i < tStringArray.length; ++i) {
                    tStringArray[i] = (String)tStringList.get(i);
                }
                GT_Utility.ItemNBT.setProspectionData(aPlayer.getCurrentEquippedItem(), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().provider.dimensionId, tFluid, tStringArray);
            }
        }
        return true;
    }

    private int range() {
        switch (this.mTier) {
            case 1: {
                return 16;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 48;
            }
        }
        return 0;
    }

    private int step() {
        switch (this.mTier) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 1;
    }
}

