/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.GT_Mod;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;

class GT_RenderedGlowTexture
implements ITexture,
IColorModulationContainer {
    protected final IIconContainer mIconContainer;
    private final short[] mRGBa;

    GT_RenderedGlowTexture(IIconContainer aIcon, short[] aRGBa, boolean allowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GT_RenderedTexture");
        }
        this.mIconContainer = GT_Mod.gregtechproxy.mRenderGlowTextures ? aIcon : Textures.BlockIcons.VOID;
        this.mRGBa = aRGBa;
    }

    @Override
    public short[] getRGBA() {
        return this.mRGBa;
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        if (aRenderer.useInventoryTint) {
            return;
        }
        if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
            return;
        }
        boolean enableAO = aRenderer.enableAO;
        aRenderer.enableAO = false;
        Tessellator.instance.setBrightness(0xF000F0);
        Tessellator.instance.setColorOpaque((int)this.mRGBa[0], (int)this.mRGBa[1], (int)this.mRGBa[2]);
        aRenderer.renderFaceXNeg(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.instance.setColorOpaque(255, 255, 255);
            aRenderer.renderFaceXNeg(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.enableAO = enableAO;
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        if (aRenderer.useInventoryTint) {
            return;
        }
        if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
            return;
        }
        aRenderer.field_152631_f = true;
        boolean enableAO = aRenderer.enableAO;
        aRenderer.enableAO = false;
        Tessellator.instance.setBrightness(0xF000F0);
        Tessellator.instance.setColorOpaque((int)this.mRGBa[0], (int)this.mRGBa[1], (int)this.mRGBa[2]);
        aRenderer.renderFaceXPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.instance.setColorOpaque(255, 255, 255);
            aRenderer.renderFaceXPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.field_152631_f = false;
        aRenderer.enableAO = enableAO;
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        if (aRenderer.useInventoryTint) {
            return;
        }
        if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
            return;
        }
        boolean enableAO = aRenderer.enableAO;
        Tessellator tessellator = Tessellator.instance;
        IIcon aIcon = this.mIconContainer.getIcon();
        float minU = aIcon.getInterpolatedU((1.0 - aRenderer.renderMaxX) * 16.0);
        float maxU = aIcon.getInterpolatedU((1.0 - aRenderer.renderMinX) * 16.0);
        float minV = aIcon.getInterpolatedV(aRenderer.renderMinZ * 16.0);
        float maxV = aIcon.getInterpolatedV(aRenderer.renderMaxZ * 16.0);
        if (aRenderer.renderMinX < 0.0 || aRenderer.renderMaxX > 1.0) {
            minU = 16.0f - aIcon.getMaxU();
            maxU = 16.0f - aIcon.getMinU();
        }
        if (aRenderer.renderMinZ < 0.0 || aRenderer.renderMaxZ > 1.0) {
            minV = aIcon.getMinV();
            maxV = aIcon.getMaxV();
        }
        double minX = (double)aX + aRenderer.renderMinX;
        double maxX = (double)aX + aRenderer.renderMaxX;
        double minY = (double)aY + aRenderer.renderMinY;
        double minZ = (double)aZ + aRenderer.renderMinZ;
        double maxZ = (double)aZ + aRenderer.renderMaxZ;
        Tessellator.instance.setBrightness(0xF000F0);
        Tessellator.instance.setColorOpaque((int)this.mRGBa[0], (int)this.mRGBa[1], (int)this.mRGBa[2]);
        tessellator.addVertexWithUV(minX, minY, maxZ, (double)maxU, (double)maxV);
        tessellator.addVertexWithUV(minX, minY, minZ, (double)maxU, (double)minV);
        tessellator.addVertexWithUV(maxX, minY, minZ, (double)minU, (double)minV);
        tessellator.addVertexWithUV(maxX, minY, maxZ, (double)minU, (double)maxV);
        if (this.mIconContainer.getOverlayIcon() != null) {
            minU = aIcon.getInterpolatedU((1.0 - aRenderer.renderMaxX) * 16.0);
            maxU = aIcon.getInterpolatedU((1.0 - aRenderer.renderMinX) * 16.0);
            minV = aIcon.getInterpolatedV(aRenderer.renderMinZ * 16.0);
            maxV = aIcon.getInterpolatedV(aRenderer.renderMaxZ * 16.0);
            if (aRenderer.renderMinX < 0.0 || aRenderer.renderMaxX > 1.0) {
                minU = 16.0f - aIcon.getMaxU();
                maxU = 16.0f - aIcon.getMinU();
            }
            if (aRenderer.renderMinZ < 0.0 || aRenderer.renderMaxZ > 1.0) {
                minV = aIcon.getMinV();
                maxV = aIcon.getMaxV();
            }
            minX = (float)aX + (float)aRenderer.renderMinX;
            maxX = (float)aX + (float)aRenderer.renderMaxX;
            minY = (float)aY + (float)aRenderer.renderMinY;
            minZ = (float)aZ + (float)aRenderer.renderMinZ;
            maxZ = (float)aZ + (float)aRenderer.renderMaxZ;
            Tessellator.instance.setColorOpaque(255, 255, 255);
            tessellator.addVertexWithUV(minX, minY, maxZ, (double)maxU, (double)maxV);
            tessellator.addVertexWithUV(minX, minY, minZ, (double)maxU, (double)minV);
            tessellator.addVertexWithUV(maxX, minY, minZ, (double)minU, (double)minV);
            tessellator.addVertexWithUV(maxX, minY, maxZ, (double)minU, (double)maxV);
        }
        aRenderer.enableAO = enableAO;
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        if (aRenderer.useInventoryTint) {
            return;
        }
        if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
            return;
        }
        boolean enableAO = aRenderer.enableAO;
        aRenderer.enableAO = false;
        Tessellator.instance.setBrightness(0xF000F0);
        Tessellator.instance.setColorOpaque((int)this.mRGBa[0], (int)this.mRGBa[1], (int)this.mRGBa[2]);
        aRenderer.renderFaceYPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.instance.setColorOpaque(255, 255, 255);
            aRenderer.renderFaceYPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.enableAO = enableAO;
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        if (aRenderer.useInventoryTint) {
            return;
        }
        if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
            return;
        }
        boolean enableAO = aRenderer.enableAO;
        aRenderer.enableAO = false;
        aRenderer.field_152631_f = true;
        Tessellator.instance.setBrightness(0xF000F0);
        Tessellator.instance.setColorOpaque((int)this.mRGBa[0], (int)this.mRGBa[1], (int)this.mRGBa[2]);
        aRenderer.renderFaceZNeg(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.instance.setColorOpaque(255, 255, 255);
            aRenderer.renderFaceZNeg(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.field_152631_f = false;
        aRenderer.enableAO = enableAO;
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        if (aRenderer.useInventoryTint) {
            return;
        }
        if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
            return;
        }
        boolean enableAO = aRenderer.enableAO;
        aRenderer.enableAO = false;
        Tessellator.instance.setBrightness(0xF000F0);
        Tessellator.instance.setColorOpaque((int)this.mRGBa[0], (int)this.mRGBa[1], (int)this.mRGBa[2]);
        aRenderer.renderFaceZPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            aRenderer.renderFaceZPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.enableAO = enableAO;
    }

    @Override
    public boolean isValidTexture() {
        return this.mIconContainer != null;
    }
}

