/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.GregTech_API;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetaTileEntityItemPipe;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_None;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Behaviour_Plunger_Item
extends Behaviour_None {
    private final int mCosts;
    private final String mTooltip = GT_LanguageManager.addStringLocalization("gt.behaviour.plunger.item", "Clears Items from Pipes");

    public Behaviour_Plunger_Item(int aCosts) {
        this.mCosts = aCosts;
    }

    @Override
    public boolean onItemUseFirst(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        IMetaTileEntity tMetaTileEntity;
        if (aWorld.isRemote) {
            return false;
        }
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity instanceof IGregTechTileEntity && (tMetaTileEntity = ((IGregTechTileEntity)aTileEntity).getMetaTileEntity()) instanceof IMetaTileEntityItemPipe) {
            for (IMetaTileEntityItemPipe tTileEntity : GT_Utility.sortMapByValuesAcending(IMetaTileEntityItemPipe.Util.scanPipes((IMetaTileEntityItemPipe)tMetaTileEntity, new ConcurrentHashMap<IMetaTileEntityItemPipe, Long>(), 0L, false, true)).keySet()) {
                int j = tTileEntity.getSizeInventory();
                for (int i = 0; i < j; ++i) {
                    if (!tTileEntity.isValidSlot(i) || tTileEntity.getStackInSlot(i) == null || !aPlayer.capabilities.isCreativeMode && !((GT_MetaGenerated_Tool)aItem).doDamage(aStack, this.mCosts)) continue;
                    ItemStack tStack = tTileEntity.decrStackSize(i, 64);
                    if (tStack != null) {
                        EntityItem tEntity = new EntityItem(aWorld, (double)((IGregTechTileEntity)aTileEntity).getOffsetX((byte)aSide, 1) + 0.5, (double)((IGregTechTileEntity)aTileEntity).getOffsetY((byte)aSide, 1) + 0.5, (double)((IGregTechTileEntity)aTileEntity).getOffsetZ((byte)aSide, 1) + 0.5, tStack);
                        tEntity.motionX = 0.0;
                        tEntity.motionY = 0.0;
                        tEntity.motionZ = 0.0;
                        aWorld.spawnEntityInWorld((Entity)tEntity);
                        GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(101), 1.0f, -1.0f, aX, aY, aZ);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<String> getAdditionalToolTips(GT_MetaBase_Item aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        return aList;
    }
}

