/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.IGuiScreen;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.Fluid;

public abstract class GT_Cover_RedstoneWirelessBase
extends GT_CoverBehavior {
    @Override
    public boolean onCoverRemoval(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        GregTech_API.sWirelessRedstone.put(aCoverVariable, (byte)0);
        return true;
    }

    @Override
    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((double)aX > 0.375 && (double)aX < 0.625 || aSide > 3 && (double)aY > 0.375 && (double)aY < 0.625) {
            GregTech_API.sWirelessRedstone.put(aCoverVariable, (byte)0);
            aCoverVariable = GT_Utility.stackToInt(aPlayer.inventory.getCurrentItem());
            aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("081", "Frequency: ") + aCoverVariable);
            return true;
        }
        return false;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((double)aX > 0.375 && (double)aX < 0.625 || aSide <= 3 || (double)aY > 0.375 && (double)aY < 0.625 || (double)aZ <= 0.375 || (double)aZ >= 0.625) {
            GregTech_API.sWirelessRedstone.put(aCoverVariable, (byte)0);
            float[] tCoords = GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ);
            switch ((byte)((byte)(tCoords[0] * 2.0f) + 2 * (byte)(tCoords[1] * 2.0f))) {
                case 0: {
                    aCoverVariable -= 32;
                    break;
                }
                case 1: {
                    aCoverVariable += 32;
                    break;
                }
                case 2: {
                    aCoverVariable -= 1024;
                    break;
                }
                case 3: {
                    aCoverVariable += 1024;
                }
            }
        }
        GT_Utility.sendChatToPlayer(aPlayer, this.trans("081", "Frequency: ") + aCoverVariable);
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public String getDescription(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return this.trans("081", "Frequency: ") + aCoverVariable;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private GT_GuiIntegerTextBox fBox;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            this.fBox = new GT_GuiIntegerTextBoxWithMinus(this, 2, 10, 27, 69, 12);
            this.fBox.setText(String.valueOf(this.coverVariable));
            this.fBox.setMaxStringLength(12);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.getFontRenderer().drawString(GT_Cover_RedstoneWirelessBase.this.trans("246", "Frequency"), 82, 29, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.fBox.setFocused(true);
        }

        @Override
        public void onMouseWheel(int x, int y, int delta) {
            for (GT_GuiIntegerTextBox box : this.textBoxes) {
                long i;
                if (!box.isFocused()) continue;
                int step = Math.max(1, Math.abs(delta / 120));
                step = (GUI.isShiftKeyDown() ? 1000 : (GUI.isCtrlKeyDown() ? 50 : 1)) * (delta > 0 ? step : -step);
                try {
                    i = Long.parseLong(box.getText());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if ((i += (long)step) > Integer.MAX_VALUE) {
                    i = Integer.MAX_VALUE;
                } else if (i < Integer.MIN_VALUE) {
                    i = Integer.MIN_VALUE;
                }
                box.setText(String.valueOf(i));
                return;
            }
        }

        @Override
        public void applyTextBox(GT_GuiIntegerTextBox box) {
            long i;
            String s = box.getText().trim();
            try {
                i = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                this.resetTextBox(box);
                return;
            }
            if (i > Integer.MAX_VALUE) {
                i = Integer.MAX_VALUE;
            } else if (i < Integer.MIN_VALUE) {
                i = Integer.MIN_VALUE;
            }
            this.coverVariable = (int)i;
            this.fBox.setText(String.valueOf(this.coverVariable));
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
        }

        @Override
        public void resetTextBox(GT_GuiIntegerTextBox box) {
            box.setText(String.valueOf(this.coverVariable));
        }

        private class GT_GuiIntegerTextBoxWithMinus
        extends GT_GuiIntegerTextBox {
            public GT_GuiIntegerTextBoxWithMinus(IGuiScreen gui, int id, int x, int y, int width, int height) {
                super(gui, id, x, y, width, height);
            }

            @Override
            public boolean validChar(char c, int key) {
                if (this.getCursorPosition() == 0 && key == 12) {
                    return true;
                }
                return super.validChar(c, key);
            }
        }
    }
}

