/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_Pump
extends GT_CoverBehavior {
    public final int mTransferRate;

    public GT_Cover_Pump(int aTransferRate) {
        this.mTransferRate = aTransferRate;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        IFluidHandler tTank2;
        if (aCoverVariable % 6 > 1 && aTileEntity instanceof IMachineProgress && ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() != aCoverVariable % 6 < 4) {
            return aCoverVariable;
        }
        if (aTileEntity instanceof IFluidHandler && (tTank2 = aTileEntity.getITankContainerAtSide(aSide)) != null) {
            IFluidHandler tTank1 = (IFluidHandler)aTileEntity;
            if (aCoverVariable % 2 == 0) {
                FluidStack tLiquid = tTank1.drain(ForgeDirection.getOrientation((int)aSide), this.mTransferRate, false);
                if (tLiquid != null) {
                    tLiquid = tLiquid.copy();
                    tLiquid.amount = tTank2.fill(ForgeDirection.getOrientation((int)aSide).getOpposite(), tLiquid, false);
                    if (tLiquid.amount > 0 && this.canTransferFluid(tLiquid)) {
                        tTank2.fill(ForgeDirection.getOrientation((int)aSide).getOpposite(), tTank1.drain(ForgeDirection.getOrientation((int)aSide), tLiquid.amount, true), true);
                    }
                }
            } else {
                FluidStack tLiquid = tTank2.drain(ForgeDirection.getOrientation((int)aSide).getOpposite(), this.mTransferRate, false);
                if (tLiquid != null) {
                    tLiquid = tLiquid.copy();
                    tLiquid.amount = tTank1.fill(ForgeDirection.getOrientation((int)aSide), tLiquid, false);
                    if (tLiquid.amount > 0 && this.canTransferFluid(tLiquid)) {
                        tTank1.fill(ForgeDirection.getOrientation((int)aSide), tTank2.drain(ForgeDirection.getOrientation((int)aSide).getOpposite(), tLiquid.amount, true), true);
                    }
                }
            }
        }
        return aCoverVariable;
    }

    protected boolean canTransferFluid(FluidStack fluid) {
        return true;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.isSneaking() ? -1 : 1)) % 12) < 0) {
            aCoverVariable = 11;
        }
        switch (aCoverVariable) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("006", "Export"));
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("007", "Import"));
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("008", "Export (conditional)"));
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("009", "Import (conditional)"));
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("010", "Export (invert cond)"));
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("011", "Import (invert cond)"));
                break;
            }
            case 6: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("012", "Export allow Input"));
                break;
            }
            case 7: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("013", "Import allow Output"));
                break;
            }
            case 8: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("014", "Export allow Input (conditional)"));
                break;
            }
            case 9: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("015", "Import allow Output (conditional)"));
                break;
            }
            case 10: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("016", "Export allow Input (invert cond)"));
                break;
            }
            case 11: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("017", "Import allow Output (invert cond)"));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsRedstoneGoIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aCoverVariable > 1 && aTileEntity instanceof IMachineProgress && ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() != aCoverVariable % 6 < 4) {
            return false;
        }
        return aCoverVariable >= 6 || aCoverVariable % 2 != 0;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aCoverVariable > 1 && aTileEntity instanceof IMachineProgress && ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() != aCoverVariable % 6 < 4) {
            return false;
        }
        return aCoverVariable >= 6 || aCoverVariable % 2 == 0;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GT_PumpGUICover(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GT_PumpGUICover
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public GT_PumpGUICover(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            GT_GuiIconButton b = new GT_GuiIconButton(this, 0, 10, 25, GT_GuiIcon.EXPORT).setTooltipText(GT_Cover_Pump.this.trans("006", "Export"));
            b = new GT_GuiIconButton(this, 1, 28, 25, GT_GuiIcon.IMPORT).setTooltipText(GT_Cover_Pump.this.trans("007", "Import"));
            b = new GT_GuiIconButton(this, 2, 10, 43, GT_GuiIcon.CHECKMARK).setTooltipText(GT_Cover_Pump.this.trans("224", "Ignore"));
            b = new GT_GuiIconButton(this, 3, 28, 43, GT_GuiIcon.REDSTONE_ON).setTooltipText(GT_Cover_Pump.this.trans("225", "Conditional"));
            b = new GT_GuiIconButton(this, 4, 46, 43, GT_GuiIcon.REDSTONE_OFF).setTooltipText(GT_Cover_Pump.this.trans("226", "Invert Condition"));
            b = new GT_GuiIconButton(this, 5, 10, 61, GT_GuiIcon.ALLOW_INPUT).setTooltipText(GT_Cover_Pump.this.trans("227", "Allow Input"));
            b = new GT_GuiIconButton(this, 6, 28, 61, GT_GuiIcon.BLOCK_INPUT).setTooltipText(GT_Cover_Pump.this.trans("228", "Block Input"));
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.fontRendererObj.drawString(GT_Cover_Pump.this.trans("229", "Import/Export"), 64, 28, -11184811);
            this.fontRendererObj.drawString(GT_Cover_Pump.this.trans("230", "Conditional"), 64, 46, -11184811);
            this.fontRendererObj.drawString(GT_Cover_Pump.this.trans("231", "Enable Input"), 64, 64, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (this.getClickable(btn.id)) {
                this.coverVariable = this.getNewCoverVariable(btn.id);
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            for (Object o : this.buttonList) {
                GuiButton b = (GuiButton)o;
                b.enabled = this.getClickable(b.id);
            }
        }

        private int getNewCoverVariable(int id) {
            switch (id) {
                case 0: {
                    return this.coverVariable & 0xFFFFFFFE;
                }
                case 1: {
                    return this.coverVariable | 1;
                }
                case 2: {
                    if (this.coverVariable > 5) {
                        return 6 | this.coverVariable & 0xFFFFFFF1;
                    }
                    return this.coverVariable & 0xFFFFFFF1;
                }
                case 3: {
                    if (this.coverVariable > 5) {
                        return 8 | this.coverVariable & 0xFFFFFFF1;
                    }
                    return 2 | this.coverVariable & 0xFFFFFFF1;
                }
                case 4: {
                    if (this.coverVariable > 5) {
                        return 0xA | this.coverVariable & 0xFFFFFFF1;
                    }
                    return 4 | this.coverVariable & 0xFFFFFFF1;
                }
                case 5: {
                    if (this.coverVariable > 5) break;
                    return this.coverVariable + 6;
                }
                case 6: {
                    if (this.coverVariable <= 5) break;
                    return this.coverVariable - 6;
                }
            }
            return this.coverVariable;
        }

        private boolean getClickable(int id) {
            if (this.coverVariable < 0 | 11 < this.coverVariable) {
                return false;
            }
            switch (id) {
                case 0: 
                case 1: {
                    return (1 & this.coverVariable) != id;
                }
                case 2: {
                    return this.coverVariable % 6 >= 2;
                }
                case 3: {
                    return this.coverVariable % 6 < 2 | 4 <= this.coverVariable % 6;
                }
                case 4: {
                    return this.coverVariable % 6 < 4;
                }
                case 5: {
                    return this.coverVariable < 6;
                }
                case 6: {
                    return this.coverVariable >= 6;
                }
            }
            return false;
        }
    }
}

