/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;

@SideOnly(value=Side.CLIENT)
public class LightingHelper {
    public static final int NORMAL_BRIGHTNESS = 0xFF00FF;
    public static final int MAX_BRIGHTNESS = 0xF000F0;
    public static final float NO_Z_FIGHT_OFFSET = 9.765625E-4f;
    protected static final float[] LIGHTNESS = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    private final RenderBlocks renderBlocks;
    private int brightness;
    private float aoTopLeft;
    private float aoBottomLeft;
    private float aoBottomRight;
    private float aoTopRight;
    private boolean hasLightnessOverride;
    private float lightnessOverride;
    private boolean hasBrightnessOverride;
    private int brightnessOverride;
    private boolean hasColorOverride;
    private int colorOverride = 0xFFFFFF;

    public LightingHelper(RenderBlocks renderBlocks) {
        this.renderBlocks = renderBlocks;
        if (renderBlocks.useInventoryTint) {
            this.setLightnessOverride(1.0f);
        }
    }

    public static int getAverageBrightness(int brightnessA, int brightnessB) {
        int sectionA1 = brightnessA >> 16 & 0xFF;
        int sectionA2 = brightnessA & 0xFF;
        int sectionB1 = brightnessB >> 16 & 0xFF;
        int sectionB2 = brightnessB & 0xFF;
        int difference1 = (int)((float)(sectionA1 + sectionB1) / 2.0f);
        int difference2 = (int)((float)(sectionA2 + sectionB2) / 2.0f);
        return difference1 << 16 | difference2;
    }

    public static float[] getRGB(short[] color) {
        float red = (float)color[0] / 255.0f;
        float green = (float)color[1] / 255.0f;
        float blue = (float)color[2] / 255.0f;
        return new float[]{red, green, blue};
    }

    public void clearBrightnessOverride() {
        this.hasBrightnessOverride = false;
    }

    public void clearColorOverride() {
        this.hasColorOverride = false;
    }

    public void clearLightnessOverride() {
        this.hasLightnessOverride = false;
    }

    public float getAoBottomLeft() {
        return this.aoBottomLeft;
    }

    public float getAoBottomRight() {
        return this.aoBottomRight;
    }

    public float getAoTopLeft() {
        return this.aoTopLeft;
    }

    public float getAoTopRight() {
        return this.aoTopRight;
    }

    public LightingHelper setBrightnessOverride(int brightness) {
        this.hasBrightnessOverride = true;
        this.brightnessOverride = brightness;
        return this;
    }

    public LightingHelper setColorOverride(short[] color) {
        return this.setColorOverride(LightingHelper.getColor(color));
    }

    public LightingHelper setColorOverride(int color) {
        this.hasColorOverride = true;
        this.colorOverride = color;
        return this;
    }

    public static int getColor(short[] rgba) {
        return rgba[2] & 0xFF | (rgba[1] & 0xFF) << 8 | (rgba[0] & 0xFF) << 16;
    }

    public LightingHelper setLightnessOverride(float lightness) {
        this.hasLightnessOverride = true;
        this.lightnessOverride = lightness;
        return this;
    }

    public void setupColor(int side, short[] rgba) {
        this.setupColor(side, LightingHelper.getColor(rgba));
    }

    public void setupColor(int side, int hexColor) {
        Tessellator tessellator = Tessellator.instance;
        float lightness = this.hasLightnessOverride ? this.lightnessOverride : LIGHTNESS[side];
        float[] rgb = LightingHelper.getRGB(hexColor);
        if (this.hasColorOverride && !this.renderBlocks.hasOverrideBlockTexture()) {
            rgb = LightingHelper.getRGB(this.colorOverride);
        }
        this.applyAnaglyph(rgb);
        if (this.renderBlocks.enableAO) {
            tessellator.setBrightness(this.hasBrightnessOverride ? this.brightnessOverride : this.brightness);
            if (this.renderBlocks.hasOverrideBlockTexture()) {
                this.renderBlocks.colorRedBottomRight = this.renderBlocks.colorRedTopRight = rgb[0];
                this.renderBlocks.colorRedBottomLeft = this.renderBlocks.colorRedTopRight;
                this.renderBlocks.colorRedTopLeft = this.renderBlocks.colorRedTopRight;
                this.renderBlocks.colorGreenBottomRight = this.renderBlocks.colorGreenTopRight = rgb[1];
                this.renderBlocks.colorGreenBottomLeft = this.renderBlocks.colorGreenTopRight;
                this.renderBlocks.colorGreenTopLeft = this.renderBlocks.colorGreenTopRight;
                this.renderBlocks.colorBlueBottomRight = this.renderBlocks.colorBlueTopRight = rgb[2];
                this.renderBlocks.colorBlueBottomLeft = this.renderBlocks.colorBlueTopRight;
                this.renderBlocks.colorBlueTopLeft = this.renderBlocks.colorBlueTopRight;
            } else {
                this.renderBlocks.colorRedBottomRight = this.renderBlocks.colorRedTopRight = rgb[0] * lightness;
                this.renderBlocks.colorRedBottomLeft = this.renderBlocks.colorRedTopRight;
                this.renderBlocks.colorRedTopLeft = this.renderBlocks.colorRedTopRight;
                this.renderBlocks.colorGreenBottomRight = this.renderBlocks.colorGreenTopRight = rgb[1] * lightness;
                this.renderBlocks.colorGreenBottomLeft = this.renderBlocks.colorGreenTopRight;
                this.renderBlocks.colorGreenTopLeft = this.renderBlocks.colorGreenTopRight;
                this.renderBlocks.colorBlueBottomRight = this.renderBlocks.colorBlueTopRight = rgb[2] * lightness;
                this.renderBlocks.colorBlueBottomLeft = this.renderBlocks.colorBlueTopRight;
                this.renderBlocks.colorBlueTopLeft = this.renderBlocks.colorBlueTopRight;
                this.renderBlocks.colorRedTopLeft *= this.aoTopLeft;
                this.renderBlocks.colorGreenTopLeft *= this.aoTopLeft;
                this.renderBlocks.colorBlueTopLeft *= this.aoTopLeft;
                this.renderBlocks.colorRedBottomLeft *= this.aoBottomLeft;
                this.renderBlocks.colorGreenBottomLeft *= this.aoBottomLeft;
                this.renderBlocks.colorBlueBottomLeft *= this.aoBottomLeft;
                this.renderBlocks.colorRedBottomRight *= this.aoBottomRight;
                this.renderBlocks.colorGreenBottomRight *= this.aoBottomRight;
                this.renderBlocks.colorBlueBottomRight *= this.aoBottomRight;
                this.renderBlocks.colorRedTopRight *= this.aoTopRight;
                this.renderBlocks.colorGreenTopRight *= this.aoTopRight;
                this.renderBlocks.colorBlueTopRight *= this.aoTopRight;
            }
        } else {
            tessellator.setColorOpaque_F(rgb[0] * lightness, rgb[1] * lightness, rgb[2] * lightness);
        }
    }

    public static float[] getRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return new float[]{red, green, blue};
    }

    public void applyAnaglyph(float[] rgb) {
        if (EntityRenderer.anaglyphEnable) {
            rgb[0] = (rgb[0] * 30.0f + rgb[1] * 59.0f + rgb[2] * 11.0f) / 100.0f;
            rgb[1] = (rgb[0] * 30.0f + rgb[1] * 70.0f) / 100.0f;
            rgb[2] = (rgb[0] * 30.0f + rgb[2] * 70.0f) / 100.0f;
        }
    }

    public static float getMixedAo(float ao1, float ao2, double ratio) {
        float diff = (float)((double)Math.abs(ao1 - ao2) * (1.0 - ratio));
        return ao1 > ao2 ? ao1 - diff : ao1 + diff;
    }

    public LightingHelper setupLightingXNeg(Block block, int x, int y, int z) {
        if (this.renderBlocks.enableAO) {
            int mixedBrightness;
            int xOffset = this.renderBlocks.renderMinX > 9.765625E-4 ? x : x - 1;
            this.brightness = mixedBrightness = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y, z);
            float ratio = (float)(1.0 - this.renderBlocks.renderMinX);
            float aoLightValue = this.renderBlocks.blockAccess.getBlock(x - 1, y, z).getAmbientOcclusionLightValue();
            this.renderBlocks.aoBrightnessXYNN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y - 1, z);
            this.renderBlocks.aoBrightnessXZNN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y, z - 1);
            this.renderBlocks.aoBrightnessXZNP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y, z + 1);
            this.renderBlocks.aoBrightnessXYNP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y + 1, z);
            this.renderBlocks.aoBrightnessXYZNNN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y - 1, z - 1);
            this.renderBlocks.aoBrightnessXYZNNP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y - 1, z + 1);
            this.renderBlocks.aoBrightnessXYZNPN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y + 1, z - 1);
            this.renderBlocks.aoBrightnessXYZNPP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y + 1, z + 1);
            this.renderBlocks.aoLightValueScratchXYNN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y - 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y - 1, z).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXZNN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y, z - 1).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXZNP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y, z + 1).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYNP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y + 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y + 1, z).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYZNNN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y - 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y - 1, z - 1).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYZNNP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y - 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y - 1, z + 1).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYZNPN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y + 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y + 1, z - 1).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYZNPP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y + 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y + 1, z + 1).getAmbientOcclusionLightValue(), ratio);
            int brightnessMixedXYZNPN = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXZNN, this.renderBlocks.aoBrightnessXYZNPN, this.renderBlocks.aoBrightnessXYNP, mixedBrightness);
            int brightnessMixedXYZNNN = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXYZNNN, this.renderBlocks.aoBrightnessXYNN, this.renderBlocks.aoBrightnessXZNN, mixedBrightness);
            int brightnessMixedXYZNNP = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXYNN, this.renderBlocks.aoBrightnessXYZNNP, this.renderBlocks.aoBrightnessXZNP, mixedBrightness);
            int brightnessMixedXYZNPP = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXZNP, this.renderBlocks.aoBrightnessXYNP, this.renderBlocks.aoBrightnessXYZNPP, mixedBrightness);
            float aoMixedXYZNPN = (this.renderBlocks.aoLightValueScratchXZNN + aoLightValue + this.renderBlocks.aoLightValueScratchXYZNPN + this.renderBlocks.aoLightValueScratchXYNP) / 4.0f;
            float aoMixedXYZNNN = (this.renderBlocks.aoLightValueScratchXYZNNN + this.renderBlocks.aoLightValueScratchXYNN + this.renderBlocks.aoLightValueScratchXZNN + aoLightValue) / 4.0f;
            float aoMixedXYZNNP = (this.renderBlocks.aoLightValueScratchXYNN + this.renderBlocks.aoLightValueScratchXYZNNP + aoLightValue + this.renderBlocks.aoLightValueScratchXZNP) / 4.0f;
            float aoMixedXYZNPP = (aoLightValue + this.renderBlocks.aoLightValueScratchXZNP + this.renderBlocks.aoLightValueScratchXYNP + this.renderBlocks.aoLightValueScratchXYZNPP) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNPP * this.renderBlocks.renderMaxY * this.renderBlocks.renderMaxZ + (double)aoMixedXYZNPN * this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMaxZ) + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMaxZ) + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMaxZ);
            this.aoBottomLeft = (float)((double)aoMixedXYZNPP * this.renderBlocks.renderMaxY * this.renderBlocks.renderMinZ + (double)aoMixedXYZNPN * this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMinZ) + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMinZ) + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMinZ);
            this.aoBottomRight = (float)((double)aoMixedXYZNPP * this.renderBlocks.renderMinY * this.renderBlocks.renderMinZ + (double)aoMixedXYZNPN * this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMinZ) + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMinZ) + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMinZ);
            this.aoTopRight = (float)((double)aoMixedXYZNPP * this.renderBlocks.renderMinY * this.renderBlocks.renderMaxZ + (double)aoMixedXYZNPN * this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMaxZ) + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMaxZ) + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMaxZ);
            this.renderBlocks.brightnessTopLeft = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPP, brightnessMixedXYZNPN, brightnessMixedXYZNNN, brightnessMixedXYZNNP, this.renderBlocks.renderMaxY * this.renderBlocks.renderMaxZ, this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMaxZ), (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMaxZ), (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMaxZ);
            this.renderBlocks.brightnessBottomLeft = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPP, brightnessMixedXYZNPN, brightnessMixedXYZNNN, brightnessMixedXYZNNP, this.renderBlocks.renderMaxY * this.renderBlocks.renderMinZ, this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMinZ), (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMinZ), (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMinZ);
            this.renderBlocks.brightnessBottomRight = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPP, brightnessMixedXYZNPN, brightnessMixedXYZNNN, brightnessMixedXYZNNP, this.renderBlocks.renderMinY * this.renderBlocks.renderMinZ, this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMinZ), (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMinZ), (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMinZ);
            this.renderBlocks.brightnessTopRight = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPP, brightnessMixedXYZNPN, brightnessMixedXYZNNN, brightnessMixedXYZNNP, this.renderBlocks.renderMinY * this.renderBlocks.renderMaxZ, this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMaxZ), (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMaxZ), (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMaxZ);
        }
        return this;
    }

    public LightingHelper setupLightingXPos(Block block, int x, int y, int z) {
        if (this.renderBlocks.enableAO) {
            int mixedBrightness;
            int xOffset = this.renderBlocks.renderMaxX < 0.9990234375 ? x : x + 1;
            this.brightness = mixedBrightness = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y, z);
            float aoLightValue = this.renderBlocks.blockAccess.getBlock(x + 1, y, z).getAmbientOcclusionLightValue();
            this.renderBlocks.aoBrightnessXYPN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y - 1, z);
            this.renderBlocks.aoBrightnessXZPN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y, z - 1);
            this.renderBlocks.aoBrightnessXZPP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y, z + 1);
            this.renderBlocks.aoBrightnessXYPP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y + 1, z);
            this.renderBlocks.aoBrightnessXYZPNN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y - 1, z - 1);
            this.renderBlocks.aoBrightnessXYZPNP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y - 1, z + 1);
            this.renderBlocks.aoBrightnessXYZPPN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y + 1, z - 1);
            this.renderBlocks.aoBrightnessXYZPPP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, xOffset, y + 1, z + 1);
            this.renderBlocks.aoLightValueScratchXYPN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y - 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y - 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxX);
            this.renderBlocks.aoLightValueScratchXZPN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxX);
            this.renderBlocks.aoLightValueScratchXZPP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxX);
            this.renderBlocks.aoLightValueScratchXYPP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y + 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y + 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxX);
            this.renderBlocks.aoLightValueScratchXYZPNN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y - 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y - 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxX);
            this.renderBlocks.aoLightValueScratchXYZPNP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y - 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y - 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxX);
            this.renderBlocks.aoLightValueScratchXYZPPN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y + 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y + 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxX);
            this.renderBlocks.aoLightValueScratchXYZPPP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y + 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y + 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxX);
            int brightnessMixedXYZPPP = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXZPP, this.renderBlocks.aoBrightnessXYPP, this.renderBlocks.aoBrightnessXYZPPP, mixedBrightness);
            int brightnessMixedXYZPNP = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXYPN, this.renderBlocks.aoBrightnessXYZPNP, this.renderBlocks.aoBrightnessXZPP, mixedBrightness);
            int brightnessMixedXYZPNN = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXYZPNN, this.renderBlocks.aoBrightnessXYPN, this.renderBlocks.aoBrightnessXZPN, mixedBrightness);
            int brightnessMixedXYZPPN = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXZPN, this.renderBlocks.aoBrightnessXYZPPN, this.renderBlocks.aoBrightnessXYPP, mixedBrightness);
            float aoMixedXYZPPP = (aoLightValue + this.renderBlocks.aoLightValueScratchXZPP + this.renderBlocks.aoLightValueScratchXYPP + this.renderBlocks.aoLightValueScratchXYZPPP) / 4.0f;
            float aoMixedXYZPNP = (this.renderBlocks.aoLightValueScratchXYPN + this.renderBlocks.aoLightValueScratchXYZPNP + aoLightValue + this.renderBlocks.aoLightValueScratchXZPP) / 4.0f;
            float aoMixedXYZPNN = (this.renderBlocks.aoLightValueScratchXYZPNN + this.renderBlocks.aoLightValueScratchXYPN + this.renderBlocks.aoLightValueScratchXZPN + aoLightValue) / 4.0f;
            float aoMixedXYZPPN = (this.renderBlocks.aoLightValueScratchXZPN + aoLightValue + this.renderBlocks.aoLightValueScratchXYZPPN + this.renderBlocks.aoLightValueScratchXYPP) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZPNP * (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMaxZ + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMaxZ) + (double)aoMixedXYZPPN * this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMaxZ) + (double)aoMixedXYZPPP * this.renderBlocks.renderMinY * this.renderBlocks.renderMaxZ);
            this.aoBottomLeft = (float)((double)aoMixedXYZPNP * (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMinZ + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMinZ) + (double)aoMixedXYZPPN * this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMinZ) + (double)aoMixedXYZPPP * this.renderBlocks.renderMinY * this.renderBlocks.renderMinZ);
            this.aoBottomRight = (float)((double)aoMixedXYZPNP * (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMinZ + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMinZ) + (double)aoMixedXYZPPN * this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMinZ) + (double)aoMixedXYZPPP * this.renderBlocks.renderMaxY * this.renderBlocks.renderMinZ);
            this.aoTopRight = (float)((double)aoMixedXYZPNP * (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMaxZ + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMaxZ) + (double)aoMixedXYZPPN * this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMaxZ) + (double)aoMixedXYZPPP * this.renderBlocks.renderMaxY * this.renderBlocks.renderMaxZ);
            this.renderBlocks.brightnessTopLeft = this.renderBlocks.mixAoBrightness(brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZPPN, brightnessMixedXYZPPP, (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMaxZ, (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMaxZ), this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMaxZ), this.renderBlocks.renderMinY * this.renderBlocks.renderMaxZ);
            this.renderBlocks.brightnessBottomLeft = this.renderBlocks.mixAoBrightness(brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZPPN, brightnessMixedXYZPPP, (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMinZ, (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMinZ), this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMinZ), this.renderBlocks.renderMinY * this.renderBlocks.renderMinZ);
            this.renderBlocks.brightnessBottomRight = this.renderBlocks.mixAoBrightness(brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZPPN, brightnessMixedXYZPPP, (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMinZ, (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMinZ), this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMinZ), this.renderBlocks.renderMaxY * this.renderBlocks.renderMinZ);
            this.renderBlocks.brightnessTopRight = this.renderBlocks.mixAoBrightness(brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZPPN, brightnessMixedXYZPPP, (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMaxZ, (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMaxZ), this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMaxZ), this.renderBlocks.renderMaxY * this.renderBlocks.renderMaxZ);
        }
        return this;
    }

    public LightingHelper setupLightingYNeg(Block block, int x, int y, int z) {
        if (this.renderBlocks.enableAO) {
            int mixedBrightness;
            int yOffset = this.renderBlocks.renderMinY > 9.765625E-4 ? y : y - 1;
            this.brightness = mixedBrightness = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x, yOffset, z);
            float ratio = (float)(1.0 - this.renderBlocks.renderMinY);
            float aoLightValue = this.renderBlocks.blockAccess.getBlock(x, y - 1, z).getAmbientOcclusionLightValue();
            this.renderBlocks.aoBrightnessXYNN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x - 1, yOffset, z);
            this.renderBlocks.aoBrightnessYZNN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x, yOffset, z - 1);
            this.renderBlocks.aoBrightnessYZNP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x, yOffset, z + 1);
            this.renderBlocks.aoBrightnessXYPN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x + 1, yOffset, z);
            this.renderBlocks.aoBrightnessXYZNNN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x - 1, yOffset, z - 1);
            this.renderBlocks.aoBrightnessXYZNNP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x - 1, yOffset, z + 1);
            this.renderBlocks.aoBrightnessXYZPNN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x + 1, yOffset, z - 1);
            this.renderBlocks.aoBrightnessXYZPNP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x + 1, yOffset, z + 1);
            this.renderBlocks.aoLightValueScratchXYNN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y - 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x - 1, y, z).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchYZNN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x, y - 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y, z - 1).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchYZNP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x, y - 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y, z + 1).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYPN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y - 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x + 1, y, z).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYZNNN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y - 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x - 1, y, z - 1).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYZNNP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y - 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x - 1, y, z + 1).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYZPNN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y - 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x + 1, y, z - 1).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYZPNP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y - 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x + 1, y, z + 1).getAmbientOcclusionLightValue(), ratio);
            int brightnessMixedXYZPNP = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessYZNP, this.renderBlocks.aoBrightnessXYZPNP, this.renderBlocks.aoBrightnessXYPN, mixedBrightness);
            int brightnessMixedXYZPNN = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessYZNN, this.renderBlocks.aoBrightnessXYPN, this.renderBlocks.aoBrightnessXYZPNN, mixedBrightness);
            int brightnessMixedXYZNNN = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXYNN, this.renderBlocks.aoBrightnessXYZNNN, this.renderBlocks.aoBrightnessYZNN, mixedBrightness);
            int brightnessMixedXYZNNP = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXYZNNP, this.renderBlocks.aoBrightnessXYNN, this.renderBlocks.aoBrightnessYZNP, mixedBrightness);
            float aoMixedXYZPNP = (this.renderBlocks.aoLightValueScratchYZNP + aoLightValue + this.renderBlocks.aoLightValueScratchXYZPNP + this.renderBlocks.aoLightValueScratchXYPN) / 4.0f;
            float aoMixedXYZPNN = (aoLightValue + this.renderBlocks.aoLightValueScratchYZNN + this.renderBlocks.aoLightValueScratchXYPN + this.renderBlocks.aoLightValueScratchXYZPNN) / 4.0f;
            float aoMixedXYZNNN = (this.renderBlocks.aoLightValueScratchXYNN + this.renderBlocks.aoLightValueScratchXYZNNN + aoLightValue + this.renderBlocks.aoLightValueScratchYZNN) / 4.0f;
            float aoMixedXYZNNP = (this.renderBlocks.aoLightValueScratchXYZNNP + this.renderBlocks.aoLightValueScratchXYNN + this.renderBlocks.aoLightValueScratchYZNP + aoLightValue) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNNP * this.renderBlocks.renderMaxZ * (1.0 - this.renderBlocks.renderMinX) + (double)aoMixedXYZPNP * this.renderBlocks.renderMaxZ * this.renderBlocks.renderMinX + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.renderMaxZ) * this.renderBlocks.renderMinX + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.renderMaxZ) * (1.0 - this.renderBlocks.renderMinX));
            this.aoBottomLeft = (float)((double)aoMixedXYZNNP * this.renderBlocks.renderMinZ * (1.0 - this.renderBlocks.renderMinX) + (double)aoMixedXYZPNP * this.renderBlocks.renderMinZ * this.renderBlocks.renderMinX + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.renderMinZ) * this.renderBlocks.renderMinX + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.renderMinZ) * (1.0 - this.renderBlocks.renderMinX));
            this.aoBottomRight = (float)((double)aoMixedXYZNNP * this.renderBlocks.renderMinZ * (1.0 - this.renderBlocks.renderMaxX) + (double)aoMixedXYZPNP * this.renderBlocks.renderMinZ * this.renderBlocks.renderMaxX + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.renderMinZ) * this.renderBlocks.renderMaxX + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.renderMinZ) * (1.0 - this.renderBlocks.renderMaxX));
            this.aoTopRight = (float)((double)aoMixedXYZNNP * this.renderBlocks.renderMaxZ * (1.0 - this.renderBlocks.renderMaxX) + (double)aoMixedXYZPNP * this.renderBlocks.renderMaxZ * this.renderBlocks.renderMaxX + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.renderMaxZ) * this.renderBlocks.renderMaxX + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.renderMaxZ) * (1.0 - this.renderBlocks.renderMaxX));
            this.renderBlocks.brightnessTopLeft = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.renderMaxZ * (1.0 - this.renderBlocks.renderMinX), this.renderBlocks.renderMaxZ * this.renderBlocks.renderMinX, (1.0 - this.renderBlocks.renderMaxZ) * this.renderBlocks.renderMinX, (1.0 - this.renderBlocks.renderMaxZ) * (1.0 - this.renderBlocks.renderMinX));
            this.renderBlocks.brightnessBottomLeft = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.renderMinZ * (1.0 - this.renderBlocks.renderMinX), this.renderBlocks.renderMinZ * this.renderBlocks.renderMinX, (1.0 - this.renderBlocks.renderMinZ) * this.renderBlocks.renderMinX, (1.0 - this.renderBlocks.renderMinZ) * (1.0 - this.renderBlocks.renderMinX));
            this.renderBlocks.brightnessBottomRight = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.renderMinZ * (1.0 - this.renderBlocks.renderMaxX), this.renderBlocks.renderMinZ * this.renderBlocks.renderMaxX, (1.0 - this.renderBlocks.renderMinZ) * this.renderBlocks.renderMaxX, (1.0 - this.renderBlocks.renderMinZ) * (1.0 - this.renderBlocks.renderMaxX));
            this.renderBlocks.brightnessTopRight = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.renderMaxZ * (1.0 - this.renderBlocks.renderMaxX), this.renderBlocks.renderMaxZ * this.renderBlocks.renderMaxX, (1.0 - this.renderBlocks.renderMaxZ) * this.renderBlocks.renderMaxX, (1.0 - this.renderBlocks.renderMaxZ) * (1.0 - this.renderBlocks.renderMaxX));
        }
        return this;
    }

    public LightingHelper setupLightingYPos(Block block, int x, int y, int z) {
        if (this.renderBlocks.enableAO) {
            int mixedBrightness;
            int yOffset = this.renderBlocks.renderMaxY < 0.9990234375 ? y : y + 1;
            this.brightness = mixedBrightness = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x, yOffset, z);
            float aoLightValue = this.renderBlocks.blockAccess.getBlock(x, y + 1, z).getAmbientOcclusionLightValue();
            this.renderBlocks.aoBrightnessXYNP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x - 1, yOffset, z);
            this.renderBlocks.aoBrightnessXYPP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x + 1, yOffset, z);
            this.renderBlocks.aoBrightnessYZPN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x, yOffset, z - 1);
            this.renderBlocks.aoBrightnessYZPP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x, yOffset, z + 1);
            this.renderBlocks.aoBrightnessXYZNPN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x - 1, yOffset, z - 1);
            this.renderBlocks.aoBrightnessXYZPPN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x + 1, yOffset, z - 1);
            this.renderBlocks.aoBrightnessXYZNPP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x - 1, yOffset, z + 1);
            this.renderBlocks.aoBrightnessXYZPPP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x + 1, yOffset, z + 1);
            this.renderBlocks.aoLightValueScratchXYNP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y + 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x - 1, y, z).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxY);
            this.renderBlocks.aoLightValueScratchXYPP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y + 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x + 1, y, z).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxY);
            this.renderBlocks.aoLightValueScratchYZPN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x, y + 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxY);
            this.renderBlocks.aoLightValueScratchYZPP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x, y + 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxY);
            this.renderBlocks.aoLightValueScratchXYZNPN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y + 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x - 1, y, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxY);
            this.renderBlocks.aoLightValueScratchXYZPPN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y + 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x + 1, y, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxY);
            this.renderBlocks.aoLightValueScratchXYZNPP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y + 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x - 1, y, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxY);
            this.renderBlocks.aoLightValueScratchXYZPPP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y + 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x + 1, y, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxY);
            int brightnessMixedXYZPPP = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessYZPP, this.renderBlocks.aoBrightnessXYZPPP, this.renderBlocks.aoBrightnessXYPP, mixedBrightness);
            int brightnessMixedXYZPPN = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessYZPN, this.renderBlocks.aoBrightnessXYPP, this.renderBlocks.aoBrightnessXYZPPN, mixedBrightness);
            int brightnessMixedXYZNPN = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXYNP, this.renderBlocks.aoBrightnessXYZNPN, this.renderBlocks.aoBrightnessYZPN, mixedBrightness);
            int brightnessMixedXYZNPP = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXYZNPP, this.renderBlocks.aoBrightnessXYNP, this.renderBlocks.aoBrightnessYZPP, mixedBrightness);
            float aoMixedXYZPPP = (this.renderBlocks.aoLightValueScratchYZPP + aoLightValue + this.renderBlocks.aoLightValueScratchXYZPPP + this.renderBlocks.aoLightValueScratchXYPP) / 4.0f;
            float aoMixedXYZPPN = (aoLightValue + this.renderBlocks.aoLightValueScratchYZPN + this.renderBlocks.aoLightValueScratchXYPP + this.renderBlocks.aoLightValueScratchXYZPPN) / 4.0f;
            float aoMixedXYZNPN = (this.renderBlocks.aoLightValueScratchXYNP + this.renderBlocks.aoLightValueScratchXYZNPN + aoLightValue + this.renderBlocks.aoLightValueScratchYZPN) / 4.0f;
            float aoMixedXYZNPP = (this.renderBlocks.aoLightValueScratchXYZNPP + this.renderBlocks.aoLightValueScratchXYNP + this.renderBlocks.aoLightValueScratchYZPP + aoLightValue) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNPP * this.renderBlocks.renderMaxZ * (1.0 - this.renderBlocks.renderMaxX) + (double)aoMixedXYZPPP * this.renderBlocks.renderMaxZ * this.renderBlocks.renderMaxX + (double)aoMixedXYZPPN * (1.0 - this.renderBlocks.renderMaxZ) * this.renderBlocks.renderMaxX + (double)aoMixedXYZNPN * (1.0 - this.renderBlocks.renderMaxZ) * (1.0 - this.renderBlocks.renderMaxX));
            this.aoBottomLeft = (float)((double)aoMixedXYZNPP * this.renderBlocks.renderMinZ * (1.0 - this.renderBlocks.renderMaxX) + (double)aoMixedXYZPPP * this.renderBlocks.renderMinZ * this.renderBlocks.renderMaxX + (double)aoMixedXYZPPN * (1.0 - this.renderBlocks.renderMinZ) * this.renderBlocks.renderMaxX + (double)aoMixedXYZNPN * (1.0 - this.renderBlocks.renderMinZ) * (1.0 - this.renderBlocks.renderMaxX));
            this.aoBottomRight = (float)((double)aoMixedXYZNPP * this.renderBlocks.renderMinZ * (1.0 - this.renderBlocks.renderMinX) + (double)aoMixedXYZPPP * this.renderBlocks.renderMinZ * this.renderBlocks.renderMinX + (double)aoMixedXYZPPN * (1.0 - this.renderBlocks.renderMinZ) * this.renderBlocks.renderMinX + (double)aoMixedXYZNPN * (1.0 - this.renderBlocks.renderMinZ) * (1.0 - this.renderBlocks.renderMinX));
            this.aoTopRight = (float)((double)aoMixedXYZNPP * this.renderBlocks.renderMaxZ * (1.0 - this.renderBlocks.renderMinX) + (double)aoMixedXYZPPP * this.renderBlocks.renderMaxZ * this.renderBlocks.renderMinX + (double)aoMixedXYZPPN * (1.0 - this.renderBlocks.renderMaxZ) * this.renderBlocks.renderMinX + (double)aoMixedXYZNPN * (1.0 - this.renderBlocks.renderMaxZ) * (1.0 - this.renderBlocks.renderMinX));
            this.renderBlocks.brightnessTopLeft = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPP, brightnessMixedXYZPPP, brightnessMixedXYZPPN, brightnessMixedXYZNPN, this.renderBlocks.renderMaxZ * (1.0 - this.renderBlocks.renderMaxX), this.renderBlocks.renderMaxZ * this.renderBlocks.renderMaxX, (1.0 - this.renderBlocks.renderMaxZ) * this.renderBlocks.renderMaxX, (1.0 - this.renderBlocks.renderMaxZ) * (1.0 - this.renderBlocks.renderMaxX));
            this.renderBlocks.brightnessBottomLeft = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPP, brightnessMixedXYZPPP, brightnessMixedXYZPPN, brightnessMixedXYZNPN, this.renderBlocks.renderMinZ * (1.0 - this.renderBlocks.renderMaxX), this.renderBlocks.renderMinZ * this.renderBlocks.renderMaxX, (1.0 - this.renderBlocks.renderMinZ) * this.renderBlocks.renderMaxX, (1.0 - this.renderBlocks.renderMinZ) * (1.0 - this.renderBlocks.renderMaxX));
            this.renderBlocks.brightnessBottomRight = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPP, brightnessMixedXYZPPP, brightnessMixedXYZPPN, brightnessMixedXYZNPN, this.renderBlocks.renderMinZ * (1.0 - this.renderBlocks.renderMinX), this.renderBlocks.renderMinZ * this.renderBlocks.renderMinX, (1.0 - this.renderBlocks.renderMinZ) * this.renderBlocks.renderMinX, (1.0 - this.renderBlocks.renderMinZ) * (1.0 - this.renderBlocks.renderMinX));
            this.renderBlocks.brightnessTopRight = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPP, brightnessMixedXYZPPP, brightnessMixedXYZPPN, brightnessMixedXYZNPN, this.renderBlocks.renderMaxZ * (1.0 - this.renderBlocks.renderMinX), this.renderBlocks.renderMaxZ * this.renderBlocks.renderMinX, (1.0 - this.renderBlocks.renderMaxZ) * this.renderBlocks.renderMinX, (1.0 - this.renderBlocks.renderMaxZ) * (1.0 - this.renderBlocks.renderMinX));
        }
        return this;
    }

    public LightingHelper setupLightingZNeg(Block block, int x, int y, int z) {
        if (this.renderBlocks.enableAO) {
            int mixedBrightness;
            int zOffset = this.renderBlocks.renderMinZ > 9.765625E-4 ? z : z - 1;
            this.brightness = mixedBrightness = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x, y, zOffset);
            float ratio = (float)(1.0 - this.renderBlocks.renderMinZ);
            float aoLightValue = this.renderBlocks.blockAccess.getBlock(x, y, z - 1).getAmbientOcclusionLightValue();
            this.renderBlocks.aoBrightnessXZNN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x - 1, y, zOffset);
            this.renderBlocks.aoBrightnessYZNN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x, y - 1, zOffset);
            this.renderBlocks.aoBrightnessYZPN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x, y + 1, zOffset);
            this.renderBlocks.aoBrightnessXZPN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x + 1, y, zOffset);
            this.renderBlocks.aoBrightnessXYZNNN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x - 1, y - 1, zOffset);
            this.renderBlocks.aoBrightnessXYZNPN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x - 1, y + 1, zOffset);
            this.renderBlocks.aoBrightnessXYZPNN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x + 1, y - 1, zOffset);
            this.renderBlocks.aoBrightnessXYZPPN = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x + 1, y + 1, zOffset);
            this.renderBlocks.aoLightValueScratchXZNN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x - 1, y, z).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchYZNN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x, y - 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y - 1, z).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchYZPN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x, y + 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y + 1, z).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXZPN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x + 1, y, z).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYZNNN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y - 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x - 1, y - 1, z).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYZNPN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y + 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x - 1, y + 1, z).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYZPNN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y - 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x + 1, y - 1, z).getAmbientOcclusionLightValue(), ratio);
            this.renderBlocks.aoLightValueScratchXYZPPN = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y + 1, z - 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x + 1, y + 1, z).getAmbientOcclusionLightValue(), ratio);
            int brightnessMixedXYZPPN = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessYZPN, this.renderBlocks.aoBrightnessXZPN, this.renderBlocks.aoBrightnessXYZPPN, mixedBrightness);
            int brightnessMixedXYZPNN = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessYZNN, this.renderBlocks.aoBrightnessXYZPNN, this.renderBlocks.aoBrightnessXZPN, mixedBrightness);
            int brightnessMixedXYZNNN = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXYZNNN, this.renderBlocks.aoBrightnessXZNN, this.renderBlocks.aoBrightnessYZNN, mixedBrightness);
            int brightnessMixedXYZNPN = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXZNN, this.renderBlocks.aoBrightnessXYZNPN, this.renderBlocks.aoBrightnessYZPN, mixedBrightness);
            float aoMixedXYZPPN = (aoLightValue + this.renderBlocks.aoLightValueScratchYZPN + this.renderBlocks.aoLightValueScratchXZPN + this.renderBlocks.aoLightValueScratchXYZPPN) / 4.0f;
            float aoMixedXYZPNN = (this.renderBlocks.aoLightValueScratchYZNN + aoLightValue + this.renderBlocks.aoLightValueScratchXYZPNN + this.renderBlocks.aoLightValueScratchXZPN) / 4.0f;
            float aoMixedXYZNNN = (this.renderBlocks.aoLightValueScratchXYZNNN + this.renderBlocks.aoLightValueScratchXZNN + this.renderBlocks.aoLightValueScratchYZNN + aoLightValue) / 4.0f;
            float aoMixedXYZNPN = (this.renderBlocks.aoLightValueScratchXZNN + this.renderBlocks.aoLightValueScratchXYZNPN + aoLightValue + this.renderBlocks.aoLightValueScratchYZPN) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNPN * this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMinX) + (double)aoMixedXYZPPN * this.renderBlocks.renderMaxY * this.renderBlocks.renderMinX + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMinX + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMinX));
            this.aoBottomLeft = (float)((double)aoMixedXYZNPN * this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMaxX) + (double)aoMixedXYZPPN * this.renderBlocks.renderMaxY * this.renderBlocks.renderMaxX + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMaxX + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMaxX));
            this.aoBottomRight = (float)((double)aoMixedXYZNPN * this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMaxX) + (double)aoMixedXYZPPN * this.renderBlocks.renderMinY * this.renderBlocks.renderMaxX + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMaxX + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMaxX));
            this.aoTopRight = (float)((double)aoMixedXYZNPN * this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMinX) + (double)aoMixedXYZPPN * this.renderBlocks.renderMinY * this.renderBlocks.renderMinX + (double)aoMixedXYZPNN * (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMinX + (double)aoMixedXYZNNN * (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMinX));
            this.renderBlocks.brightnessTopLeft = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPN, brightnessMixedXYZPPN, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMinX), this.renderBlocks.renderMaxY * this.renderBlocks.renderMinX, (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMinX, (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMinX));
            this.renderBlocks.brightnessBottomLeft = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPN, brightnessMixedXYZPPN, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMaxX), this.renderBlocks.renderMaxY * this.renderBlocks.renderMaxX, (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMaxX, (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMaxX));
            this.renderBlocks.brightnessBottomRight = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPN, brightnessMixedXYZPPN, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMaxX), this.renderBlocks.renderMinY * this.renderBlocks.renderMaxX, (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMaxX, (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMaxX));
            this.renderBlocks.brightnessTopRight = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPN, brightnessMixedXYZPPN, brightnessMixedXYZPNN, brightnessMixedXYZNNN, this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMinX), this.renderBlocks.renderMinY * this.renderBlocks.renderMinX, (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMinX, (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMinX));
        }
        return this;
    }

    public LightingHelper setupLightingZPos(Block block, int x, int y, int z) {
        if (this.renderBlocks.enableAO) {
            int mixedBrightness;
            int zOffset = this.renderBlocks.renderMaxZ < 0.9990234375 ? z : z + 1;
            this.brightness = mixedBrightness = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x, y, zOffset);
            float aoLightValue = this.renderBlocks.blockAccess.getBlock(x, y, z + 1).getAmbientOcclusionLightValue();
            this.renderBlocks.aoBrightnessXZNP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x - 1, y, zOffset);
            this.renderBlocks.aoBrightnessXZPP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x + 1, y, zOffset);
            this.renderBlocks.aoBrightnessYZNP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x, y - 1, zOffset);
            this.renderBlocks.aoBrightnessYZPP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x, y + 1, zOffset);
            this.renderBlocks.aoBrightnessXYZNNP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x - 1, y - 1, zOffset);
            this.renderBlocks.aoBrightnessXYZNPP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x - 1, y + 1, zOffset);
            this.renderBlocks.aoBrightnessXYZPNP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x + 1, y - 1, zOffset);
            this.renderBlocks.aoBrightnessXYZPPP = block.getMixedBrightnessForBlock(this.renderBlocks.blockAccess, x + 1, y + 1, zOffset);
            this.renderBlocks.aoLightValueScratchXZNP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x - 1, y, z).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxZ);
            this.renderBlocks.aoLightValueScratchXZPP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x + 1, y, z).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxZ);
            this.renderBlocks.aoLightValueScratchYZNP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x, y - 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y - 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxZ);
            this.renderBlocks.aoLightValueScratchYZPP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x, y + 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x, y + 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxZ);
            this.renderBlocks.aoLightValueScratchXYZNNP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y - 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x - 1, y - 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxZ);
            this.renderBlocks.aoLightValueScratchXYZNPP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x - 1, y + 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x - 1, y + 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxZ);
            this.renderBlocks.aoLightValueScratchXYZPNP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y - 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x + 1, y - 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxZ);
            this.renderBlocks.aoLightValueScratchXYZPPP = LightingHelper.getMixedAo(this.renderBlocks.blockAccess.getBlock(x + 1, y + 1, z + 1).getAmbientOcclusionLightValue(), this.renderBlocks.blockAccess.getBlock(x + 1, y + 1, z).getAmbientOcclusionLightValue(), this.renderBlocks.renderMaxZ);
            int brightnessMixedXYZNPP = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXZNP, this.renderBlocks.aoBrightnessXYZNPP, this.renderBlocks.aoBrightnessYZPP, mixedBrightness);
            int brightnessMixedXYZNNP = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessXYZNNP, this.renderBlocks.aoBrightnessXZNP, this.renderBlocks.aoBrightnessYZNP, mixedBrightness);
            int brightnessMixedXYZPNP = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessYZNP, this.renderBlocks.aoBrightnessXYZPNP, this.renderBlocks.aoBrightnessXZPP, mixedBrightness);
            int brightnessMixedXYZPPP = this.renderBlocks.getAoBrightness(this.renderBlocks.aoBrightnessYZPP, this.renderBlocks.aoBrightnessXZPP, this.renderBlocks.aoBrightnessXYZPPP, mixedBrightness);
            float aoMixedXYZNPP = (this.renderBlocks.aoLightValueScratchXZNP + this.renderBlocks.aoLightValueScratchXYZNPP + aoLightValue + this.renderBlocks.aoLightValueScratchYZPP) / 4.0f;
            float aoMixedXYZNNP = (this.renderBlocks.aoLightValueScratchXYZNNP + this.renderBlocks.aoLightValueScratchXZNP + this.renderBlocks.aoLightValueScratchYZNP + aoLightValue) / 4.0f;
            float aoMixedXYZPNP = (this.renderBlocks.aoLightValueScratchYZNP + aoLightValue + this.renderBlocks.aoLightValueScratchXYZPNP + this.renderBlocks.aoLightValueScratchXZPP) / 4.0f;
            float aoMixedXYZPPP = (aoLightValue + this.renderBlocks.aoLightValueScratchYZPP + this.renderBlocks.aoLightValueScratchXZPP + this.renderBlocks.aoLightValueScratchXYZPPP) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNPP * this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMinX) + (double)aoMixedXYZPPP * this.renderBlocks.renderMaxY * this.renderBlocks.renderMinX + (double)aoMixedXYZPNP * (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMinX + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMinX));
            this.aoBottomLeft = (float)((double)aoMixedXYZNPP * this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMinX) + (double)aoMixedXYZPPP * this.renderBlocks.renderMinY * this.renderBlocks.renderMinX + (double)aoMixedXYZPNP * (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMinX + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMinX));
            this.aoBottomRight = (float)((double)aoMixedXYZNPP * this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMaxX) + (double)aoMixedXYZPPP * this.renderBlocks.renderMinY * this.renderBlocks.renderMaxX + (double)aoMixedXYZPNP * (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMaxX + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMaxX));
            this.aoTopRight = (float)((double)aoMixedXYZNPP * this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMaxX) + (double)aoMixedXYZPPP * this.renderBlocks.renderMaxY * this.renderBlocks.renderMaxX + (double)aoMixedXYZPNP * (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMaxX + (double)aoMixedXYZNNP * (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMaxX));
            this.renderBlocks.brightnessTopLeft = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPP, brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPPP, this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMinX), (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMinX), (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMinX, this.renderBlocks.renderMaxY * this.renderBlocks.renderMinX);
            this.renderBlocks.brightnessBottomLeft = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPP, brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPPP, this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMinX), (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMinX), (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMinX, this.renderBlocks.renderMinY * this.renderBlocks.renderMinX);
            this.renderBlocks.brightnessBottomRight = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPP, brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPPP, this.renderBlocks.renderMinY * (1.0 - this.renderBlocks.renderMaxX), (1.0 - this.renderBlocks.renderMinY) * (1.0 - this.renderBlocks.renderMaxX), (1.0 - this.renderBlocks.renderMinY) * this.renderBlocks.renderMaxX, this.renderBlocks.renderMinY * this.renderBlocks.renderMaxX);
            this.renderBlocks.brightnessTopRight = this.renderBlocks.mixAoBrightness(brightnessMixedXYZNPP, brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPPP, this.renderBlocks.renderMaxY * (1.0 - this.renderBlocks.renderMaxX), (1.0 - this.renderBlocks.renderMaxY) * (1.0 - this.renderBlocks.renderMaxX), (1.0 - this.renderBlocks.renderMaxY) * this.renderBlocks.renderMaxX, this.renderBlocks.renderMaxY * this.renderBlocks.renderMaxX);
        }
        return this;
    }
}

