/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.damagesources.GT_DamageSources;
import gregtech.api.interfaces.IFoodStat;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class GT_FoodStat
implements IFoodStat {
    private final int mFoodLevel;
    private final int[] mPotionEffects;
    private final float mSaturation;
    private final EnumAction mAction;
    private final ItemStack mEmptyContainer;
    private final boolean mAlwaysEdible;
    private final boolean mInvisibleParticles;
    private final boolean mIsRotten;
    private boolean mExplosive = false;
    private boolean mMilk = false;

    public GT_FoodStat(int aFoodLevel, float aSaturation, EnumAction aAction, ItemStack aEmptyContainer, boolean aAlwaysEdible, boolean aInvisibleParticles, boolean aIsRotten, int ... aPotionEffects) {
        this.mFoodLevel = aFoodLevel;
        this.mSaturation = aSaturation;
        this.mAction = aAction == null ? EnumAction.eat : aAction;
        this.mPotionEffects = aPotionEffects;
        this.mEmptyContainer = GT_Utility.copy(aEmptyContainer);
        this.mInvisibleParticles = aInvisibleParticles;
        this.mAlwaysEdible = aAlwaysEdible;
        this.mIsRotten = aIsRotten;
    }

    public GT_FoodStat setExplosive() {
        this.mExplosive = true;
        return this;
    }

    public GT_FoodStat setMilk() {
        this.mMilk = true;
        return this;
    }

    @Override
    public int getFoodLevel(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mFoodLevel;
    }

    @Override
    public float getSaturation(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mSaturation;
    }

    @Override
    public void onEaten(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        --aStack.stackSize;
        ItemStack tStack = GT_OreDictUnificator.get(GT_Utility.copy(this.mEmptyContainer));
        if (tStack != null && !aPlayer.inventory.addItemStackToInventory(tStack)) {
            aPlayer.dropPlayerItemWithRandomChoice(tStack, true);
        }
        new WorldSpawnedEventBuilder.SoundAtEntityEventBuilder().setIdentifier("random.burp").setVolume(0.5f).setPitch(aPlayer.worldObj.rand.nextFloat() * 0.1f + 0.9f).setEntity((Entity)aPlayer).setWorld(aPlayer.worldObj).run();
        if (!aPlayer.worldObj.isRemote) {
            if (this.mMilk) {
                aPlayer.curePotionEffects(new ItemStack(Items.milk_bucket, 1, 0));
            }
            for (int i = 3; i < this.mPotionEffects.length; i += 4) {
                if (aPlayer.worldObj.rand.nextInt(100) >= this.mPotionEffects[i]) continue;
                aPlayer.addPotionEffect(new PotionEffect(this.mPotionEffects[i - 3], this.mPotionEffects[i - 2], this.mPotionEffects[i - 1], this.mInvisibleParticles));
            }
            if (this.mExplosive) {
                new WorldSpawnedEventBuilder.ExplosionEffectEventBuilder().setSmoking(true).setFlaming(true).setStrength(4.0f).setPosition(aPlayer.posX, aPlayer.posY, aPlayer.posZ).setEntity((Entity)aPlayer).setWorld(aPlayer.worldObj).run();
                aPlayer.attackEntityFrom(GT_DamageSources.getExplodingDamage(), Float.MAX_VALUE);
            }
        }
    }

    @Override
    public EnumAction getFoodAction(GT_MetaBase_Item aItem, ItemStack aStack) {
        return this.mAction;
    }

    @Override
    public boolean alwaysEdible(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mAlwaysEdible;
    }

    @Override
    public boolean isRotten(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mIsRotten;
    }
}

