/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.interfaces.IGuiScreen;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;

public class GT_GuiIntegerTextBox
extends GuiTextField
implements IGuiScreen.IGuiElement {
    private final int x0;
    private final int y0;
    private final IGuiScreen gui;
    public final int id;
    private boolean enabled;

    public GT_GuiIntegerTextBox(IGuiScreen gui, int id, int x, int y, int width, int height) {
        super(Minecraft.getMinecraft().fontRenderer, x, y, width, height);
        super.setText("");
        this.id = id;
        this.x0 = x;
        this.y0 = y;
        this.gui = gui;
        this.enabled = true;
        gui.addElement(this);
    }

    @Override
    public void onInit() {
        this.xPosition = this.x0 + this.gui.getGuiLeft();
        this.yPosition = this.y0 + this.gui.getGuiTop();
    }

    @Override
    public void draw(int mouseX, int mouseY, float parTicks) {
        super.drawTextBox();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x0, this.y0, this.width, this.height);
    }

    public boolean validChar(char c, int key) {
        return Character.isDigit(c);
    }

    public boolean textboxKeyTyped(char c, int key) {
        if (this.validChar(c, key) || c == '\u0001' || c == '\u0003' || c == '\u0016' || c == '\u0018' || key == 14 || key == 199 || key == 203 || key == 205 || key == 207 || key == 211) {
            return super.textboxKeyTyped(c, key);
        }
        return false;
    }

    public void setEnabled(boolean p_146184_1_) {
        super.setEnabled(p_146184_1_);
        this.enabled = p_146184_1_;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

