/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.api.enums.GT_Values;
import net.minecraft.util.EnumChatFormatting;

public enum HeatingCoilLevel {
    None,
    ULV,
    LV,
    MV,
    HV,
    EV,
    IV,
    LuV,
    ZPM,
    UV,
    UHV,
    UEV,
    UIV,
    UMV,
    UXV,
    OpV,
    MAX;


    public String getTierName() {
        if (this.ordinal() < 1 || this.ordinal() - 1 >= GT_Values.VN.length) {
            return "ERROR!";
        }
        return GT_Values.TIER_COLORS[this.ordinal() - 1] + GT_Values.VOLTAGE_NAMES[this.ordinal() - 1] + EnumChatFormatting.RESET;
    }

    public long getHeat() {
        return this == None ? 0L : 1L + 900L * (long)this.ordinal();
    }

    public byte getTier() {
        return (byte)(this.ordinal() - 2);
    }

    public byte getLevel() {
        return (byte)(1 << Math.min(Math.max(0, this.ordinal() - 2), 4));
    }

    public int getCostDiscount() {
        return 1 << Math.max(0, this.ordinal() - 5);
    }

    public static HeatingCoilLevel getFromTier(byte tier) {
        if (tier < 0 || tier > HeatingCoilLevel.values().length - 1) {
            return None;
        }
        return HeatingCoilLevel.values()[tier + 2];
    }
}

