/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_LargeTurbine
extends GT_MetaTileEntity_MultiBlockBase {
    protected int baseEff = 0;
    protected int optFlow = 0;
    protected double realOptFlow = 0.0;
    protected int storedFluid = 0;
    protected int counter = 0;
    protected boolean looseFit = false;

    public GT_MetaTileEntity_LargeTurbine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine(String aName) {
        super(aName);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "LargeTurbine.png");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        byte i;
        byte tSide = this.getBaseMetaTileEntity().getBackFacing();
        if (!this.getBaseMetaTileEntity().getAirAtSideAndDistance(this.getBaseMetaTileEntity().getBackFacing(), 1) || !this.getBaseMetaTileEntity().getAirAtSideAndDistance(this.getBaseMetaTileEntity().getBackFacing(), 2)) return false;
        int tAirCount = 0;
        for (i = -1; i < 2; i = (byte)((byte)(i + 1))) {
            for (int j = -1; j < 2; j = (int)((byte)(j + 1))) {
                for (int k = -1; k < 2; k = (int)((byte)(k + 1))) {
                    if (!this.getBaseMetaTileEntity().getAirOffset(i, j, k)) continue;
                    ++tAirCount;
                }
            }
        }
        if (tAirCount != 10) {
            return false;
        }
        for (i = 2; i < 6; i = (byte)(i + 1)) {
            IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSideAndDistance(i, 2);
            if (null == tTileEntity || tTileEntity.getFrontFacing() != this.getBaseMetaTileEntity().getFrontFacing() || tTileEntity.getMetaTileEntity() == null || !(tTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_LargeTurbine)) continue;
            return false;
        }
        int tX = this.getBaseMetaTileEntity().getXCoord();
        short tY = this.getBaseMetaTileEntity().getYCoord();
        int tZ = this.getBaseMetaTileEntity().getZCoord();
        for (int i2 = -1; i2 < 2; i2 = (int)((byte)(i2 + 1))) {
            for (int j = -1; j < 2; j = (int)((byte)(j + 1))) {
                if (i2 == 0 && j == 0) continue;
                for (int k = 0; k < 4; k = (int)((byte)(k + 1))) {
                    if (!(i2 != 0 && j != 0 || k != 1 && k != 2)) {
                        if (this.getBaseMetaTileEntity().getBlock(tX + (tSide == 5 ? k : (tSide == 4 ? -k : i2)), tY + j, tZ + (tSide == 2 ? -k : (tSide == 3 ? k : i2))) == this.getCasingBlock() && this.getBaseMetaTileEntity().getMetaID(tX + (tSide == 5 ? k : (tSide == 4 ? -k : i2)), tY + j, tZ + (tSide == 2 ? -k : (tSide == 3 ? k : i2))) == this.getCasingMeta() || this.addToMachineList(this.getBaseMetaTileEntity().getIGregTechTileEntity(tX + (tSide == 5 ? k : (tSide == 4 ? -k : i2)), tY + j, tZ + (tSide == 2 ? -k : (tSide == 3 ? k : i2))))) continue;
                        return false;
                    }
                    if (this.getBaseMetaTileEntity().getBlock(tX + (tSide == 5 ? k : (tSide == 4 ? -k : i2)), tY + j, tZ + (tSide == 2 ? -k : (tSide == 3 ? k : i2))) == this.getCasingBlock() && this.getBaseMetaTileEntity().getMetaID(tX + (tSide == 5 ? k : (tSide == 4 ? -k : i2)), tY + j, tZ + (tSide == 2 ? -k : (tSide == 3 ? k : i2))) == this.getCasingMeta()) continue;
                    return false;
                }
            }
        }
        this.mDynamoHatches.clear();
        IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSideAndDistance(this.getBaseMetaTileEntity().getBackFacing(), 3);
        if (tTileEntity == null || tTileEntity.getMetaTileEntity() == null) return false;
        if (!(tTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_Dynamo)) {
            return false;
        }
        this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)tTileEntity.getMetaTileEntity());
        ((GT_MetaTileEntity_Hatch)tTileEntity.getMetaTileEntity()).updateTexture(this.getCasingTextureIndex());
        return true;
    }

    public abstract Block getCasingBlock();

    public abstract byte getCasingMeta();

    public abstract byte getCasingTextureIndex();

    private boolean addToMachineList(IGregTechTileEntity tTileEntity) {
        return this.addMaintenanceToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addInputToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addOutputToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addMufflerToMachineList(tTileEntity, this.getCasingTextureIndex());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (!((this.counter & 7) != 0 || aStack != null && aStack.func_77973_b() instanceof GT_MetaGenerated_Tool && aStack.func_77960_j() >= 170 && aStack.func_77960_j() <= 179)) {
            this.stopMachine();
            return false;
        }
        ArrayList<FluidStack> tFluids = this.getStoredFluids();
        if (tFluids.size() > 0) {
            if (this.baseEff == 0 || this.optFlow == 0 || this.counter >= 512 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || this.getBaseMetaTileEntity().hasInventoryBeenModified()) {
                this.counter = 0;
                this.baseEff = GT_Utility.safeInt((long)((5.0f + ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolCombatDamage(aStack)) * 1000.0f));
                GT_MetaGenerated_Tool cfr_ignored_0 = (GT_MetaGenerated_Tool)aStack.func_77973_b();
                this.optFlow = GT_Utility.safeInt((long)Math.max(Float.MIN_NORMAL, ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolStats(aStack).getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 50.0f));
                if (this.optFlow <= 0 || this.baseEff <= 0) {
                    this.stopMachine();
                    return false;
                }
            } else {
                ++this.counter;
            }
        }
        int newPower = this.fluidIntoPower(tFluids, this.optFlow, this.baseEff);
        int difference = newPower - this.mEUt;
        int maxChangeAllowed = Math.max(10, GT_Utility.safeInt((long)Math.abs(difference) / 100L));
        if (Math.abs(difference) > maxChangeAllowed) {
            int change = maxChangeAllowed * (difference > 0 ? 1 : -1);
            this.mEUt += change;
        } else {
            this.mEUt = newPower;
        }
        if (this.mEUt <= 0) {
            this.mEUt = 0;
            this.mEfficiency = 0;
            return false;
        }
        this.mMaxProgresstime = 1;
        this.mEfficiencyIncrease = 10;
        return true;
    }

    abstract int fluidIntoPower(ArrayList<FluidStack> var1, int var2, int var3);

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return 0;
        }
        if (aStack.func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
            return 10000;
        }
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_LargeTurbine.isValidMetaTileEntity(tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        String tRunning = this.mMaxProgresstime > 0 ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.running.true") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.running.false") + EnumChatFormatting.RESET;
        String tMaintainance = this.getIdealStatus() == this.getRepairStatus() ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.false") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.true") + EnumChatFormatting.RESET;
        int tDura = 0;
        if (this.mInventory[1] != null && this.mInventory[1].func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
            tDura = GT_Utility.safeInt((long)(100.0f / (float)GT_MetaGenerated_Tool.getToolMaxDamage(this.mInventory[1]) * (float)GT_MetaGenerated_Tool.getToolDamage(this.mInventory[1]) + 1.0f));
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Dynamo tHatch : this.mDynamoHatches) {
            if (!GT_MetaTileEntity_LargeTurbine.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        String[] ret = new String[]{tRunning + ": " + EnumChatFormatting.RED + this.mEUt + EnumChatFormatting.RESET + " EU/t", tMaintainance, StatCollector.func_74838_a((String)"GT5U.turbine.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + Long.toString(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + Long.toString(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.turbine.flow") + ": " + EnumChatFormatting.YELLOW + GT_Utility.safeInt((long)this.realOptFlow) + EnumChatFormatting.RESET + " L/t" + EnumChatFormatting.YELLOW + " (" + (this.looseFit ? StatCollector.func_74838_a((String)"GT5U.turbine.loose") : StatCollector.func_74838_a((String)"GT5U.turbine.tight")) + ")", StatCollector.func_74838_a((String)"GT5U.turbine.fuel") + ": " + EnumChatFormatting.GOLD + this.storedFluid + EnumChatFormatting.RESET + "L", StatCollector.func_74838_a((String)"GT5U.turbine.dmg") + ": " + EnumChatFormatting.RED + Integer.toString(tDura) + EnumChatFormatting.RESET + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
        if (!this.getClass().getName().contains("Steam")) {
            ret[4] = StatCollector.func_74838_a((String)"GT5U.turbine.flow") + ": " + EnumChatFormatting.YELLOW + GT_Utility.safeInt((long)this.realOptFlow) + EnumChatFormatting.RESET + " L/t";
        }
        return ret;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }
}

