/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;

public class GT_MetaTileEntity_Boxinator
extends GT_MetaTileEntity_BasicMachine {
    public GT_MetaTileEntity_Boxinator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "Puts things into Boxes", 2, 1, "Packager.png", "", new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_BOXINATOR_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_BOXINATOR), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_BOXINATOR_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_BOXINATOR), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_BOXINATOR_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_BOXINATOR), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_BOXINATOR_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_BOXINATOR));
    }

    public GT_MetaTileEntity_Boxinator(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 2, 1, aGUIName, aNEIName);
    }

    public GT_MetaTileEntity_Boxinator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 2, 1, aGUIName, aNEIName);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Boxinator(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes;
    }

    @Override
    public int checkRecipe() {
        int tCheck = super.checkRecipe();
        if (tCheck != 0) {
            return tCheck;
        }
        if (GT_Utility.isStackValid(this.getInputAt(0)) && GT_Utility.isStackValid(this.getInputAt(1)) && GT_Utility.getContainerItem(this.getInputAt(0), true) == null) {
            if (ItemList.Schematic_1by1.isStackEqual(this.getInputAt(1)) && this.getInputAt((int)0).field_77994_a >= 1) {
                this.mOutputItems[0] = GT_ModHandler.getRecipeOutput(this.getInputAt(0));
                if (this.mOutputItems[0] != null && this.canOutput(this.mOutputItems[0])) {
                    --this.getInputAt((int)0).field_77994_a;
                    this.calculateOverclockedNess(32, 16);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    return 2;
                }
                return 0;
            }
            if (ItemList.Schematic_2by2.isStackEqual(this.getInputAt(1)) && this.getInputAt((int)0).field_77994_a >= 4) {
                this.mOutputItems[0] = GT_ModHandler.getRecipeOutput(this.getInputAt(0), this.getInputAt(0), null, this.getInputAt(0), this.getInputAt(0));
                if (this.mOutputItems[0] != null && this.canOutput(this.mOutputItems[0])) {
                    this.getInputAt((int)0).field_77994_a -= 4;
                    this.calculateOverclockedNess(32, 32);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    return 2;
                }
                return 0;
            }
            if (ItemList.Schematic_3by3.isStackEqual(this.getInputAt(1)) && this.getInputAt((int)0).field_77994_a >= 9) {
                this.mOutputItems[0] = GT_ModHandler.getRecipeOutput(this.getInputAt(0), this.getInputAt(0), this.getInputAt(0), this.getInputAt(0), this.getInputAt(0), this.getInputAt(0), this.getInputAt(0), this.getInputAt(0), this.getInputAt(0));
                if (this.mOutputItems[0] != null && this.canOutput(this.mOutputItems[0])) {
                    this.getInputAt((int)0).field_77994_a -= 9;
                    this.calculateOverclockedNess(32, 64);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    return 2;
                }
                return 0;
            }
        }
        return 0;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack)) {
            if (ItemList.Schematic_1by1.isStackEqual(this.getInputAt(1)) || ItemList.Schematic_2by2.isStackEqual(this.getInputAt(1)) || ItemList.Schematic_3by3.isStackEqual(this.getInputAt(1))) {
                if (GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), true, GT_Values.V[this.mTier], null, GT_Utility.copyAmount(64L, aStack), this.getInputAt(1)) != null) {
                    return true;
                }
                if (ItemList.Schematic_1by1.isStackEqual(this.getInputAt(1)) && GT_ModHandler.getRecipeOutput(aStack) != null) {
                    return true;
                }
                if (ItemList.Schematic_2by2.isStackEqual(this.getInputAt(1)) && GT_ModHandler.getRecipeOutput(aStack, aStack, null, aStack, aStack) != null) {
                    return true;
                }
                if (ItemList.Schematic_3by3.isStackEqual(this.getInputAt(1)) && GT_ModHandler.getRecipeOutput(aStack, aStack, aStack, aStack, aStack, aStack, aStack, aStack, aStack) != null) {
                    return true;
                }
            } else {
                return GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes.containsInput(aStack);
            }
        }
        return false;
    }
}

