/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import gregtech.api.enums.Materials;
import gregtech.api.util.GT_LanguageManager;

public enum CombType {
    LIGNIE("lignite", true, Materials.Lignite, 100, 5779467, 9462327),
    COAL("coal", true, Materials.Coal, 100, 0x525252, 0x666666),
    STICKY("stickyresin", true, Materials._NULL, 50, 3051355, 14467721),
    OIL("oil", true, Materials._NULL, 100, 0x333333, 0x4C4C4C),
    APATITE("apatite", true, Materials.Apatite, 100, 12698102, 6776708),
    ASH("ash", true, Materials.Ash, 100, 1972760, 0xC6C6C6),
    COOLANT("coolant", true, Materials._NULL, 100, 1331034, 2397346),
    ENERGY("energy", true, Materials._NULL, 80, 0xC11F1F, 0xEBB9B9),
    LAPOTRON("lapotron", true, Materials._NULL, 60, 0x1414FF, 6584575),
    PYROTHEUM("pyrotheum", true, Materials.Pyrotheum, 50, 16772036, 14902272),
    CRYOTHEUM("cryotheum", true, Materials.Pyrotheum, 50, 2515199, 5961727),
    REDALLOY("redalloy", true, Materials.RedAlloy, 100, 0xE60000, 0xB80000),
    REDSTONEALLOY("redstonealloy", true, Materials.RedstoneAlloy, 90, 0xB80000, 10815496),
    CONDUCTIVEIRON("conductiveiron", true, Materials.ConductiveIron, 80, 8484465, 13544867),
    VIBRANTALLOY("vibrantalloy", true, Materials.VibrantAlloy, 50, 8823085, 12907182),
    ENERGETICALLOY("energeticalloy", true, Materials.EnergeticAlloy, 70, 0xFF9933, 16756060),
    ELECTRICALSTEEL("electricalsteel", true, Materials.ElectricalSteel, 90, 0x787878, 0xD8D8D8),
    DARKSTEEL("darksteel", true, Materials.DarkSteel, 80, 0x252525, 0x443B44),
    PULSATINGIRON("pulsatingiron", true, Materials.PulsatingIron, 80, 26112, 7197316),
    STAINLESSSTEEL("stainlesssteel", true, Materials.StainlessSteel, 75, 0x778899, 0xC8C8DC),
    ENDERIUM("enderium", true, Materials.Enderium, 40, 3050327, 5869703),
    THAUMIUMDUST("thaumiumdust", true, Materials.Thaumium, 100, 0x7A007A, 0x5C005C),
    THAUMIUMSHARD("thaumiumshard", true, Materials._NULL, 85, 0x9966FF, 11372031),
    AMBER("amber", true, Materials.Amber, 90, 7818005, 0xEE7700),
    QUICKSILVER("quicksilver", true, Materials.Mercury, 90, 13092842, 11908063),
    SALISMUNDUS("salismundus", true, Materials._NULL, 75, 16231902, 5842306),
    TAINTED("tainted", true, Materials._NULL, 80, 9456568, 15204607),
    MITHRIL("mithril", true, Materials.Mithril, 70, 15787660, 0xFFFFD2),
    ASTRALSILVER("astralsilver", true, Materials.AstralSilver, 70, 0xAFEEEE, 0xE6E6FF),
    THAUMINITE("thauminite", true, Materials._NULL, 50, 3026297, 7700960),
    SHADOWMETAL("shadowmetal", true, Materials.Shadow, 50, 1049378, 1049410),
    DIVIDED("divided", true, Materials.Unstable, 40, 0xF0F0F0, 0xDCDCDC),
    SPARKELING("sparkling", true, Materials.NetherStar, 40, 0x7A007A, 0xFFFFFF),
    STONE("stone", true, Materials._NULL, 70, 0x808080, 0x999999),
    CERTUS("certus", true, Materials.CertusQuartz, 100, 5754875, 0xBBEEFF),
    FLUIX("fluix", true, Materials.Fluix, 100, 10712575, 11899391),
    REDSTONE("redstone", true, Materials.Redstone, 100, 8195855, 0xD11919),
    RAREEARTH("rareearth", true, Materials.RareEarth, 100, 5592643, 3421224),
    LAPIS("lapis", true, Materials.Lapis, 100, 1656785, 4680922),
    RUBY("ruby", true, Materials.Ruby, 100, 15073372, 13369426),
    REDGARNET("redgarnet", true, Materials.GarnetRed, 100, 12405836, 0xECCECE),
    YELLOWGARNET("yellowgarnet", true, Materials.GarnetYellow, 100, 10724161, 0xEDEDCE),
    SAPPHIRE("sapphire", true, Materials.Sapphire, 100, 13260, 9359),
    DIAMOND("diamond", true, Materials.Diamond, 100, 0xCCFFFF, 0xA3CCCC),
    OLIVINE("olivine", true, Materials.Olivine, 100, 2395940, 0xCCFFCC),
    EMERALD("emerald", true, Materials.Emerald, 100, 2395940, 3061806),
    PYROPE("pyrope", true, Materials.Pyrope, 100, 7745890, 0x8B8B8B),
    GROSSULAR("grossular", true, Materials.Grossular, 100, 10178048, 0x8B8B8B),
    FIRESTONE("firestone", true, Materials.Firestone, 100, 0xC00000, 0xFF0000),
    SLAG("slag", true, Materials._NULL, 50, 0xD4D4D4, 5779467),
    COPPER("copper", true, Materials.Copper, 100, 0xFF6600, 15096832),
    TIN("tin", true, Materials.Tin, 100, 0xD4D4D4, 0xDDDDDD),
    LEAD("lead", true, Materials.Lead, 100, 0x666699, 0xA3A3CC),
    IRON("iron", true, Materials.Iron, 100, 14324039, 14589017),
    STEEL("steel", true, Materials.Steel, 95, 0x808080, 0x999999),
    NICKEL("nickel", true, Materials.Nickel, 100, 8750509, 0x9D9DBD),
    ZINC("zinc", true, Materials.Zinc, 100, 15785712, 15917554),
    SILVER("silver", true, Materials.Silver, 100, 12763862, 0xCECEDE),
    GOLD("gold", true, Materials.Gold, 100, 15120384, 13608448),
    SULFUR("sulfur", true, Materials.Sulfur, 100, 7302913, 0x8B8B8B),
    GALLIUM("gallium", true, Materials.Gallium, 75, 0x8B8B8B, 12961252),
    ARSENIC("arsenic", true, Materials.Arsenic, 75, 7564370, 2696210),
    BAUXITE("bauxite", true, Materials.Bauxite, 85, 7026176, 0x8B8B8B),
    ALUMINIUM("aluminium", true, Materials.Aluminium, 60, 35512, 0xD6D6FF),
    MANGANESE("manganese", true, Materials.Manganese, 30, 0xD5D5D5, 0xAAAAAA),
    MAGNESIUM("magnesium", true, Materials.Magnesium, 75, 15849945, 0x8B8B8B),
    TITANIUM("titanium", true, Materials.Ilmenite, 100, 0xCC99FF, 14399743),
    CHROME("chromium", true, Materials.Chrome, 50, 15442411, 15909874),
    TUNGSTEN("tungsten", true, Materials.Tungstate, 100, 0x62626D, 1447456),
    PLATINUM("platinum", true, Materials.Platinum, 40, 0xE6E6E6, 0xFFFFCC),
    IRIDIUM("iridium", true, Materials.Iridium, 20, 0xDADADA, 13750752),
    MOLYBDENUM("molybdenum", true, Materials.Molybdenum, 20, 11448020, 0x8B8B8B),
    OSMIUM("osmium", true, Materials.Osmium, 15, 2829274, 0x8B8B8B),
    LITHIUM("lithium", true, Materials.Lithium, 75, 15741580, 14802175),
    SALT("salt", true, Materials.Salt, 90, 15780040, 0xFAFAFA),
    ELECTROTINE("electrotine", true, Materials.Electrotine, 75, 2003199, 3978440),
    ALMANDINE("almandine", true, Materials.Almandine, 85, 0xC60000, 0x8B8B8B),
    URANIUM("uranium", true, Materials.Uranium, 50, 1683225, 1482262),
    PLUTONIUM("plutonium", true, Materials.Plutonium, 10, 0x240000, 0x570000),
    NAQUADAH("naquadah", true, Materials.Naquadah, 10, 0, 17408),
    NAQUADRIA("naquadria", true, Materials.Naquadria, 5, 0, 9216),
    DOB("d-o-b", true, Materials._NULL, 50, 30464, 9216),
    THORIUM("thorium", true, Materials.Thorium, 75, 7680, 20480),
    LUTETIUM("lutetium", true, Materials.Lutetium, 10, 0xE6FFE6, 0xFFFFFF),
    AMERICUM("americum", true, Materials.Americium, 5, 0xE6E6FF, 0xC8C8C8),
    NEUTRONIUM("neutronium", true, Materials.Neutronium, 2, 0xFFF0F0, 0xFAFAFA),
    NAGA("naga", true, Materials._NULL, 100, 875021, 2656075),
    LICH("lich", true, Materials._NULL, 90, 6053982, 0xC5C5C5),
    HYDRA("hydra", true, Materials._NULL, 80, 8857654, 12063532),
    URGHAST("urghast", true, Materials._NULL, 70, 8128024, 10945564),
    SNOWQUEEN("snowqueen", true, Materials._NULL, 60, 10223640, 13639681),
    SPACE("space", true, Materials._NULL, 100, 13158, 0xC0C0C0),
    METEORICIRON("meteoriciron", true, Materials.MeteoricIron, 100, 3283240, 6566480),
    DESH("desh", true, Materials.Desh, 90, 0x282828, 0x323232),
    LEDOX("ledox", true, Materials.Ledox, 75, 205, 29951),
    CALLISTOICE("callistoice", true, Materials.CallistoIce, 75, 29951, 2011647),
    MYTRYL("mytryl", true, Materials.Mytryl, 65, 14329120, 15885316),
    QUANTIUM("quantium", true, Materials.Quantium, 50, 65280, 53515),
    ORIHARUKON("oriharukon", true, Materials.Oriharukon, 50, 0x228B22, 6782312),
    MYSTERIOUSCRYSTAL("mysteriouscrystal", true, Materials.MysteriousCrystal, 45, 3978097, 1475948),
    BLACKPLUTONIUM("blackplutonium", true, Materials.Quantium, 25, 0, 0x323232),
    TRINIUM("trinium", true, Materials.Trinium, 25, 11591910, 13158610),
    MERCURY("mercury", true, Materials._NULL, 65, 4866099, 11903624),
    VENUS("venus", true, Materials._NULL, 65, 1183239, 2564112),
    MOON("moon", true, Materials._NULL, 90, 0x373735, 0x7E7E78),
    MARS("mars", true, Materials._NULL, 80, 2231557, 3806469),
    JUPITER("jupiter", true, Materials._NULL, 75, 7555886, 13683652),
    SATURN("saturn", true, Materials._NULL, 55, 13804658, 16302971),
    URANUS("uranus", true, Materials._NULL, 45, 7717065, 8706284),
    NEPTUN("neptun", true, Materials._NULL, 35, 3362047, 5729791),
    PLUTO("pluto", true, Materials._NULL, 25, 3417886, 6901821),
    HAUMEA("haumea", true, Materials._NULL, 20, 1840147, 3746600),
    MAKEMAKE("makemake", true, Materials._NULL, 20, 3151889, 1182215),
    CENTAURI("centauri", true, Materials._NULL, 15, 3090964, 11561778),
    TCETI("tceti", true, Materials._NULL, 10, 4596762, 8077615),
    BARNARDA("barnarda", true, Materials._NULL, 10, 875021, 15122829),
    VEGA("vega", true, Materials._NULL, 10, 1712182, 11911390),
    COSMICNEUTRONIUM("cosmicneutronium", true, Materials._NULL, 5, 0x484848, 0x323232),
    INFINITYCATALYST("infinitycatalyst", true, Materials._NULL, 2, 0xFFFFFF, 0xFFFFFF),
    INFINITY("infinity", true, Materials._NULL, 1, 0xFFFFFF, 0xFFFFFF),
    ENDDUST("enddust", true, Materials._NULL, 50, 14973, 13369594),
    ECTOPLASMA("ectoplasma", true, Materials._NULL, 35, 3677248, 14463205),
    ARCANESHARD("arcaneshard", true, Materials._NULL, 35, 3358082, 9441453),
    STARDUST("stardust", true, Materials._NULL, 60, 14466579, 0xFFFF00),
    DRAGONESSENCE("dragonessence", true, Materials._NULL, 30, 9510606, 16752939),
    ENDERMAN("enderman", true, Materials._NULL, 25, 6422759, 0x161616),
    SILVERFISH("silverfish", true, Materials._NULL, 25, 0, 15598909),
    ENDIUM("endium", true, Materials.HeeEndium, 50, 3103340, 0xA0FFFF),
    RUNEI("rune1", true, Materials._NULL, 10, 66777, 14880784),
    RUNEII("rune2", true, Materials._NULL, 10, 14880784, 66777),
    FIREESSENSE("fireessence", true, Materials._NULL, 30, 16752983, 13898296);

    public boolean showInList;
    public Materials material;
    public int chance;
    private String name;
    private int[] color;

    private CombType(String pName, boolean show, Materials material, int chance, int ... color) {
        this.name = pName;
        this.material = material;
        this.chance = chance;
        this.showInList = show;
        this.color = color;
    }

    public void setHidden() {
        this.showInList = false;
    }

    public String getName() {
        return GT_LanguageManager.addStringLocalization("comb." + this.name, this.name.substring(0, 1).toUpperCase() + this.name.substring(1) + " Comb");
    }

    public int[] getColours() {
        int[] nArray;
        if (this.color == null || this.color.length != 2) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 0;
        } else {
            nArray = this.color;
        }
        return nArray;
    }
}

