/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_OilCracker
extends GT_MetaTileEntity_MultiBlockBase {
    private ForgeDirection orientation;
    private int controllerX;
    private int controllerZ;

    public GT_MetaTileEntity_OilCracker(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_OilCracker(String aName) {
        super(aName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Oil Cracking Unit", "Thermally cracks heavy hydrocarbons into lighter fractions", "Size(WxHxD): 5x3x3 (Hollow), Controller (Front center)", "Ring of 8 Cupronickel Coils (Each side of Controller)", "1x Hydrocarbon Input Bus/Hatch (Any left/right side casing)", "1x Steam/Hydrogen Input Hatch (Any middle ring casing)", "1x Cracked Hydrocarbon Output Hatch (Any left/right side casing)", "1x Maintenance Hatch (Any casing)", "1x Energy Hatch (Any casing)", "Clean Stainless Steel Machine Casings for the rest (18 at least!)", "Input/Output Hatches must be on opposite sides"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "OilCrackingUnit.png");
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<FluidStack> tInputList = this.getStoredFluids();
        FluidStack[] tFluidInputs = tInputList.toArray(new FluidStack[tInputList.size()]);
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sCrakingRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluidInputs, this.mInventory[1]);
        if (tRecipe != null && tRecipe.isRecipeInputEqual(true, tFluidInputs, this.mInventory[1])) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.mEUt = tRecipe.mEUt;
            this.mMaxProgresstime = tRecipe.mDuration;
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= 2;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
            return true;
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.orientation = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing());
        this.controllerX = aBaseMetaTileEntity.getXCoord();
        this.controllerZ = aBaseMetaTileEntity.getZCoord();
        int xDir = this.orientation.offsetX;
        int zDir = this.orientation.offsetZ;
        int amount = 0;
        this.replaceDeprecatedCoils(aBaseMetaTileEntity);
        boolean negSideInput = false;
        boolean negSideOutput = false;
        boolean posSideInput = false;
        boolean posSideOutput = false;
        if (xDir != 0) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    for (int h = -2; h < 3; ++h) {
                        IGregTechTileEntity tTileEntity;
                        if (j == 0 && i == 0 && (h == -1 || h == 0 || h == 1)) continue;
                        if (h == 1 || h == -1) {
                            if (aBaseMetaTileEntity.getBlockOffset(xDir + i, j, h + zDir) != GregTech_API.sBlockCasings5) {
                                return false;
                            }
                            if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, j, h + zDir) != 0) {
                                return false;
                            }
                        }
                        if (h == 2 || h == -2) {
                            tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, j, h + zDir);
                            if (this.addInputToMachineList(tTileEntity, 49)) {
                                if (h == -2) {
                                    negSideInput = true;
                                } else {
                                    posSideInput = true;
                                }
                            } else if (this.addOutputToMachineList(tTileEntity, 49)) {
                                if (h == -2) {
                                    negSideOutput = true;
                                } else {
                                    posSideOutput = true;
                                }
                            } else if (!this.addEnergyInputToMachineList(tTileEntity, 49) && !this.addMaintenanceToMachineList(tTileEntity, 49)) {
                                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, j, h + zDir) != GregTech_API.sBlockCasings4) {
                                    return false;
                                }
                                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, j, h + zDir) != 1) {
                                    return false;
                                }
                                ++amount;
                            }
                        }
                        if (h != 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, j, h + zDir), 49) || this.addInputToMachineList(tTileEntity, 49) || this.addEnergyInputToMachineList(tTileEntity, 49) || xDir + i == 0 && j == 0 && h + zDir == 0) continue;
                        if (aBaseMetaTileEntity.getBlockOffset(xDir + i, j, h + zDir) != GregTech_API.sBlockCasings4) {
                            return false;
                        }
                        if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, j, h + zDir) != 1) {
                            return false;
                        }
                        ++amount;
                    }
                }
            }
        } else {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    for (int h = -2; h < 3; ++h) {
                        IGregTechTileEntity tTileEntity;
                        if (j == 0 && i == 0 && (h == -1 || h == 0 || h == 1)) continue;
                        if (h == 1 || h == -1) {
                            if (aBaseMetaTileEntity.getBlockOffset(xDir + h, j, i + zDir) != GregTech_API.sBlockCasings5) {
                                return false;
                            }
                            if (aBaseMetaTileEntity.getMetaIDOffset(xDir + h, j, i + zDir) != 0) {
                                return false;
                            }
                        }
                        if (h == 2 || h == -2) {
                            tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + h, j, i + zDir);
                            if (this.addInputToMachineList(tTileEntity, 49)) {
                                if (h == -2) {
                                    negSideInput = true;
                                } else {
                                    posSideInput = true;
                                }
                            } else if (this.addOutputToMachineList(tTileEntity, 49)) {
                                if (h == -2) {
                                    negSideOutput = true;
                                } else {
                                    posSideOutput = true;
                                }
                            } else if (!this.addEnergyInputToMachineList(tTileEntity, 49) && !this.addMaintenanceToMachineList(tTileEntity, 49)) {
                                if (aBaseMetaTileEntity.getBlockOffset(xDir + h, j, i + zDir) != GregTech_API.sBlockCasings4) {
                                    return false;
                                }
                                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + h, j, i + zDir) != 1) {
                                    return false;
                                }
                                ++amount;
                            }
                        }
                        if (h != 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + h, j, i + zDir), 49) || this.addInputToMachineList(tTileEntity, 49) || this.addEnergyInputToMachineList(tTileEntity, 49) || xDir + h == 0 && j == 0 && i + zDir == 0) continue;
                        if (aBaseMetaTileEntity.getBlockOffset(xDir + h, j, i + zDir) != GregTech_API.sBlockCasings4) {
                            return false;
                        }
                        if (aBaseMetaTileEntity.getMetaIDOffset(xDir + h, j, i + zDir) != 1) {
                            return false;
                        }
                        ++amount;
                    }
                }
            }
        }
        if (negSideInput && negSideOutput || posSideInput && posSideOutput || negSideInput && posSideInput || negSideOutput && posSideOutput) {
            return false;
        }
        return amount >= 18;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_OilCracker(this.mName);
    }

    private void replaceDeprecatedCoils(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tX = aBaseMetaTileEntity.getXCoord() + xDir;
        short tY = aBaseMetaTileEntity.getYCoord();
        int tZ = aBaseMetaTileEntity.getZCoord() + zDir;
        for (int xPos = tX - 1; xPos <= tX + 1; xPos += xDir != 0 ? 1 : 2) {
            for (int yPos = tY - 1; yPos <= tY + 1; ++yPos) {
                for (int zPos = tZ - 1; zPos <= tZ + 1; zPos += xDir != 0 ? 2 : 1) {
                    if (yPos == tY && (xPos == tX || zPos == tZ) || aBaseMetaTileEntity.getBlock(xPos, yPos, zPos) != GregTech_API.sBlockCasings1 || aBaseMetaTileEntity.getMetaID(xPos, yPos, zPos) != 12) continue;
                    aBaseMetaTileEntity.getWorld().setBlock(xPos, yPos, zPos, GregTech_API.sBlockCasings5, 0, 3);
                }
            }
        }
    }

    @Override
    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_OilCracker.isValidMetaTileEntity(tHatch) || tHatch.getFillableStack() == null) continue;
            FluidStack tStack = tHatch.getFillableStack();
            if (tStack.isFluidEqual(GT_ModHandler.getSteam(1000L)) || tStack.isFluidEqual(Materials.Hydrogen.getGas(1000L))) {
                if (!this.isHatchInMiddleRing(tHatch)) continue;
                rList.add(tStack);
                continue;
            }
            if (this.isHatchInMiddleRing(tHatch)) continue;
            rList.add(tStack);
        }
        return rList;
    }

    private boolean isHatchInMiddleRing(GT_MetaTileEntity_Hatch_Input inputHatch) {
        if (this.orientation == ForgeDirection.NORTH || this.orientation == ForgeDirection.SOUTH) {
            return inputHatch.getBaseMetaTileEntity().getXCoord() == this.controllerX;
        }
        return inputHatch.getBaseMetaTileEntity().getZCoord() == this.controllerZ;
    }
}

