/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_MultiFurnace
extends GT_MetaTileEntity_MultiBlockBase {
    private int mLevel = 0;
    private int mCostDiscount = 1;

    public GT_MetaTileEntity_MultiFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_MultiFurnace(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_MultiFurnace(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Multi Smelter", "Smelts up to 8-128 Items at once", "Size(WxHxD): 3x3x3 (Hollow), Controller (Front middle at bottom)", "8x Heating Coils (Middle layer, hollow)", "1x Input Bus (One of bottom)", "1x Output Bus (One of bottom)", "1x Maintenance Hatch (One of bottom)", "1x Muffler Hatch (Top middle)", "1x Energy Hatch (One of bottom)", "Heat Proof Machine Casings for the rest", "Causes " + 20 * this.getPollutionPerTick(null) + " Pollution per second"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiFurnace.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sFurnaceRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        if (!tInputList.isEmpty()) {
            int mVolatage = GT_Utility.safeInt(this.getMaxInputVoltage());
            int j = 0;
            this.mOutputItems = new ItemStack[8 * this.mLevel];
            for (int i = 0; i < 256 && j < this.mOutputItems.length; ++i) {
                this.mOutputItems[j] = GT_ModHandler.getSmeltingOutput(tInputList.get(i % tInputList.size()), true, null);
                if (null == this.mOutputItems[j]) continue;
                ++j;
            }
            if (j > 0) {
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                this.calculateOverclockedNessMulti(4, 512, 1, mVolatage);
                if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                    return false;
                }
                this.mEUt = GT_Utility.safeInt((long)this.mEUt * (long)this.mLevel / (long)this.mCostDiscount, 1);
                if (this.mEUt == 0x7FFFFFFE) {
                    return false;
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
            }
            this.updateSlots();
            return true;
        }
        return false;
    }

    private boolean checkMachineFunction(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int j;
        int i;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        this.mLevel = 0;
        this.mCostDiscount = 1;
        if (!aBaseMetaTileEntity.getAirOffset(xDir, 1, zDir)) {
            return false;
        }
        this.addMufflerToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir, 2, zDir), 11);
        this.replaceDeprecatedCoils(aBaseMetaTileEntity);
        byte tUsedMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir + 1, 1, zDir);
        switch (tUsedMeta) {
            case 0: {
                this.mLevel = 1;
                this.mCostDiscount = 1;
                break;
            }
            case 1: {
                this.mLevel = 2;
                this.mCostDiscount = 1;
                break;
            }
            case 2: {
                this.mLevel = 4;
                this.mCostDiscount = 1;
                break;
            }
            case 3: {
                this.mLevel = 8;
                this.mCostDiscount = 1;
                break;
            }
            case 4: {
                this.mLevel = 16;
                this.mCostDiscount = 2;
                break;
            }
            case 5: {
                this.mLevel = 16;
                this.mCostDiscount = 4;
                break;
            }
            case 6: {
                this.mLevel = 16;
                this.mCostDiscount = 8;
                break;
            }
            case 7: {
                this.mLevel = 16;
                this.mCostDiscount = 16;
                break;
            }
            case 8: {
                this.mLevel = 16;
                this.mCostDiscount = 24;
                break;
            }
            default: {
                return false;
            }
        }
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                if (i == 0 && j == 0) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 1, zDir + j) != GregTech_API.sBlockCasings5) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 1, zDir + j) != tUsedMeta) {
                    return false;
                }
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 2, zDir + j) != GregTech_API.sBlockCasings1) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 2, zDir + j) == 11) continue;
                return false;
            }
        }
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                IGregTechTileEntity tTileEntity;
                if (xDir + i == 0 && zDir + j == 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 0, zDir + j), 11) || this.addInputToMachineList(tTileEntity, 11) || this.addOutputToMachineList(tTileEntity, 11) || this.addEnergyInputToMachineList(tTileEntity, 11)) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 0, zDir + j) != GregTech_API.sBlockCasings1) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 0, zDir + j) == 11) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        boolean result = this.checkMachineFunction(aBaseMetaTileEntity, aStack);
        if (!result) {
            this.mLevel = 0;
        }
        return result;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 20;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private void replaceDeprecatedCoils(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tX = aBaseMetaTileEntity.getXCoord() + xDir;
        short tY = aBaseMetaTileEntity.getYCoord();
        int tZ = aBaseMetaTileEntity.getZCoord() + zDir;
        for (int xPos = tX - 1; xPos <= tX + 1; ++xPos) {
            for (int zPos = tZ - 1; zPos <= tZ + 1; ++zPos) {
                byte tUsedMeta;
                if (xPos == tX && zPos == tZ || (tUsedMeta = aBaseMetaTileEntity.getMetaID(xPos, tY + 1, zPos)) < 12 || tUsedMeta > 14 || aBaseMetaTileEntity.getBlock(xPos, tY + 1, zPos) != GregTech_API.sBlockCasings1) continue;
                aBaseMetaTileEntity.getWorld().setBlock(xPos, tY + 1, zPos, GregTech_API.sBlockCasings5, tUsedMeta - 12, 3);
            }
        }
    }

    @Override
    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_MultiFurnace.isValidMetaTileEntity(tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiFurnace.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.translateToLocal((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + Integer.toString(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.translateToLocal((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + Long.toString(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + Long.toString(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.translateToLocal((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + Integer.toString(-this.mEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.translateToLocal((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + Long.toString(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.translateToLocal((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.translateToLocal((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.translateToLocal((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + Float.toString((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + " %", StatCollector.translateToLocal((String)"GT5U.MS.multismelting") + ": " + EnumChatFormatting.GREEN + this.mLevel * 8 + EnumChatFormatting.RESET + " Discount: (EU/t) / " + EnumChatFormatting.GREEN + this.mCostDiscount + EnumChatFormatting.RESET, StatCollector.translateToLocal((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }
}

