/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_Disassembler
extends GT_MetaTileEntity_BasicMachine {
    public GT_MetaTileEntity_Disassembler(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "Disassembles Machines at " + Math.min(50 + 10 * aTier, 100) + "% Efficiency", 1, 9, "Disassembler.png", "", new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER));
    }

    public GT_MetaTileEntity_Disassembler(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 9, aGUIName, aNEIName);
    }

    public GT_MetaTileEntity_Disassembler(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 9, aGUIName, aNEIName);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Disassembler(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    @Override
    public int checkRecipe() {
        NBTTagCompound tNBT = this.getInputAt(0).getTagCompound();
        if (tNBT != null && (tNBT = tNBT.getCompoundTag("GT.CraftingComponents")) != null) {
            int i;
            boolean isAnyOutput = false;
            this.calculateOverclockedNessDisassembler(16);
            this.mMaxProgresstime = 80;
            if (this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
            for (i = 0; i < this.mOutputItems.length; ++i) {
                if (this.getBaseMetaTileEntity().getRandomNumber(100) >= 50 + 10 * this.mTier) continue;
                this.mOutputItems[i] = GT_Utility.loadItem(tNBT, "Ingredient." + i);
                if (this.mOutputItems[i] == null) continue;
                this.mMaxProgresstime = (int)((float)this.mMaxProgresstime * 1.7f);
                isAnyOutput = true;
            }
            if (!isAnyOutput) {
                return 0;
            }
            for (i = this.mTier - 5; i > 0; --i) {
                this.mMaxProgresstime >>= 1;
                if (this.mMaxProgresstime != 0) continue;
                this.mEUt >>= 1;
            }
            if (this.mEUt == 0) {
                this.mEUt = 1;
            }
            if (this.mMaxProgresstime == 0) {
                this.mMaxProgresstime = 1;
            }
            --this.getInputAt((int)0).stackSize;
            return 2;
        }
        return 0;
    }

    private void calculateOverclockedNessDisassembler(int aEUt) {
        if (this.mTier == 0) {
            this.mEUt = aEUt >> 2;
        } else {
            long tempEUt;
            long xEUt = aEUt;
            long l = tempEUt = xEUt < GT_Values.V[1] ? GT_Values.V[1] : xEUt;
            while (tempEUt <= GT_Values.V[this.mTier - 1] * (long)this.mAmperage) {
                tempEUt <<= 2;
                xEUt <<= 2;
            }
            this.mEUt = xEUt > 0x7FFFFFFEL ? 0x7FFFFFFE : (int)xEUt;
        }
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack) && aStack.getTagCompound() != null && aStack.getTagCompound().getCompoundTag("GT.CraftingComponents") != null;
    }
}

