/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.damagesources.GT_DamageSources;
import gregtech.api.enums.GT_Values;
import gregtech.api.objects.XSTR;
import gregtech.common.items.armor.ArmorCalculation;
import gregtech.common.items.armor.ArmorData;
import gregtech.common.items.armor.Vector3;
import gregtech.common.items.armor.components.StatType;
import gregtech.common.items.armor.gui.ContainerBasicArmor;
import gregtech.common.items.armor.gui.ContainerModularArmor;
import gregtech.common.items.armor.gui.InventoryArmor;
import ic2.core.IC2;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import thaumcraft.api.IGoggles;
import thaumcraft.api.nodes.IRevealer;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.IGoggles", modid="Thaumcraft", striprefs=true), @Optional.Interface(iface="thaumcraft.api.nodes.IRevealer", modid="Thaumcraft", striprefs=true)})
public class ModularArmor_Item
extends ItemArmor
implements ISpecialArmor,
IGoggles,
IRevealer {
    public String mName;
    public int timer = 160;
    public Item repairMaterial;
    public int openGuiNr;
    public ArmorData data;
    public int jumpticks;
    public int fail = 0;

    public ModularArmor_Item(int aArmorIndex, int aType, String name, int gui) {
        super(ItemArmor.ArmorMaterial.DIAMOND, aArmorIndex, aType);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setUnlocalizedName("gregtech:" + name);
        GameRegistry.registerItem((Item)this, (String)name);
        this.mName = name;
        int mMaxDamage = (gui + 1) * 1024;
        mMaxDamage = (int)((double)mMaxDamage * (this.getBaseAbsorptionRatio() * 2.5));
        this.setMaxDamage(mMaxDamage);
        this.repairMaterial = Items.leather;
        this.openGuiNr = gui;
    }

    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (this.data == null) {
            this.data = this.fillArmorData(aPlayer, aStack);
        }
        if (!aWorld.isRemote) {
            aPlayer.openGui((Object)GT_Values.GT, this.openGuiNr + 1000, aWorld, (int)aPlayer.posX, (int)aPlayer.posY, (int)aPlayer.posZ);
        }
        return aStack;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (this.data == null) {
            this.data = this.fillArmorData((EntityPlayer)player, armor);
        }
        if (player != null && armor != null && source != null) {
            try {
                double tmp = 0.0;
                tmp = source.isMagicDamage() ? (double)this.data.mStat.get((Object)StatType.MAGICDEFENCE).floatValue() : (source == GT_DamageSources.getRadioactiveDamage() ? (double)this.data.mStat.get((Object)StatType.RADIATIONDEFENCE).floatValue() : (source == GT_DamageSources.getElectricDamage() ? (double)this.data.mStat.get((Object)StatType.ELECTRICALDEFENCE).floatValue() : (source == DamageSource.wither ? (double)this.data.mStat.get((Object)StatType.WITHERDEFENCE).floatValue() : (source.isFireDamage() || source == GT_DamageSources.getHeatDamage() ? (double)this.data.mStat.get((Object)StatType.FIREDEFENCE).floatValue() : (source.isExplosion() ? (double)this.data.mStat.get((Object)StatType.EXPLOSIONDEFENCE).floatValue() : (source.isProjectile() ? (double)this.data.mStat.get((Object)StatType.PROJECTILEDEFENCE).floatValue() : (double)this.data.mStat.get((Object)StatType.PHYSICALDEFENCE).floatValue()))))));
                if ((double)this.data.mStat.get((Object)StatType.THORNS).floatValue() > 0.1 && source != DamageSource.fall && source.getSourceOfDamage() != null) {
                    source.getSourceOfDamage().attackEntityFrom(new DamageSource("Thorns"), this.data.mStat.get((Object)StatType.THORNS).floatValue());
                }
                if (source == DamageSource.fall) {
                    int fallDef = 0;
                    ItemStack stack = player.getEquipmentInSlot(1);
                    if (stack != null && stack.getItem() instanceof ModularArmor_Item) {
                        fallDef = Math.round(this.data.boots.mStat.get((Object)StatType.FALLDEFENCE).floatValue());
                    }
                    tmp = 1.0 - ((double)fallDef > damage ? 0.0 : (1.0 - tmp) * 0.5);
                }
                if (tmp == 0.0) {
                    tmp = this.data.mStat.get((Object)StatType.PHYSICALDEFENCE).floatValue();
                }
                if (this.openGuiNr == 2) {
                    tmp = 1.0 - (1.0 - tmp) / 2.0;
                }
                return new ISpecialArmor.ArmorProperties(0, this.data.getBaseAbsorptionRatio() * tmp, 1000);
            }
            catch (Exception e) {
                System.err.println(e);
                return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
            }
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (this.data == null) {
            this.data = this.fillArmorData(player, armor);
        }
        int tmp = (int)(-Math.floor(-(this.data.getBaseAbsorptionRatio() * 20.0 * (double)this.data.mStat.get((Object)StatType.PHYSICALDEFENCE).floatValue())));
        return tmp;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        if (this.data == null) {
            this.data = this.fillArmorData(player, itemStack);
        }
        if (this.data.info != null) {
            info.addAll(this.data.info);
        }
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (this.data == null) {
            this.data = this.fillArmorData((EntityPlayer)entity, stack);
        }
        stack.damageItem(damage, entity);
        ContainerBasicArmor tmp = new ContainerBasicArmor((EntityPlayer)entity, new InventoryArmor(ModularArmor_Item.class, stack));
        if (stack.getItemDamage() > stack.getMaxDamage() / 2 && XSTR.XSTR_INSTANCE.nextInt(100) < 5) {
            tmp.getSlot(XSTR.XSTR_INSTANCE.nextInt(((ContainerModularArmor)tmp).getSlotCount())).decrStackSize(1);
            tmp.mInvArmor.onGuiSaved((EntityPlayer)entity);
        }
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ItemStack armor = player.inventory.armorInventory[0];
            if (this.data != null && event != null && this.data.type == 3 && (float)this.data.charge >= this.data.mStat.get((Object)StatType.PISTONEUUSAGE).floatValue() && event.distance - 3.0f <= this.data.mStat.get((Object)StatType.FALLDEFENCE).floatValue()) {
                event.setCanceled(true);
            } else if (this.data != null && event != null && this.data.type == 3 && (float)this.data.charge >= this.data.mStat.get((Object)StatType.PISTONEUUSAGE).floatValue()) {
                event.distance -= this.data.mStat.get((Object)StatType.FALLDEFENCE).floatValue();
            }
        }
    }

    public void onArmorTick(World aWorld, EntityPlayer aPlayer, ItemStack aStack) {
        if (this.fail > 0) {
            --this.fail;
            return;
        }
        try {
            if (this.data == null) {
                this.data = this.fillArmorData(aPlayer, aStack);
            }
            if (this.data.tooltipUpdate > 40) {
                this.data.armorPartsEquipped(aPlayer);
                this.data.tooltipUpdate = 0;
                this.data.updateTooltip();
            } else {
                ++this.data.tooltipUpdate;
            }
            this.jumpticks = aPlayer.onGround ? 4 : --this.jumpticks;
            if (this.data.type == 0 && aPlayer.getAir() < 100 && this.data.fluid != null) {
                int air = 0;
                if (this.data.fluid.getUnlocalizedName().equals("fluid.oxygen") && this.data.fluid.amount >= 150) {
                    aPlayer.setAir(aPlayer.getAir() + 150);
                    air = 150;
                } else if (this.data.fluid.getUnlocalizedName().equals("fluid.air") && this.data.fluid.amount >= 500) {
                    aPlayer.setAir(aPlayer.getAir() + 100);
                    air = 500;
                }
                if (air > 0) {
                    this.data.fluid.amount -= air;
                    ItemStack stack = aPlayer.getEquipmentInSlot(4);
                    if (stack != null && stack.getItem() instanceof ModularArmor_Item) {
                        ModularArmor_Item tmp = (ModularArmor_Item)stack.getItem();
                        ContainerBasicArmor tmp2 = new ContainerBasicArmor(aPlayer, new InventoryArmor(ModularArmor_Item.class, stack));
                        ArmorCalculation.useFluid(tmp2.mInvArmor.parts, air);
                    }
                }
            }
            if (this.data.tooltipUpdate == 40 && this.data.mStat.get((Object)StatType.PROCESSINGPOWER).floatValue() > this.data.mStat.get((Object)StatType.PROCESSINGPOWERUSED).floatValue() && this.data.type == 0 && this.data.fluid != null && this.data.fluid.getUnlocalizedName().equals("oxygen") && (float)this.data.fluid.amount < this.data.mStat.get((Object)StatType.TANKCAP).floatValue() && (float)this.data.charge > this.data.mStat.get((Object)StatType.ELECTROLYZEREUUSAGE).floatValue()) {
                this.data.charge = (int)((float)this.data.charge - this.data.mStat.get((Object)StatType.ELECTROLYZEREUUSAGE).floatValue());
                ItemStack stack = aPlayer.getEquipmentInSlot(4);
                if (stack != null && stack.getItem() instanceof ModularArmor_Item) {
                    ModularArmor_Item tmp = (ModularArmor_Item)stack.getItem();
                    ContainerBasicArmor tmp2 = new ContainerBasicArmor(aPlayer, new InventoryArmor(ModularArmor_Item.class, stack));
                    ArmorCalculation.useFluid(tmp2.mInvArmor.parts, -Math.round(this.data.mStat.get((Object)StatType.ELECTROLYZERPROD).floatValue()));
                }
            }
            if (this.data.isTopItem) {
                if (IC2.keyboard.isModeSwitchKeyDown(aPlayer) && !aWorld.isRemote) {
                    int typeMod = 0;
                    switch (this.data.type) {
                        case 0: {
                            typeMod = 400;
                            break;
                        }
                        case 1: {
                            typeMod = 300;
                            break;
                        }
                        case 2: {
                            typeMod = 200;
                            break;
                        }
                        case 3: {
                            typeMod = 100;
                        }
                    }
                    aPlayer.openGui((Object)GT_Values.GT, this.openGuiNr + typeMod, aWorld, (int)aPlayer.posX, (int)aPlayer.posY, (int)aPlayer.posZ);
                }
                if (this.timer >= 200) {
                    this.timer = 0;
                    if (this.data.mStat.get((Object)StatType.PROCESSINGPOWER).floatValue() > this.data.mStat.get((Object)StatType.PROCESSINGPOWERUSED).floatValue() && this.data.helmet != null && this.data.helmet.mBStat.get((Object)StatType.NIGHTVISION).booleanValue() && this.data.charge > 3) {
                        aPlayer.addPotionEffect(new PotionEffect(Potion.nightVision.getId(), 500, -3));
                        this.data.charge -= 4;
                    } else {
                        PotionEffect nv = aPlayer.getActivePotionEffect(Potion.nightVision);
                        if (nv != null && nv.getAmplifier() == -3) {
                            if (aPlayer.worldObj.isRemote) {
                                aPlayer.removePotionEffectClient(Potion.nightVision.id);
                            } else {
                                aPlayer.removePotionEffect(Potion.nightVision.id);
                            }
                        }
                    }
                } else {
                    ++this.timer;
                }
                if (this.data.mStat.get((Object)StatType.MAGNET).floatValue() > 1.0f) {
                    double x = aPlayer.posX;
                    double y = aPlayer.posY - (aPlayer.worldObj.isRemote ? 1.62 : 0.0) + 0.75;
                    double z = aPlayer.posZ;
                    int tMagnet = Math.round(this.data.mStat.get((Object)StatType.MAGNET).floatValue());
                    List items = aPlayer.worldObj.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)(x - (double)tMagnet), (double)(y - (double)tMagnet), (double)(z - (double)tMagnet), (double)(x + (double)tMagnet), (double)(y + (double)tMagnet), (double)(z + (double)tMagnet)));
                    for (EntityItem item : items) {
                        ItemStack stack = item.getEntityItem();
                        if (item.isDead || stack == null) continue;
                        this.setEntityMotionFromVector((Entity)item, new Vector3(x, y, z), 0.45f);
                    }
                }
                double motorSpeed = 0.0;
                if (this.data.leggings != null) {
                    motorSpeed = this.data.leggings.mStat.get((Object)StatType.MOTPRPOWER).floatValue();
                }
                if (this.data.maxWeight > 4000.0f) {
                    if (this.data.leggings != null && (float)this.data.leggings.charge > this.data.leggings.mStat.get((Object)StatType.MOTOREUUSAGE).floatValue()) {
                        motorSpeed -= (double)(this.data.maxWeight - 4000.0f);
                        this.data.leggings.charge = (int)((float)this.data.leggings.charge - this.data.leggings.mStat.get((Object)StatType.MOTOREUUSAGE).floatValue() / 100.0f);
                    } else {
                        aPlayer.motionX *= 4000.0 / (double)this.data.maxWeight;
                        aPlayer.motionZ *= 4000.0 / (double)this.data.maxWeight;
                    }
                }
                if (this.data.leggings != null && (float)this.data.leggings.charge > this.data.leggings.mStat.get((Object)StatType.MOTOREUUSAGE).floatValue() && this.data.mStat.get((Object)StatType.PROCESSINGPOWER).floatValue() > this.data.mStat.get((Object)StatType.PROCESSINGPOWERUSED).floatValue() && motorSpeed > 0.0 && aPlayer.isSprinting() && this.jumpticks > 0 && aPlayer.onGround && Math.abs(aPlayer.motionX) + Math.abs(aPlayer.motionZ) > (double)0.1f) {
                    this.data.leggings.charge = (int)((float)this.data.leggings.charge - this.data.leggings.mStat.get((Object)StatType.MOTOREUUSAGE).floatValue());
                    motorSpeed = Math.sqrt(motorSpeed) / 3.0;
                    float var7 = (float)((double)0.02f * motorSpeed);
                    if (aPlayer.isInWater()) {
                        var7 = 0.1f;
                        if (aPlayer.motionY > 0.0) {
                            aPlayer.motionY += (double)0.1f;
                        }
                    }
                    if (var7 > 0.0f) {
                        aPlayer.moveFlying(0.0f, 1.0f, var7);
                    }
                }
                if (this.data.mStat.get((Object)StatType.PROCESSINGPOWER).floatValue() > this.data.mStat.get((Object)StatType.PROCESSINGPOWERUSED).floatValue() && this.data.leggings != null) {
                    double stepup = this.data.leggings.mStat.get((Object)StatType.PISTONJUMPBOOST).floatValue();
                    if (stepup > 1.0) {
                        aPlayer.stepHeight = 1.0f;
                    }
                    if (aWorld.isRemote && GameSettings.isKeyDown((KeyBinding)Minecraft.getMinecraft().gameSettings.keyBindJump)) {
                        if (stepup > 0.0 && this.jumpticks > 0) {
                            if (this.data.maxWeight > 2000.0f) {
                                stepup *= 2000.0 / (double)this.data.maxWeight;
                            }
                            aPlayer.motionY += 0.04 * stepup;
                        }
                        aPlayer.jumpMovementFactor = aPlayer.getAIMoveSpeed() * 0.2f;
                    }
                }
                LinkedList effects = new LinkedList(aPlayer.getActivePotionEffects());
                for (PotionEffect effect : effects) {
                    int id = effect.getPotionID();
                    if (id != 24 || !this.data.mBStat.get((Object)StatType.FULLRADIATIONARMOR).booleanValue()) continue;
                    aPlayer.removePotionEffect(id);
                }
            }
        }
        catch (Exception e) {
            System.err.print(e);
            this.fail = 200;
        }
    }

    public void setEntityMotionFromVector(Entity entity, Vector3 originalPosVector, float modifier) {
        Vector3 entityVector = Vector3.fromEntityCenter(entity);
        Vector3 finalVector = originalPosVector.copy().subtract(entityVector);
        if (finalVector.mag() > 1.0) {
            finalVector.normalize();
        }
        entity.motionX = finalVector.x * (double)modifier;
        entity.motionY = finalVector.y * (double)modifier;
        entity.motionZ = finalVector.z * (double)modifier;
    }

    public int getItemEnchantability() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aIconRegister) {
        this.itemIcon = aIconRegister.registerIcon("gregtech:" + this.mName);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        String armor = "gregtech:armorhelmet.png";
        String tier = "";
        try {
            if (this.data == null) {
                this.data = this.fillArmorData((EntityPlayer)entity, stack);
            }
            if (this.data.armorTier == 0) {
                tier = "basic";
            } else if (this.data.armorTier == 1) {
                tier = "e1";
            } else if (this.data.armorTier == 2) {
                tier = "e2";
            }
            armor = this.data.type == 0 || this.data.type == 1 || this.data.type == 3 ? "gregtech:textures/models/armor/" + tier + "_helmet_chest.png" : "gregtech:textures/models/armor/" + tier + "_leggings_boots.png";
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return armor;
    }

    public boolean showNodes(ItemStack aStack, EntityLivingBase aPlayer) {
        if (this.data == null) {
            this.data = this.fillArmorData((EntityPlayer)aPlayer, aStack);
        }
        return this.data.mBStat.get((Object)StatType.THAUMICGOGGLES) != false && this.data.armorTier > 0 && this.data.charge > 0;
    }

    public boolean showIngamePopups(ItemStack aStack, EntityLivingBase aPlayer) {
        if (this.data == null) {
            this.data = this.fillArmorData((EntityPlayer)aPlayer, aStack);
        }
        return this.data.mBStat.get((Object)StatType.THAUMICGOGGLES) != false && this.data.armorTier > 0 && this.data.charge > 0;
    }

    public ArmorData fillArmorData(EntityPlayer player, ItemStack stack) {
        return new ArmorData(player, stack, this.armorType, this.openGuiNr);
    }

    public double getBaseAbsorptionRatio() {
        switch (this.armorType) {
            case 0: {
                return 0.15;
            }
            case 1: {
                return 0.4;
            }
            case 2: {
                return 0.3;
            }
            case 3: {
                return 0.15;
            }
        }
        return 0.0;
    }
}

