/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import java.util.BitSet;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class GT_MetaGenerated_Item_99
extends GT_MetaGenerated_Item {
    public static GT_MetaGenerated_Item_99 INSTANCE;
    private BitSet enabled = new BitSet();

    private void register(Materials tMaterial, int i) {
        ItemStack tStack = new ItemStack((Item)this, 1, i);
        this.enabled.set(i);
        GT_LanguageManager.addStringLocalization(this.getUnlocalizedName(tStack) + ".name", this.getDefaultLocalizationFormat(OrePrefixes.cellMolten, tMaterial, i));
        GT_LanguageManager.addStringLocalization(this.getUnlocalizedName(tStack) + ".tooltip", tMaterial.getToolTip(OrePrefixes.cellMolten.mMaterialAmount / 3628800L));
        if (OrePrefixes.cellMolten.mIsUnificatable) {
            GT_OreDictUnificator.set(OrePrefixes.cellMolten, tMaterial, tStack);
        } else {
            GT_OreDictUnificator.registerOre(OrePrefixes.cellMolten.get(tMaterial), tStack);
        }
    }

    public GT_MetaGenerated_Item_99() {
        super("metaitem.99", (short)1000, (short)0);
        INSTANCE = this;
        for (Materials tMaterial : GregTech_API.sGeneratedMaterials) {
            if (tMaterial == null || tMaterial.mMetaItemSubID < 0 || tMaterial.mMetaItemSubID >= 1000 || !tMaterial.contains(SubTag.SMELTING_TO_FLUID) || tMaterial.contains(SubTag.NO_SMELTING) || tMaterial.contains(SubTag.SMELTING_TO_GEM)) continue;
            this.register(tMaterial, tMaterial.mMetaItemSubID);
            if (tMaterial.mSmeltInto == tMaterial) continue;
            this.register(tMaterial.mSmeltInto, tMaterial.mSmeltInto.mMetaItemSubID);
        }
        this.mEnabledItems.clear();
        this.mVisibleItems.clear();
    }

    @Override
    public short[] getRGBa(ItemStack aStack) {
        Materials tMaterial = GregTech_API.sGeneratedMaterials[this.getDamage(aStack)];
        return tMaterial == null ? Materials._NULL.mMoltenRGBa : tMaterial.mMoltenRGBa;
    }

    @Deprecated
    public String getDefaultLocalization(OrePrefixes aPrefix, Materials aMaterial, int aMetaData) {
        return aPrefix.getDefaultLocalNameForItem(aMaterial);
    }

    public String getDefaultLocalizationFormat(OrePrefixes aPrefix, Materials aMaterial, int aMetaData) {
        return aPrefix.getDefaultLocalNameFormatForItem(aMaterial);
    }

    public boolean doesShowInCreative(OrePrefixes aPrefix, Materials aMaterial, boolean aDoShowAllItems) {
        return true;
    }

    public String getItemStackDisplayName(ItemStack aStack) {
        String aName = super.getItemStackDisplayName(aStack);
        int aDamage = aStack.getItemDamage();
        if (aDamage < 1000 && aDamage >= 0) {
            return Materials.getLocalizedNameForItem(aName, aDamage);
        }
        return aName;
    }

    @Override
    public ItemStack getContainerItem(ItemStack aStack) {
        int aDamage = aStack.getItemDamage();
        if (aDamage < 1000 && aDamage >= 0) {
            return OrePrefixes.cellMolten.mContainerItem;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void getSubItems(Item var1, CreativeTabs aCreativeTab, List aList) {
        for (int i = 0; i < 1000; ++i) {
            Materials aMaterial = GregTech_API.sGeneratedMaterials[i];
            if (aMaterial == null || !this.enabled.get(i)) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
        super.getSubItems(var1, aCreativeTab, aList);
    }

    @Override
    public final IIcon getIconFromDamage(int aMetaData) {
        if (aMetaData < 0) {
            return null;
        }
        if (aMetaData < 1000) {
            Materials tMaterial = GregTech_API.sGeneratedMaterials[aMetaData];
            if (tMaterial == null) {
                return null;
            }
            IIconContainer tIcon = this.getIconContainer(aMetaData);
            if (tIcon != null) {
                return tIcon.getIcon();
            }
            return null;
        }
        return null;
    }

    @Override
    public IIconContainer getIconContainer(int aMetaData) {
        if (aMetaData < 0) {
            return null;
        }
        if (aMetaData < 1000) {
            Materials tMaterial = GregTech_API.sGeneratedMaterials[aMetaData];
            if (tMaterial == null) {
                return null;
            }
            return tMaterial.mIconSet.mTextures[OrePrefixes.cellMolten.mTextureIndex];
        }
        return null;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return OrePrefixes.cellMolten.mDefaultStackSize;
    }
}

