/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class GT_Cover_SolarPanel
extends GT_CoverBehavior {
    private final int mVoltage;

    public GT_Cover_SolarPanel(int aVoltage) {
        this.mVoltage = aVoltage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aSide != 1) {
            return 0;
        }
        int coverState = aCoverVariable & 3;
        int coverNum = aCoverVariable >> 2;
        if (aTimer % 100L == 0L) {
            if (aTileEntity.getWorld().isThundering()) {
                return aTileEntity.getBiome().rainfall > 0.0f && aTileEntity.getSkyAtSide(aSide) ? Math.min(20, coverNum) << 2 : coverNum << 2;
            }
            if (aTileEntity.getWorld().isRaining() && aTileEntity.getBiome().rainfall > 0.0f) {
                if (aTileEntity.getSkyAtSide(aSide)) {
                    coverNum = Math.min(30, coverNum);
                }
                if (aTileEntity.getWorld().skylightSubtracted >= 4) {
                    if (!aTileEntity.getWorld().isDaytime()) return coverNum << 2;
                    coverState = 2;
                }
            } else {
                coverState = aTileEntity.getWorld().isDaytime() ? 1 : 2;
            }
        }
        if (coverState == 1) {
            aTileEntity.injectEnergyUnits((byte)6, (100L - (long)coverNum) * (long)this.mVoltage / 100L, 1L);
        }
        if (aTimer % 28800L != 0L || coverNum >= 100 || coverNum <= 10 && XSTR.XSTR_INSTANCE.nextInt(3) != 2) return coverState + (coverNum << 2);
        ++coverNum;
        return coverState + (coverNum << 2);
    }

    @Override
    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.capabilities.isCreativeMode) {
            GT_Utility.sendChatToPlayer(aPlayer, "Cleaned solar panel from " + (aCoverVariable >> 2) + "% dirt");
            aTileEntity.setCoverDataAtSide(aSide, aCoverVariable & 3);
            return true;
        }
        for (int i = 0; i < aPlayer.inventory.mainInventory.length; ++i) {
            ItemStack is = aPlayer.inventory.mainInventory[i];
            if (is == null || !is.getUnlocalizedName().equals(new ItemStack(Items.water_bucket).getUnlocalizedName())) continue;
            aPlayer.inventory.mainInventory[i] = new ItemStack(Items.bucket);
            if (aPlayer.inventoryContainer != null) {
                aPlayer.inventoryContainer.detectAndSendChanges();
            }
            GT_Utility.sendChatToPlayer(aPlayer, "Cleaned solar panel from " + (aCoverVariable >> 2) + "% dirt");
            aTileEntity.setCoverDataAtSide(aSide, aCoverVariable & 3);
            return true;
        }
        GT_Utility.sendChatToPlayer(aPlayer, "You need water bucket in inventory to clean the panel.");
        return false;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }
}

