/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import buildcraft.api.transport.IPipeTile;
import codechicken.translocator.TileItemTranslocator;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.transport.IItemDuct;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.damagesources.GT_DamageSources;
import gregtech.api.enchants.Enchantment_Radioactivity;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.Textures;
import gregtech.api.events.BlockScanningEvent;
import gregtech.api.interfaces.IDebugableBlock;
import gregtech.api.interfaces.IProjectileItem;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechDeviceInformation;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.interfaces.tileentity.IUpgradableMachine;
import gregtech.api.items.GT_EnergyArmor_Item;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.net.GT_Packet_Sound;
import gregtech.api.objects.GT_CopiedBlockTexture;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.threads.GT_Runnable_Sound;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_PlayedSound;
import gregtech.common.GT_Proxy;
import gregtech.common.GT_UndergroundOil;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.recipe.ICannerBottleRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.tile.IEnergyStorage;
import ic2.api.tile.IWrenchable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Utility {
    private static final List<FluidContainerRegistry.FluidContainerData> sFluidContainerList = new ArrayList<FluidContainerRegistry.FluidContainerData>();
    private static final Map<GT_ItemStack, FluidContainerRegistry.FluidContainerData> sFilledContainerToData = new HashMap<GT_ItemStack, FluidContainerRegistry.FluidContainerData>();
    private static final Map<GT_ItemStack, Map<Fluid, FluidContainerRegistry.FluidContainerData>> sEmptyContainerToFluidToData = new HashMap<GT_ItemStack, Map<Fluid, FluidContainerRegistry.FluidContainerData>>();
    public static volatile int VERSION = 509;
    public static boolean TE_CHECK = false;
    public static boolean BC_CHECK = false;
    public static boolean CHECK_ALL = true;
    public static boolean RF_CHECK = false;
    public static Map<GT_PlayedSound, Integer> sPlayedSoundMap = new HashMap<GT_PlayedSound, Integer>();
    private static int sBookCount = 0;
    public static UUID defaultUuid = null;

    public static int safeInt(long number, int margin) {
        return number > (long)(Integer.MAX_VALUE - margin) ? Integer.MAX_VALUE - margin : (int)number;
    }

    public static int safeInt(long number) {
        return number > GT_Values.V[GT_Values.V.length - 1] ? GT_Utility.safeInt(GT_Values.V[GT_Values.V.length - 1], 1) : (number < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)number);
    }

    public static Field getPublicField(Object aObject, String aField) {
        Field rField = null;
        try {
            rField = aObject.getClass().getDeclaredField(aField);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rField;
    }

    public static Field getField(Object aObject, String aField) {
        Field rField = null;
        try {
            rField = aObject.getClass().getDeclaredField(aField);
            rField.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rField;
    }

    public static Field getField(Class aObject, String aField) {
        Field rField = null;
        try {
            rField = aObject.getDeclaredField(aField);
            rField.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rField;
    }

    public static Method getMethod(Class aObject, String aMethod, Class<?> ... aParameterTypes) {
        Method rMethod = null;
        try {
            rMethod = aObject.getMethod(aMethod, aParameterTypes);
            rMethod.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rMethod;
    }

    public static Method getMethod(Object aObject, String aMethod, Class<?> ... aParameterTypes) {
        Method rMethod = null;
        try {
            rMethod = aObject.getClass().getMethod(aMethod, aParameterTypes);
            rMethod.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rMethod;
    }

    public static Field getField(Object aObject, String aField, boolean aPrivate, boolean aLogErrors) {
        try {
            Field tField;
            Field field = aObject instanceof Class ? ((Class)aObject).getDeclaredField(aField) : (tField = aObject instanceof String ? Class.forName((String)aObject).getDeclaredField(aField) : aObject.getClass().getDeclaredField(aField));
            if (aPrivate) {
                tField.setAccessible(true);
            }
            return tField;
        }
        catch (Throwable e) {
            if (aLogErrors) {
                e.printStackTrace(GT_Log.err);
            }
            return null;
        }
    }

    public static Object getFieldContent(Object aObject, String aField, boolean aPrivate, boolean aLogErrors) {
        try {
            Field tField;
            Field field = aObject instanceof Class ? ((Class)aObject).getDeclaredField(aField) : (tField = aObject instanceof String ? Class.forName((String)aObject).getDeclaredField(aField) : aObject.getClass().getDeclaredField(aField));
            if (aPrivate) {
                tField.setAccessible(true);
            }
            return tField.get(aObject instanceof Class || aObject instanceof String ? null : aObject);
        }
        catch (Throwable e) {
            if (aLogErrors) {
                e.printStackTrace(GT_Log.err);
            }
            return null;
        }
    }

    public static Object callPublicMethod(Object aObject, String aMethod, Object ... aParameters) {
        return GT_Utility.callMethod(aObject, aMethod, false, false, true, aParameters);
    }

    public static Object callPrivateMethod(Object aObject, String aMethod, Object ... aParameters) {
        return GT_Utility.callMethod(aObject, aMethod, true, false, true, aParameters);
    }

    public static Object callMethod(Object aObject, String aMethod, boolean aPrivate, boolean aUseUpperCasedDataTypes, boolean aLogErrors, Object ... aParameters) {
        try {
            Method tMethod;
            Class[] tParameterTypes = new Class[aParameters.length];
            for (int i = 0; i < aParameters.length; i = (int)((byte)(i + 1))) {
                if (aParameters[i] instanceof Class) {
                    tParameterTypes[i] = (Class)aParameters[i];
                    aParameters[i] = null;
                } else {
                    tParameterTypes[i] = aParameters[i].getClass();
                }
                if (aUseUpperCasedDataTypes) continue;
                if (tParameterTypes[i] == Boolean.class) {
                    tParameterTypes[i] = Boolean.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Byte.class) {
                    tParameterTypes[i] = Byte.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Short.class) {
                    tParameterTypes[i] = Short.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Integer.class) {
                    tParameterTypes[i] = Integer.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Long.class) {
                    tParameterTypes[i] = Long.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Float.class) {
                    tParameterTypes[i] = Float.TYPE;
                    continue;
                }
                if (tParameterTypes[i] != Double.class) continue;
                tParameterTypes[i] = Double.TYPE;
            }
            Method method = tMethod = aObject instanceof Class ? ((Class)aObject).getMethod(aMethod, tParameterTypes) : aObject.getClass().getMethod(aMethod, tParameterTypes);
            if (aPrivate) {
                tMethod.setAccessible(true);
            }
            return tMethod.invoke(aObject, aParameters);
        }
        catch (Throwable e) {
            if (aLogErrors) {
                e.printStackTrace(GT_Log.err);
            }
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object callConstructor(String aClass, int aConstructorIndex, Object aReplacementObject, boolean aLogErrors, Object ... aParameters) {
        if (aConstructorIndex < 0) {
            try {
                for (Constructor<?> tConstructor : Class.forName(aClass).getConstructors()) {
                    try {
                        return tConstructor.newInstance(aParameters);
                    }
                    catch (Throwable throwable) {
                    }
                }
                return aReplacementObject;
            }
            catch (Throwable e) {
                if (!aLogErrors) return aReplacementObject;
                e.printStackTrace(GT_Log.err);
                return aReplacementObject;
            }
        } else {
            try {
                return Class.forName(aClass).getConstructors()[aConstructorIndex].newInstance(aParameters);
            }
            catch (Throwable e) {
                if (!aLogErrors) return aReplacementObject;
                e.printStackTrace(GT_Log.err);
            }
        }
        return aReplacementObject;
    }

    public static String capitalizeString(String aString) {
        if (aString != null && aString.length() > 0) {
            return aString.substring(0, 1).toUpperCase() + aString.substring(1);
        }
        return "";
    }

    public static boolean getPotion(EntityLivingBase aPlayer, int aPotionIndex) {
        block4: {
            try {
                Field tPotionHashmap = null;
                for (Field var6 : EntityLiving.class.getDeclaredFields()) {
                    if (var6.getType() != HashMap.class) continue;
                    tPotionHashmap = var6;
                    tPotionHashmap.setAccessible(true);
                    break;
                }
                if (tPotionHashmap != null) {
                    return ((HashMap)tPotionHashmap.get(aPlayer)).get(aPotionIndex) != null;
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
        return false;
    }

    public static String getClassName(Object aObject) {
        if (aObject == null) {
            return "null";
        }
        return aObject.getClass().getName().substring(aObject.getClass().getName().lastIndexOf(".") + 1);
    }

    public static void removePotion(EntityLivingBase aPlayer, int aPotionIndex) {
        block4: {
            try {
                Field tPotionHashmap = null;
                for (Field var6 : EntityLiving.class.getDeclaredFields()) {
                    if (var6.getType() != HashMap.class) continue;
                    tPotionHashmap = var6;
                    tPotionHashmap.setAccessible(true);
                    break;
                }
                if (tPotionHashmap != null) {
                    ((HashMap)tPotionHashmap.get(aPlayer)).remove(aPotionIndex);
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
    }

    public static boolean getFullInvisibility(EntityPlayer aPlayer) {
        block4: {
            try {
                if (aPlayer.isInvisible()) {
                    for (int i = 0; i < 4; ++i) {
                        if (aPlayer.inventory.armorInventory[i] == null || !(aPlayer.inventory.armorInventory[i].getItem() instanceof GT_EnergyArmor_Item) || (((GT_EnergyArmor_Item)aPlayer.inventory.armorInventory[i].getItem()).mSpecials & 0x200) == 0 || !GT_ModHandler.canUseElectricItem(aPlayer.inventory.armorInventory[i], 10000)) continue;
                        return true;
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
        return false;
    }

    public static ItemStack suckOneItemStackAt(World aWorld, double aX, double aY, double aZ, double aL, double aH, double aW) {
        for (EntityItem tItem : (ArrayList)aWorld.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)aX, (double)aY, (double)aZ, (double)(aX + aL), (double)(aY + aH), (double)(aZ + aW)))) {
            if (tItem.isDead) continue;
            aWorld.removeEntity((Entity)tItem);
            tItem.setDead();
            return tItem.getEntityItem();
        }
        return null;
    }

    public static byte getOppositeSide(int aSide) {
        return (byte)ForgeDirection.getOrientation((int)aSide).getOpposite().ordinal();
    }

    public static byte getTier(long l) {
        byte i = -1;
        while ((i = (byte)((byte)(i + 1))) < GT_Values.V.length) {
            if (l > GT_Values.V[i]) continue;
            return i;
        }
        return i;
    }

    public static void sendChatToPlayer(EntityPlayer aPlayer, String aChatMessage) {
        if (aPlayer instanceof EntityPlayerMP && aChatMessage != null) {
            aPlayer.addChatComponentMessage((IChatComponent)new ChatComponentText(aChatMessage));
        }
    }

    public static void checkAvailabilities() {
        if (CHECK_ALL) {
            Class<IItemDuct> tClass2;
            try {
                tClass2 = IItemDuct.class;
                tClass2.getCanonicalName();
                TE_CHECK = true;
            }
            catch (Throwable tClass2) {
                // empty catch block
            }
            try {
                tClass2 = IPipeTile.class;
                tClass2.getCanonicalName();
                BC_CHECK = true;
            }
            catch (Throwable tClass3) {
                // empty catch block
            }
            try {
                tClass2 = IEnergyReceiver.class;
                tClass2.getCanonicalName();
                RF_CHECK = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CHECK_ALL = false;
        }
    }

    public static boolean isConnectableNonInventoryPipe(Object aTileEntity, int aSide) {
        if (aTileEntity == null) {
            return false;
        }
        GT_Utility.checkAvailabilities();
        if (TE_CHECK && aTileEntity instanceof IItemDuct) {
            return true;
        }
        if (BC_CHECK && aTileEntity instanceof IPipeTile) {
            return ((IPipeTile)aTileEntity).isPipeConnected(ForgeDirection.getOrientation((int)aSide));
        }
        return GregTech_API.mTranslocator && aTileEntity instanceof TileItemTranslocator;
    }

    public static byte moveStackIntoPipe(IInventory aTileEntity1, Object aTileEntity2, int[] aGrabSlots, int aGrabFrom, int aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        return GT_Utility.moveStackIntoPipe(aTileEntity1, aTileEntity2, aGrabSlots, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, true);
    }

    public static byte moveStackIntoPipe(IInventory aTileEntity1, Object aTileEntity2, int[] aGrabSlots, int aGrabFrom, int aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce, boolean dropItem) {
        if (aTileEntity1 == null || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMaxMoveAtOnce <= 0 || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        if (aTileEntity2 != null) {
            GT_Utility.checkAvailabilities();
            if (TE_CHECK && aTileEntity2 instanceof IItemDuct) {
                for (int i = 0; i < aGrabSlots.length; ++i) {
                    if (!GT_Utility.listContainsItem(aFilter, aTileEntity1.getStackInSlot(aGrabSlots[i]), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(aTileEntity1, aGrabSlots[i], (byte)aGrabFrom, aTileEntity1.getStackInSlot(aGrabSlots[i])) || Math.max(aMinMoveAtOnce, aMinTargetStackSize) > aTileEntity1.getStackInSlot((int)aGrabSlots[i]).stackSize) continue;
                    ItemStack tStack = GT_Utility.copyAmount(Math.min(aTileEntity1.getStackInSlot((int)aGrabSlots[i]).stackSize, Math.min(aMaxMoveAtOnce, aMaxTargetStackSize)), aTileEntity1.getStackInSlot(aGrabSlots[i]));
                    ItemStack rStack = ((IItemDuct)aTileEntity2).insertItem(ForgeDirection.getOrientation((int)aPutTo), GT_Utility.copy(tStack));
                    byte tMovedItemCount = (byte)(tStack.stackSize - (rStack == null ? 0 : rStack.stackSize));
                    if (tMovedItemCount < 1) continue;
                    aTileEntity1.decrStackSize(aGrabSlots[i], (int)tMovedItemCount);
                    aTileEntity1.markDirty();
                    return tMovedItemCount;
                }
                return 0;
            }
            if (BC_CHECK && aTileEntity2 instanceof IPipeTile) {
                for (int i = 0; i < aGrabSlots.length; ++i) {
                    ItemStack tStack;
                    byte tMovedItemCount;
                    if (!GT_Utility.listContainsItem(aFilter, aTileEntity1.getStackInSlot(aGrabSlots[i]), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(aTileEntity1, aGrabSlots[i], (byte)aGrabFrom, aTileEntity1.getStackInSlot(aGrabSlots[i])) || Math.max(aMinMoveAtOnce, aMinTargetStackSize) > aTileEntity1.getStackInSlot((int)aGrabSlots[i]).stackSize || (tMovedItemCount = (byte)((IPipeTile)aTileEntity2).injectItem(GT_Utility.copy(tStack = GT_Utility.copyAmount(Math.min(aTileEntity1.getStackInSlot((int)aGrabSlots[i]).stackSize, Math.min(aMaxMoveAtOnce, aMaxTargetStackSize)), aTileEntity1.getStackInSlot(aGrabSlots[i]))), false, ForgeDirection.getOrientation((int)aPutTo))) < Math.max(aMinMoveAtOnce, aMinTargetStackSize)) continue;
                    tMovedItemCount = (byte)((IPipeTile)aTileEntity2).injectItem(GT_Utility.copyAmount(tMovedItemCount, tStack), true, ForgeDirection.getOrientation((int)aPutTo));
                    aTileEntity1.decrStackSize(aGrabSlots[i], (int)tMovedItemCount);
                    aTileEntity1.markDirty();
                    return tMovedItemCount;
                }
                return 0;
            }
        }
        ForgeDirection tDirection = ForgeDirection.getOrientation((int)aGrabFrom);
        if (aTileEntity1 instanceof TileEntity && tDirection != ForgeDirection.UNKNOWN && tDirection.getOpposite() == ForgeDirection.getOrientation((int)aPutTo)) {
            int tX = ((TileEntity)aTileEntity1).xCoord + tDirection.offsetX;
            int tY = ((TileEntity)aTileEntity1).yCoord + tDirection.offsetY;
            int tZ = ((TileEntity)aTileEntity1).zCoord + tDirection.offsetZ;
            if (!GT_Utility.hasBlockHitBox(((TileEntity)aTileEntity1).getWorldObj(), tX, tY, tZ) && dropItem) {
                for (int i = 0; i < aGrabSlots.length; ++i) {
                    if (!GT_Utility.listContainsItem(aFilter, aTileEntity1.getStackInSlot(aGrabSlots[i]), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(aTileEntity1, aGrabSlots[i], (byte)aGrabFrom, aTileEntity1.getStackInSlot(aGrabSlots[i])) || Math.max(aMinMoveAtOnce, aMinTargetStackSize) > aTileEntity1.getStackInSlot((int)aGrabSlots[i]).stackSize) continue;
                    ItemStack tStack = GT_Utility.copyAmount(Math.min(aTileEntity1.getStackInSlot((int)aGrabSlots[i]).stackSize, Math.min(aMaxMoveAtOnce, aMaxTargetStackSize)), aTileEntity1.getStackInSlot(aGrabSlots[i]));
                    EntityItem tEntity = new EntityItem(((TileEntity)aTileEntity1).getWorldObj(), (double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5, tStack);
                    tEntity.motionZ = 0.0;
                    tEntity.motionY = 0.0;
                    tEntity.motionX = 0.0;
                    ((TileEntity)aTileEntity1).getWorldObj().spawnEntityInWorld((Entity)tEntity);
                    aTileEntity1.decrStackSize(aGrabSlots[i], tStack.stackSize);
                    aTileEntity1.markDirty();
                    return (byte)tStack.stackSize;
                }
            }
        }
        return 0;
    }

    public static byte moveStackFromSlotAToSlotB(IInventory aTileEntity1, IInventory aTileEntity2, int aGrabFrom, int aPutTo, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        if (aTileEntity1 == null || aTileEntity2 == null || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMaxMoveAtOnce <= 0 || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        ItemStack tStack1 = aTileEntity1.getStackInSlot(aGrabFrom);
        ItemStack tStack2 = aTileEntity2.getStackInSlot(aPutTo);
        ItemStack tStack3 = null;
        if (tStack1 != null) {
            if (tStack2 != null && !GT_Utility.areStacksEqual(tStack1, tStack2)) {
                return 0;
            }
            tStack3 = GT_Utility.copy(tStack1);
            aMaxTargetStackSize = (byte)Math.min(aMaxTargetStackSize, Math.min(tStack3.getMaxStackSize(), Math.min(tStack2 == null ? Integer.MAX_VALUE : tStack2.getMaxStackSize(), aTileEntity2.getInventoryStackLimit())));
            tStack3.stackSize = Math.min(tStack3.stackSize, aMaxTargetStackSize - (tStack2 == null ? 0 : tStack2.stackSize));
            if (tStack3.stackSize > aMaxMoveAtOnce) {
                tStack3.stackSize = aMaxMoveAtOnce;
            }
            if (tStack3.stackSize + (tStack2 == null ? 0 : tStack2.stackSize) >= Math.min(tStack3.getMaxStackSize(), aMinTargetStackSize) && tStack3.stackSize >= aMinMoveAtOnce) {
                tStack3 = aTileEntity1.decrStackSize(aGrabFrom, tStack3.stackSize);
                aTileEntity1.markDirty();
                if (tStack3 != null) {
                    if (tStack2 == null) {
                        aTileEntity2.setInventorySlotContents(aPutTo, GT_Utility.copy(tStack3));
                        aTileEntity2.markDirty();
                    } else {
                        tStack2.stackSize += tStack3.stackSize;
                        aTileEntity2.markDirty();
                    }
                    return (byte)tStack3.stackSize;
                }
            }
        }
        return 0;
    }

    public static boolean isAllowedToTakeFromSlot(IInventory aTileEntity, int aSlot, byte aSide, ItemStack aStack) {
        if (ForgeDirection.getOrientation((int)aSide) == ForgeDirection.UNKNOWN) {
            return GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)0, aStack) || GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)1, aStack) || GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)2, aStack) || GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)3, aStack) || GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)4, aStack) || GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)5, aStack);
        }
        if (aTileEntity instanceof ISidedInventory) {
            return ((ISidedInventory)aTileEntity).canExtractItem(aSlot, aStack, (int)aSide);
        }
        return true;
    }

    public static boolean isAllowedToPutIntoSlot(IInventory aTileEntity, int aSlot, byte aSide, ItemStack aStack, byte aMaxStackSize) {
        ItemStack tStack = aTileEntity.getStackInSlot(aSlot);
        if (!(tStack == null || GT_Utility.areStacksEqual(tStack, aStack) && tStack.stackSize < tStack.getMaxStackSize())) {
            return false;
        }
        if (ForgeDirection.getOrientation((int)aSide) == ForgeDirection.UNKNOWN) {
            return GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)0, aStack, aMaxStackSize) || GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)1, aStack, aMaxStackSize) || GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)2, aStack, aMaxStackSize) || GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)3, aStack, aMaxStackSize) || GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)4, aStack, aMaxStackSize) || GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)5, aStack, aMaxStackSize);
        }
        if (aTileEntity instanceof ISidedInventory && !((ISidedInventory)aTileEntity).canInsertItem(aSlot, aStack, (int)aSide)) {
            return false;
        }
        return aSlot < aTileEntity.getSizeInventory() && aTileEntity.isItemValidForSlot(aSlot, aStack);
    }

    public static byte moveOneItemStack(Object aTileEntity1, Object aTileEntity2, byte aGrabFrom, byte aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        if (aTileEntity1 instanceof IInventory) {
            return GT_Utility.moveOneItemStack((IInventory)aTileEntity1, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, true);
        }
        return 0;
    }

    private static byte moveOneItemStack(IInventory aTileEntity1, Object aTileEntity2, byte aGrabFrom, byte aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce, boolean aDoCheckChests) {
        if (aTileEntity1 == null || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        int[] tGrabSlots = null;
        if (aTileEntity1 instanceof ISidedInventory) {
            tGrabSlots = ((ISidedInventory)aTileEntity1).getAccessibleSlotsFromSide((int)aGrabFrom);
        }
        if (tGrabSlots == null) {
            tGrabSlots = new int[aTileEntity1.getSizeInventory()];
            for (int i = 0; i < tGrabSlots.length; ++i) {
                tGrabSlots[i] = i;
            }
        }
        if (aTileEntity2 instanceof IInventory) {
            byte tAmount;
            int i;
            int[] tPutSlots = null;
            if (aTileEntity2 instanceof ISidedInventory) {
                tPutSlots = ((ISidedInventory)aTileEntity2).getAccessibleSlotsFromSide((int)aPutTo);
            }
            if (tPutSlots == null) {
                tPutSlots = new int[((IInventory)aTileEntity2).getSizeInventory()];
                for (i = 0; i < tPutSlots.length; ++i) {
                    tPutSlots[i] = i;
                }
            }
            for (i = 0; i < tGrabSlots.length; ++i) {
                byte tMovedItemCount = 0;
                ItemStack tGrabStack = aTileEntity1.getStackInSlot(tGrabSlots[i]);
                if (GT_Utility.listContainsItem(aFilter, tGrabStack, true, aInvertFilter) && tGrabStack.stackSize >= aMinMoveAtOnce && GT_Utility.isAllowedToTakeFromSlot(aTileEntity1, tGrabSlots[i], aGrabFrom, tGrabStack)) {
                    for (int j = 0; j < tPutSlots.length; ++j) {
                        if (!GT_Utility.isAllowedToPutIntoSlot((IInventory)aTileEntity2, tPutSlots[j], aPutTo, tGrabStack, aMaxTargetStackSize) || (tMovedItemCount = (byte)(tMovedItemCount + GT_Utility.moveStackFromSlotAToSlotB(aTileEntity1, (IInventory)aTileEntity2, tGrabSlots[i], tPutSlots[j], aMaxTargetStackSize, aMinTargetStackSize, (byte)(aMaxMoveAtOnce - tMovedItemCount), aMinMoveAtOnce))) < aMaxMoveAtOnce && (tMovedItemCount <= 0 || aMaxTargetStackSize >= 64)) continue;
                        return tMovedItemCount;
                    }
                }
                if (tMovedItemCount <= 0) continue;
                return tMovedItemCount;
            }
            if (aDoCheckChests && aTileEntity1 instanceof TileEntityChest) {
                TileEntityChest tTileEntity1 = (TileEntityChest)aTileEntity1;
                if (tTileEntity1.adjacentChestChecked) {
                    tAmount = 0;
                    if (tTileEntity1.adjacentChestXNeg != null) {
                        tAmount = GT_Utility.moveOneItemStack((IInventory)tTileEntity1.adjacentChestXNeg, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity1.adjacentChestZNeg != null) {
                        tAmount = GT_Utility.moveOneItemStack((IInventory)tTileEntity1.adjacentChestZNeg, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity1.adjacentChestXPos != null) {
                        tAmount = GT_Utility.moveOneItemStack((IInventory)tTileEntity1.adjacentChestXPos, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity1.adjacentChestZPos != null) {
                        tAmount = GT_Utility.moveOneItemStack((IInventory)tTileEntity1.adjacentChestZPos, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    }
                    if (tAmount != 0) {
                        return tAmount;
                    }
                }
            }
            if (aDoCheckChests && aTileEntity2 instanceof TileEntityChest) {
                TileEntityChest tTileEntity2 = (TileEntityChest)aTileEntity2;
                if (tTileEntity2.adjacentChestChecked) {
                    tAmount = 0;
                    if (tTileEntity2.adjacentChestXNeg != null) {
                        tAmount = GT_Utility.moveOneItemStack(aTileEntity1, tTileEntity2.adjacentChestXNeg, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity2.adjacentChestZNeg != null) {
                        tAmount = GT_Utility.moveOneItemStack(aTileEntity1, tTileEntity2.adjacentChestZNeg, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity2.adjacentChestXPos != null) {
                        tAmount = GT_Utility.moveOneItemStack(aTileEntity1, tTileEntity2.adjacentChestXPos, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity2.adjacentChestZPos != null) {
                        tAmount = GT_Utility.moveOneItemStack(aTileEntity1, tTileEntity2.adjacentChestZPos, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    }
                    if (tAmount != 0) {
                        return tAmount;
                    }
                }
            }
        }
        return GT_Utility.moveStackIntoPipe(aTileEntity1, aTileEntity2, tGrabSlots, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aDoCheckChests);
    }

    public static byte moveOneItemStackIntoSlot(Object aTileEntity1, Object aTileEntity2, byte aGrabFrom, int aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        int i;
        if (aTileEntity1 == null || !(aTileEntity1 instanceof IInventory) || aPutTo < 0 || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        int[] tGrabSlots = null;
        if (aTileEntity1 instanceof ISidedInventory) {
            tGrabSlots = ((ISidedInventory)aTileEntity1).getAccessibleSlotsFromSide((int)aGrabFrom);
        }
        if (tGrabSlots == null) {
            tGrabSlots = new int[((IInventory)aTileEntity1).getSizeInventory()];
            for (i = 0; i < tGrabSlots.length; ++i) {
                tGrabSlots[i] = i;
            }
        }
        if (aTileEntity2 instanceof IInventory) {
            for (i = 0; i < tGrabSlots.length; ++i) {
                byte tMovedItemCount;
                if (!GT_Utility.listContainsItem(aFilter, ((IInventory)aTileEntity1).getStackInSlot(tGrabSlots[i]), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot((IInventory)aTileEntity1, tGrabSlots[i], aGrabFrom, ((IInventory)aTileEntity1).getStackInSlot(tGrabSlots[i])) || !GT_Utility.isAllowedToPutIntoSlot((IInventory)aTileEntity2, aPutTo, (byte)6, ((IInventory)aTileEntity1).getStackInSlot(tGrabSlots[i]), aMaxTargetStackSize) || (tMovedItemCount = GT_Utility.moveStackFromSlotAToSlotB((IInventory)aTileEntity1, (IInventory)aTileEntity2, tGrabSlots[i], aPutTo, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce)) <= 0) continue;
                return tMovedItemCount;
            }
        }
        GT_Utility.moveStackIntoPipe((IInventory)aTileEntity1, aTileEntity2, tGrabSlots, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce);
        return 0;
    }

    public static byte moveFromSlotToSlot(IInventory aTileEntity1, IInventory aTileEntity2, int aGrabFrom, int aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        byte tMovedItemCount;
        if (aTileEntity1 == null || aTileEntity2 == null || aGrabFrom < 0 || aPutTo < 0 || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        if (GT_Utility.listContainsItem(aFilter, aTileEntity1.getStackInSlot(aGrabFrom), true, aInvertFilter) && GT_Utility.isAllowedToTakeFromSlot(aTileEntity1, aGrabFrom, (byte)6, aTileEntity1.getStackInSlot(aGrabFrom)) && GT_Utility.isAllowedToPutIntoSlot(aTileEntity2, aPutTo, (byte)6, aTileEntity1.getStackInSlot(aGrabFrom), aMaxTargetStackSize) && (tMovedItemCount = GT_Utility.moveStackFromSlotAToSlotB(aTileEntity1, aTileEntity2, aGrabFrom, aPutTo, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce)) > 0) {
            return tMovedItemCount;
        }
        return 0;
    }

    public static byte moveFromSlotToSide(IInventory fromTile, Object toTile, int aGrabFrom, byte aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce, boolean aDoCheckChests) {
        if (fromTile == null || aGrabFrom < 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        if (!GT_Utility.listContainsItem(aFilter, fromTile.getStackInSlot(aGrabFrom), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(fromTile, aGrabFrom, (byte)6, fromTile.getStackInSlot(aGrabFrom))) {
            return 0;
        }
        if (toTile instanceof IInventory) {
            int[] tPutSlots = null;
            if (toTile instanceof ISidedInventory) {
                tPutSlots = ((ISidedInventory)toTile).getAccessibleSlotsFromSide((int)aPutTo);
            }
            if (tPutSlots == null) {
                tPutSlots = new int[((IInventory)toTile).getSizeInventory()];
                for (int i = 0; i < tPutSlots.length; ++i) {
                    tPutSlots[i] = i;
                }
            }
            byte tMovedItemCount = 0;
            for (int tPutSlot : tPutSlots) {
                if (!GT_Utility.isAllowedToPutIntoSlot((IInventory)toTile, tPutSlot, aPutTo, fromTile.getStackInSlot(aGrabFrom), aMaxTargetStackSize) || (tMovedItemCount = (byte)(tMovedItemCount + GT_Utility.moveStackFromSlotAToSlotB(fromTile, (IInventory)toTile, aGrabFrom, tPutSlot, aMaxTargetStackSize, aMinTargetStackSize, (byte)(aMaxMoveAtOnce - tMovedItemCount), aMinMoveAtOnce))) < aMaxMoveAtOnce) continue;
                return tMovedItemCount;
            }
            if (tMovedItemCount > 0) {
                return tMovedItemCount;
            }
            if (aDoCheckChests && toTile instanceof TileEntityChest) {
                TileEntityChest tTileEntity2 = (TileEntityChest)toTile;
                if (tTileEntity2.adjacentChestChecked) {
                    if (tTileEntity2.adjacentChestXNeg != null) {
                        tMovedItemCount = GT_Utility.moveFromSlotToSide(fromTile, tTileEntity2.adjacentChestXNeg, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity2.adjacentChestZNeg != null) {
                        tMovedItemCount = GT_Utility.moveFromSlotToSide(fromTile, tTileEntity2.adjacentChestZNeg, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity2.adjacentChestXPos != null) {
                        tMovedItemCount = GT_Utility.moveFromSlotToSide(fromTile, tTileEntity2.adjacentChestXPos, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity2.adjacentChestZPos != null) {
                        tMovedItemCount = GT_Utility.moveFromSlotToSide(fromTile, tTileEntity2.adjacentChestZPos, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    }
                    if (tMovedItemCount > 0) {
                        return tMovedItemCount;
                    }
                }
            }
        }
        return GT_Utility.moveStackIntoPipe(fromTile, toTile, new int[]{aGrabFrom}, 6, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aDoCheckChests);
    }

    public static byte moveFromSlotToSide(IInventory fromTile, Object toTile, int aGrabFrom, byte aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        return GT_Utility.moveFromSlotToSide(fromTile, toTile, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, true);
    }

    public static boolean listContainsItem(Collection<ItemStack> aList, ItemStack aStack, boolean aTIfListEmpty, boolean aInvertFilter) {
        if (aStack == null || aStack.stackSize < 1) {
            return false;
        }
        if (aList == null) {
            return aTIfListEmpty;
        }
        while (aList.contains(null)) {
            aList.remove(null);
        }
        if (aList.size() < 1) {
            return aTIfListEmpty;
        }
        Iterator<ItemStack> tIterator = aList.iterator();
        ItemStack tStack = null;
        while (tIterator.hasNext()) {
            tStack = tIterator.next();
            if (tStack == null || !GT_Utility.areStacksEqual(aStack, tStack)) continue;
            return !aInvertFilter;
        }
        return aInvertFilter;
    }

    public static boolean areStacksOrToolsEqual(ItemStack aStack1, ItemStack aStack2) {
        if (aStack1 != null && aStack2 != null && aStack1.getItem() == aStack2.getItem()) {
            if (aStack1.getItem().isDamageable()) {
                return true;
            }
            boolean bl = aStack1.getTagCompound() == null;
            boolean bl2 = aStack2.getTagCompound() == null;
            return !(bl != bl2 || aStack1.getTagCompound() != null && !aStack1.getTagCompound().equals((Object)aStack2.getTagCompound()) || Items.feather.getDamage(aStack1) != Items.feather.getDamage(aStack2) && Items.feather.getDamage(aStack1) != Short.MAX_VALUE && Items.feather.getDamage(aStack2) != Short.MAX_VALUE);
        }
        return false;
    }

    public static boolean areFluidsEqual(FluidStack aFluid1, FluidStack aFluid2) {
        return GT_Utility.areFluidsEqual(aFluid1, aFluid2, false);
    }

    public static boolean areFluidsEqual(FluidStack aFluid1, FluidStack aFluid2, boolean aIgnoreNBT) {
        return aFluid1 != null && aFluid2 != null && aFluid1.getFluid() == aFluid2.getFluid() && (aIgnoreNBT || aFluid1.tag == null == (aFluid2.tag == null) && (aFluid1.tag == null || aFluid1.tag.equals((Object)aFluid2.tag)));
    }

    public static boolean areStacksEqual(ItemStack aStack1, ItemStack aStack2) {
        return GT_Utility.areStacksEqual(aStack1, aStack2, false);
    }

    public static boolean areStacksEqual(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return !(aStack1 == null || aStack2 == null || aStack1.getItem() != aStack2.getItem() || !aIgnoreNBT && (aStack1.getTagCompound() == null != (aStack2.getTagCompound() == null) || aStack1.getTagCompound() != null && !aStack1.getTagCompound().equals((Object)aStack2.getTagCompound())) || Items.feather.getDamage(aStack1) != Items.feather.getDamage(aStack2) && Items.feather.getDamage(aStack1) != Short.MAX_VALUE && Items.feather.getDamage(aStack2) != Short.MAX_VALUE);
    }

    public static boolean areUnificationsEqual(ItemStack aStack1, ItemStack aStack2) {
        return GT_Utility.areUnificationsEqual(aStack1, aStack2, false);
    }

    public static boolean areUnificationsEqual(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return GT_Utility.areStacksEqual(GT_OreDictUnificator.get(aStack1), GT_OreDictUnificator.get(aStack2), aIgnoreNBT);
    }

    public static String getFluidName(Fluid aFluid, boolean aLocalized) {
        String rName;
        if (aFluid == null) {
            return "";
        }
        String string = rName = aLocalized ? aFluid.getLocalizedName(new FluidStack(aFluid, 0)) : aFluid.getUnlocalizedName();
        if (rName.contains("fluid.") || rName.contains("tile.")) {
            return GT_Utility.capitalizeString(rName.replaceAll("fluid.", "").replaceAll("tile.", ""));
        }
        return rName;
    }

    public static String getFluidName(FluidStack aFluid, boolean aLocalized) {
        if (aFluid == null) {
            return "";
        }
        return GT_Utility.getFluidName(aFluid.getFluid(), aLocalized);
    }

    public static void reInit() {
        sFilledContainerToData.clear();
        sEmptyContainerToFluidToData.clear();
        for (FluidContainerRegistry.FluidContainerData tData : sFluidContainerList) {
            sFilledContainerToData.put(new GT_ItemStack(tData.filledContainer), tData);
            Map<Fluid, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmptyContainerToFluidToData.get(new GT_ItemStack(tData.emptyContainer));
            if (tFluidToContainer == null) {
                tFluidToContainer = new HashMap<Fluid, FluidContainerRegistry.FluidContainerData>();
                sEmptyContainerToFluidToData.put(new GT_ItemStack(tData.emptyContainer), tFluidToContainer);
                GregTech_API.sFluidMappings.add(tFluidToContainer);
            }
            tFluidToContainer.put(tData.fluid.getFluid(), tData);
        }
    }

    public static void addFluidContainerData(FluidContainerRegistry.FluidContainerData aData) {
        sFluidContainerList.add(aData);
        sFilledContainerToData.put(new GT_ItemStack(aData.filledContainer), aData);
        Map<Fluid, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmptyContainerToFluidToData.get(new GT_ItemStack(aData.emptyContainer));
        if (tFluidToContainer == null) {
            tFluidToContainer = new HashMap<Fluid, FluidContainerRegistry.FluidContainerData>();
            sEmptyContainerToFluidToData.put(new GT_ItemStack(aData.emptyContainer), tFluidToContainer);
            GregTech_API.sFluidMappings.add(tFluidToContainer);
        }
        tFluidToContainer.put(aData.fluid.getFluid(), aData);
    }

    public static ItemStack fillFluidContainer(FluidStack aFluid, ItemStack aStack, boolean aRemoveFluidDirectly, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack) || aFluid == null) {
            return null;
        }
        if (GT_ModHandler.isWater(aFluid) && ItemList.Bottle_Empty.isStackEqual(aStack)) {
            if (aFluid.amount >= 250) {
                if (aRemoveFluidDirectly) {
                    aFluid.amount -= 250;
                }
                return new ItemStack((Item)Items.potionitem, 1, 0);
            }
            return null;
        }
        if (aCheckIFluidContainerItems && aStack.getItem() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.getItem()).getFluid(aStack) == null && ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) <= aFluid.amount) {
            if (aRemoveFluidDirectly) {
                IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.getItem();
                aStack = GT_Utility.copyAmount(1L, aStack);
                aFluid.amount -= iFluidContainerItem.fill(aStack, aFluid, true);
            } else {
                IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.getItem();
                aStack = GT_Utility.copyAmount(1L, aStack);
                iFluidContainerItem.fill(aStack, aFluid, true);
            }
            return aStack;
        }
        Map<Fluid, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmptyContainerToFluidToData.get(new GT_ItemStack(aStack));
        if (tFluidToContainer == null) {
            return null;
        }
        FluidContainerRegistry.FluidContainerData tData = tFluidToContainer.get(aFluid.getFluid());
        if (tData == null || tData.fluid.amount > aFluid.amount) {
            return null;
        }
        if (aRemoveFluidDirectly) {
            aFluid.amount -= tData.fluid.amount;
        }
        return GT_Utility.copyAmount(1L, tData.filledContainer);
    }

    public static ItemStack getFluidDisplayStack(Fluid aFluid) {
        return aFluid == null ? null : GT_Utility.getFluidDisplayStack(new FluidStack(aFluid, 0), false);
    }

    public static ItemStack getFluidDisplayStack(FluidStack aFluid, boolean aUseStackSize) {
        if (aFluid == null || aFluid.getFluid() == null) {
            return null;
        }
        int tmp = 0;
        try {
            tmp = aFluid.getFluid().getID();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        ItemStack rStack = ItemList.Display_Fluid.getWithDamage(1L, tmp, new Object[0]);
        NBTTagCompound tNBT = new NBTTagCompound();
        tNBT.setLong("mFluidDisplayAmount", aUseStackSize ? (long)aFluid.amount : 0L);
        tNBT.setLong("mFluidDisplayHeat", (long)aFluid.getFluid().getTemperature(aFluid));
        tNBT.setBoolean("mFluidState", aFluid.getFluid().isGaseous(aFluid));
        rStack.setTagCompound(tNBT);
        return rStack;
    }

    public static boolean containsFluid(ItemStack aStack, FluidStack aFluid, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack) || aFluid == null) {
            return false;
        }
        if (aCheckIFluidContainerItems && aStack.getItem() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) > 0) {
            IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.getItem();
            aStack = GT_Utility.copyAmount(1L, aStack);
            return aFluid.isFluidEqual(iFluidContainerItem.getFluid(aStack));
        }
        FluidContainerRegistry.FluidContainerData tData = sFilledContainerToData.get(new GT_ItemStack(aStack));
        return tData == null ? false : tData.fluid.isFluidEqual(aFluid);
    }

    public static FluidStack getFluidForFilledItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        if (aCheckIFluidContainerItems && aStack.getItem() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) > 0) {
            return ((IFluidContainerItem)aStack.getItem()).drain(GT_Utility.copyAmount(1L, aStack), Integer.MAX_VALUE, true);
        }
        FluidContainerRegistry.FluidContainerData tData = sFilledContainerToData.get(new GT_ItemStack(aStack));
        return tData == null ? null : tData.fluid.copy();
    }

    public static ItemStack getContainerForFilledItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        FluidContainerRegistry.FluidContainerData tData = sFilledContainerToData.get(new GT_ItemStack(aStack));
        if (tData != null) {
            return GT_Utility.copyAmount(1L, tData.emptyContainer);
        }
        if (aCheckIFluidContainerItems && aStack.getItem() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) > 0) {
            IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.getItem();
            aStack = GT_Utility.copyAmount(1L, aStack);
            iFluidContainerItem.drain(aStack, Integer.MAX_VALUE, true);
            return aStack;
        }
        return null;
    }

    public static ItemStack getContainerItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        if (aStack.getItem().hasContainerItem(aStack)) {
            return aStack.getItem().getContainerItem(aStack);
        }
        if (ItemList.Cell_Empty.isStackEqual(aStack, false, true)) {
            return null;
        }
        if (ItemList.IC2_Fuel_Can_Filled.isStackEqual(aStack, false, true)) {
            return ItemList.IC2_Fuel_Can_Empty.get(1L, new Object[0]);
        }
        if (aStack.getItem() == Items.potionitem || aStack.getItem() == Items.experience_bottle || ItemList.TF_Vial_FieryBlood.isStackEqual(aStack) || ItemList.TF_Vial_FieryTears.isStackEqual(aStack)) {
            return ItemList.Bottle_Empty.get(1L, new Object[0]);
        }
        if (aCheckIFluidContainerItems && aStack.getItem() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.getItem()).getCapacity(aStack) > 0) {
            ItemStack tStack = GT_Utility.copyAmount(1L, aStack);
            ((IFluidContainerItem)aStack.getItem()).drain(tStack, Integer.MAX_VALUE, true);
            if (!GT_Utility.areStacksEqual(aStack, tStack)) {
                return tStack;
            }
            return null;
        }
        int tCapsuleCount = GT_ModHandler.getCapsuleCellContainerCount(aStack);
        if (tCapsuleCount > 0) {
            return ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]);
        }
        if (ItemList.IC2_ForgeHammer.isStackEqual(aStack) || ItemList.IC2_WireCutter.isStackEqual(aStack)) {
            return GT_Utility.copyMetaData(Items.feather.getDamage(aStack) + 1, aStack);
        }
        return null;
    }

    public static synchronized boolean removeIC2BottleRecipe(ItemStack aContainer, ItemStack aInput, Map<ICannerBottleRecipeManager.Input, RecipeOutput> aRecipeList, ItemStack aOutput) {
        if (GT_Utility.isStackInvalid(aInput) && GT_Utility.isStackInvalid(aOutput) && GT_Utility.isStackInvalid(aContainer) || aRecipeList == null) {
            return false;
        }
        boolean rReturn = false;
        Iterator<Map.Entry<ICannerBottleRecipeManager.Input, RecipeOutput>> tIterator = aRecipeList.entrySet().iterator();
        aOutput = GT_OreDictUnificator.get(aOutput);
        block0: while (tIterator.hasNext()) {
            List tList;
            Map.Entry<ICannerBottleRecipeManager.Input, RecipeOutput> tEntry = tIterator.next();
            if (aInput != null && !tEntry.getKey().matches(aContainer, aInput) || (tList = tEntry.getValue().items) == null) continue;
            for (ItemStack tOutput : tList) {
                if (aOutput != null && !GT_Utility.areStacksEqual(GT_OreDictUnificator.get(tOutput), aOutput)) continue;
                tIterator.remove();
                rReturn = true;
                continue block0;
            }
        }
        return rReturn;
    }

    public static synchronized boolean removeSimpleIC2MachineRecipe(ItemStack aInput, Map<IRecipeInput, RecipeOutput> aRecipeList, ItemStack aOutput) {
        if (GT_Utility.isStackInvalid(aInput) && GT_Utility.isStackInvalid(aOutput) || aRecipeList == null) {
            return false;
        }
        boolean rReturn = false;
        Iterator<Map.Entry<IRecipeInput, RecipeOutput>> tIterator = aRecipeList.entrySet().iterator();
        aOutput = GT_OreDictUnificator.get(aOutput);
        block0: while (tIterator.hasNext()) {
            List tList;
            Map.Entry<IRecipeInput, RecipeOutput> tEntry = tIterator.next();
            if (aInput != null && !tEntry.getKey().matches(aInput) || (tList = tEntry.getValue().items) == null) continue;
            for (ItemStack tOutput : tList) {
                if (aOutput != null && !GT_Utility.areStacksEqual(GT_OreDictUnificator.get(tOutput), aOutput)) continue;
                tIterator.remove();
                rReturn = true;
                continue block0;
            }
        }
        return rReturn;
    }

    public static boolean addSimpleIC2MachineRecipe(ItemStack aInput, Map<IRecipeInput, RecipeOutput> aRecipeList, NBTTagCompound aNBT, Object ... aOutput) {
        if (GT_Utility.isStackInvalid(aInput) || aOutput.length == 0 || aRecipeList == null) {
            return false;
        }
        ItemData tOreName = GT_OreDictUnificator.getAssociation(aInput);
        for (int i = 0; i < aOutput.length; ++i) {
            if (aOutput[i] != null) continue;
            GT_Mod.GT_FML_LOGGER.info("EmptyIC2Output!" + aInput.getUnlocalizedName());
            return false;
        }
        ItemStack[] tStack = GT_OreDictUnificator.getStackArray(true, aOutput);
        if (tStack == null || tStack.length > 0 && GT_Utility.areStacksEqual(aInput, tStack[0])) {
            return false;
        }
        if (tOreName != null) {
            if (tOreName.toString().equals("dustAsh") && tStack[0].getUnlocalizedName().equals("tile.volcanicAsh")) {
                return false;
            }
            aRecipeList.put((IRecipeInput)new RecipeInputOreDict(tOreName.toString(), aInput.stackSize), new RecipeOutput(aNBT, tStack));
        } else {
            aRecipeList.put((IRecipeInput)new RecipeInputItemStack(GT_Utility.copy(aInput), aInput.stackSize), new RecipeOutput(aNBT, tStack));
        }
        return true;
    }

    public static ItemStack getWrittenBook(String aMapping, ItemStack aStackToPutNBT) {
        if (GT_Utility.isStringInvalid(aMapping)) {
            return null;
        }
        ItemStack rStack = GregTech_API.sBookList.get(aMapping);
        if (rStack == null) {
            return aStackToPutNBT;
        }
        if (aStackToPutNBT != null) {
            aStackToPutNBT.setTagCompound(rStack.getTagCompound());
            return aStackToPutNBT;
        }
        return GT_Utility.copyAmount(1L, rStack);
    }

    public static ItemStack getWrittenBook(String aMapping, String aTitle, String aAuthor, String ... aPages) {
        if (GT_Utility.isStringInvalid(aMapping)) {
            return null;
        }
        ItemStack rStack = GregTech_API.sBookList.get(aMapping);
        if (rStack != null) {
            return GT_Utility.copyAmount(1L, rStack);
        }
        if (GT_Utility.isStringInvalid(aTitle) || GT_Utility.isStringInvalid(aAuthor) || aPages.length <= 0) {
            return null;
        }
        ++sBookCount;
        rStack = new ItemStack(Items.written_book, 1);
        NBTTagCompound tNBT = new NBTTagCompound();
        tNBT.setString("title", GT_LanguageManager.addStringLocalization("Book." + aTitle + ".Name", aTitle));
        tNBT.setString("author", aAuthor);
        NBTTagList tNBTList = new NBTTagList();
        for (byte i = 0; i < aPages.length; i = (byte)(i + 1)) {
            aPages[i] = GT_LanguageManager.addStringLocalization("Book." + aTitle + ".Page" + (i < 10 ? "0" + i : Byte.valueOf(i)), aPages[i]);
            if (i < 48) {
                if (aPages[i].length() < 256) {
                    tNBTList.appendTag((NBTBase)new NBTTagString(aPages[i]));
                    continue;
                }
                GT_Log.err.println("WARNING: String for written Book too long! -> " + aPages[i]);
                continue;
            }
            GT_Log.err.println("WARNING: Too much Pages for written Book! -> " + aTitle);
            break;
        }
        tNBTList.appendTag((NBTBase)new NBTTagString("Credits to " + aAuthor + " for writing this Book. This was Book Nr. " + sBookCount + " at its creation. Gotta get 'em all!"));
        tNBT.setTag("pages", (NBTBase)tNBTList);
        rStack.setTagCompound(tNBT);
        GT_Log.out.println("GT_Mod: Added Book to Book List  -  Mapping: '" + aMapping + "'  -  Name: '" + aTitle + "'  -  Author: '" + aAuthor + "'");
        GregTech_API.sBookList.put(aMapping, rStack);
        return GT_Utility.copy(rStack);
    }

    public static boolean doSoundAtClient(String aSoundName, int aTimeUntilNextSound, float aSoundStrength) {
        return GT_Utility.doSoundAtClient(aSoundName, aTimeUntilNextSound, aSoundStrength, (Entity)GT_Values.GT.getThePlayer());
    }

    public static boolean doSoundAtClient(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, Entity aEntity) {
        if (aEntity == null) {
            return false;
        }
        return GT_Utility.doSoundAtClient(aSoundName, aTimeUntilNextSound, aSoundStrength, aEntity.posX, aEntity.posY, aEntity.posZ);
    }

    public static boolean doSoundAtClient(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, double aX, double aY, double aZ) {
        return GT_Utility.doSoundAtClient(aSoundName, aTimeUntilNextSound, aSoundStrength, 1.0181803f, aX, aY, aZ);
    }

    public static boolean doSoundAtClient(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, float aSoundModulation, double aX, double aY, double aZ) {
        if (GT_Utility.isStringInvalid(aSoundName) || !FMLCommonHandler.instance().getEffectiveSide().isClient() || GT_Values.GT.getThePlayer() == null || !GT_Values.GT.getThePlayer().worldObj.isRemote) {
            return false;
        }
        if (GregTech_API.sMultiThreadedSounds) {
            new Thread((Runnable)new GT_Runnable_Sound(GT_Values.GT.getThePlayer().worldObj, MathHelper.floor_double((double)aX), MathHelper.floor_double((double)aY), MathHelper.floor_double((double)aZ), aTimeUntilNextSound, aSoundName, aSoundStrength, aSoundModulation), "Sound Effect").start();
        } else {
            new GT_Runnable_Sound(GT_Values.GT.getThePlayer().worldObj, MathHelper.floor_double((double)aX), MathHelper.floor_double((double)aY), MathHelper.floor_double((double)aZ), aTimeUntilNextSound, aSoundName, aSoundStrength, aSoundModulation).run();
        }
        return true;
    }

    public static boolean sendSoundToPlayers(World aWorld, String aSoundName, float aSoundStrength, float aSoundModulation, int aX, int aY, int aZ) {
        if (GT_Utility.isStringInvalid(aSoundName) || aWorld == null || aWorld.isRemote) {
            return false;
        }
        GT_Values.NW.sendPacketToAllPlayersInRange(aWorld, new GT_Packet_Sound(aSoundName, aSoundStrength, aSoundModulation, aX, (short)aY, aZ), aX, aZ);
        return true;
    }

    public static int stackToInt(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return 0;
        }
        return Item.getIdFromItem((Item)aStack.getItem()) | Items.feather.getDamage(aStack) << 16;
    }

    public static int stackToWildcard(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return 0;
        }
        return Item.getIdFromItem((Item)aStack.getItem()) | 0x7FFF0000;
    }

    public static ItemStack intToStack(int aStack) {
        int tID = aStack & 0xFFFF;
        int tMeta = aStack >>> 16;
        Item tItem = Item.getItemById((int)tID);
        if (tItem != null) {
            return new ItemStack(tItem, 1, tMeta);
        }
        return null;
    }

    public static Integer[] stacksToIntegerArray(ItemStack ... aStacks) {
        Integer[] rArray = new Integer[aStacks.length];
        for (int i = 0; i < rArray.length; ++i) {
            rArray[i] = GT_Utility.stackToInt(aStacks[i]);
        }
        return rArray;
    }

    public static int[] stacksToIntArray(ItemStack ... aStacks) {
        int[] rArray = new int[aStacks.length];
        for (int i = 0; i < rArray.length; ++i) {
            rArray[i] = GT_Utility.stackToInt(aStacks[i]);
        }
        return rArray;
    }

    public static boolean arrayContains(Object aObject, Object ... aObjects) {
        return GT_Utility.listContains(aObject, Arrays.asList(aObjects));
    }

    public static boolean listContains(Object aObject, Collection aObjects) {
        if (aObjects == null) {
            return false;
        }
        return aObjects.contains(aObject);
    }

    public static <T> boolean arrayContainsNonNull(T ... aArray) {
        if (aArray != null) {
            for (T tObject : aArray) {
                if (tObject == null) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> ArrayList<T> getArrayListWithoutNulls(T ... aArray) {
        if (aArray == null) {
            return new ArrayList();
        }
        ArrayList<T> rList = new ArrayList<T>(Arrays.asList(aArray));
        for (int i = 0; i < rList.size(); ++i) {
            if (rList.get(i) != null) continue;
            rList.remove(i--);
        }
        return rList;
    }

    public static <T> ArrayList<T> getArrayListWithoutTrailingNulls(T ... aArray) {
        if (aArray == null) {
            return new ArrayList();
        }
        ArrayList<T> rList = new ArrayList<T>(Arrays.asList(aArray));
        int i = rList.size() - 1;
        while (i >= 0 && rList.get(i) == null) {
            rList.remove(i--);
        }
        return rList;
    }

    public static Block getBlock(Object aBlock) {
        return (Block)aBlock;
    }

    public static Block getBlockFromStack(ItemStack itemStack) {
        if (GT_Utility.isStackInvalid(itemStack)) {
            return Blocks.air;
        }
        return GT_Utility.getBlockFromItem(itemStack.getItem());
    }

    public static Block getBlockFromItem(Item item) {
        return Block.getBlockFromItem((Item)item);
    }

    public static boolean isBlockValid(Object aBlock) {
        return aBlock instanceof Block;
    }

    public static boolean isBlockInvalid(Object aBlock) {
        return aBlock == null || !(aBlock instanceof Block);
    }

    public static boolean isStringValid(Object aString) {
        return aString != null && !aString.toString().isEmpty();
    }

    public static boolean isStringInvalid(Object aString) {
        return aString == null || aString.toString().isEmpty();
    }

    public static boolean isStackValid(Object aStack) {
        return aStack instanceof ItemStack && ((ItemStack)aStack).getItem() != null && ((ItemStack)aStack).stackSize >= 0;
    }

    public static boolean isStackInvalid(Object aStack) {
        return aStack == null || !(aStack instanceof ItemStack) || ((ItemStack)aStack).getItem() == null || ((ItemStack)aStack).stackSize < 0;
    }

    public static boolean isDebugItem(ItemStack aStack) {
        return GT_Utility.areStacksEqual(GT_ModHandler.getIC2Item("debug", 1L), aStack, true);
    }

    public static ItemStack updateItemStack(ItemStack aStack) {
        if (GT_Utility.isStackValid(aStack) && aStack.getItem() instanceof GT_Generic_Item) {
            ((GT_Generic_Item)aStack.getItem()).isItemStackUsable(aStack);
        }
        return aStack;
    }

    public static boolean isOpaqueBlock(World aWorld, int aX, int aY, int aZ) {
        return aWorld.getBlock(aX, aY, aZ).isOpaqueCube();
    }

    public static boolean isBlockAir(World aWorld, int aX, int aY, int aZ) {
        return aWorld.getBlock(aX, aY, aZ).isAir((IBlockAccess)aWorld, aX, aY, aZ);
    }

    public static boolean hasBlockHitBox(World aWorld, int aX, int aY, int aZ) {
        return aWorld.getBlock(aX, aY, aZ).getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ) != null;
    }

    public static void setCoordsOnFire(World aWorld, int aX, int aY, int aZ, boolean aReplaceCenter) {
        if (aReplaceCenter && aWorld.getBlock(aX, aY, aZ).getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ) == null) {
            aWorld.setBlock(aX, aY, aZ, (Block)Blocks.fire);
        }
        if (aWorld.getBlock(aX + 1, aY, aZ).getCollisionBoundingBoxFromPool(aWorld, aX + 1, aY, aZ) == null) {
            aWorld.setBlock(aX + 1, aY, aZ, (Block)Blocks.fire);
        }
        if (aWorld.getBlock(aX - 1, aY, aZ).getCollisionBoundingBoxFromPool(aWorld, aX - 1, aY, aZ) == null) {
            aWorld.setBlock(aX - 1, aY, aZ, (Block)Blocks.fire);
        }
        if (aWorld.getBlock(aX, aY + 1, aZ).getCollisionBoundingBoxFromPool(aWorld, aX, aY + 1, aZ) == null) {
            aWorld.setBlock(aX, aY + 1, aZ, (Block)Blocks.fire);
        }
        if (aWorld.getBlock(aX, aY - 1, aZ).getCollisionBoundingBoxFromPool(aWorld, aX, aY - 1, aZ) == null) {
            aWorld.setBlock(aX, aY - 1, aZ, (Block)Blocks.fire);
        }
        if (aWorld.getBlock(aX, aY, aZ + 1).getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ + 1) == null) {
            aWorld.setBlock(aX, aY, aZ + 1, (Block)Blocks.fire);
        }
        if (aWorld.getBlock(aX, aY, aZ - 1).getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ - 1) == null) {
            aWorld.setBlock(aX, aY, aZ - 1, (Block)Blocks.fire);
        }
    }

    public static ItemStack getProjectile(SubTag aProjectileType, IInventory aInventory) {
        if (aInventory != null) {
            int j = aInventory.getSizeInventory();
            for (int i = 0; i < j; ++i) {
                ItemStack rStack = aInventory.getStackInSlot(i);
                if (!GT_Utility.isStackValid(rStack) || !(rStack.getItem() instanceof IProjectileItem) || !((IProjectileItem)rStack.getItem()).hasProjectile(aProjectileType, rStack)) continue;
                return GT_Utility.updateItemStack(rStack);
            }
        }
        return null;
    }

    public static void removeNullStacksFromInventory(IInventory aInventory) {
        if (aInventory != null) {
            int j = aInventory.getSizeInventory();
            for (int i = 0; i < j; ++i) {
                ItemStack tStack = aInventory.getStackInSlot(i);
                if (tStack == null || tStack.stackSize != 0 && tStack.getItem() != null) continue;
                aInventory.setInventorySlotContents(i, null);
            }
        }
    }

    public static boolean addTexturePage(byte page) {
        if (Textures.BlockIcons.casingTexturePages[page] == null) {
            Textures.BlockIcons.casingTexturePages[page] = new ITexture[128];
            return true;
        }
        return false;
    }

    public static int getTextureId(byte page, byte index) {
        if (page >= 0 && index >= 0) {
            return (page << 7) + index;
        }
        throw new RuntimeException("Index out of range: [" + page + "][" + index + "]");
    }

    public static int getTextureId(byte page, byte startIndex, byte blockMeta) {
        if (page >= 0 && startIndex >= 0 && blockMeta >= 0 && startIndex + blockMeta <= 127) {
            return (page << 7) + (startIndex + blockMeta);
        }
        throw new RuntimeException("Index out of range: [" + page + "][" + startIndex + "+" + blockMeta + "=" + (startIndex + blockMeta) + "]");
    }

    @Deprecated
    public static int getTextureId(ItemStack stack) {
        return GT_Utility.getTextureId(Block.getBlockFromItem((Item)stack.getItem()), (byte)stack.getItemDamage());
    }

    public static int getTextureId(Block blockFromBlock, byte metaFromBlock) {
        for (int page = 0; page < Textures.BlockIcons.casingTexturePages.length; ++page) {
            ITexture[] casingTexturePage = Textures.BlockIcons.casingTexturePages[page];
            if (casingTexturePage == null) continue;
            for (int index = 0; index < casingTexturePage.length; ++index) {
                ITexture iTexture = casingTexturePage[index];
                if (!(iTexture instanceof GT_CopiedBlockTexture)) continue;
                Block block = ((GT_CopiedBlockTexture)iTexture).getBlock();
                byte meta = ((GT_CopiedBlockTexture)iTexture).getMeta();
                if (meta != metaFromBlock || blockFromBlock != block) continue;
                return (page << 7) + index;
            }
        }
        throw new RuntimeException("Probably missing mapping or different texture class used for: " + blockFromBlock.getUnlocalizedName() + " meta:" + metaFromBlock);
    }

    public static String parseNumberToString(int aNumber) {
        boolean temp = true;
        boolean negative = false;
        if (aNumber < 0) {
            aNumber *= -1;
            negative = true;
        }
        StringBuilder tStringB = new StringBuilder();
        for (int i = 1000000000; i > 0; i /= 10) {
            int tDigit = aNumber / i % 10;
            if (temp && tDigit != 0) {
                temp = false;
            }
            if (temp) continue;
            tStringB.append(tDigit);
            if (i == 1) continue;
            for (int j = i; j > 0; j /= 1000) {
                if (j != 1) continue;
                tStringB.append(",");
            }
        }
        String tString = tStringB.toString();
        if (tString.equals("")) {
            tString = "0";
        }
        return negative ? "-" + tString : tString;
    }

    public static NBTTagCompound getNBTContainingBoolean(NBTTagCompound aNBT, Object aTag, boolean aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.setBoolean(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingByte(NBTTagCompound aNBT, Object aTag, byte aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.setByte(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingShort(NBTTagCompound aNBT, Object aTag, short aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.setShort(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingInteger(NBTTagCompound aNBT, Object aTag, int aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.setInteger(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingFloat(NBTTagCompound aNBT, Object aTag, float aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.setFloat(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingDouble(NBTTagCompound aNBT, Object aTag, double aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.setDouble(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingString(NBTTagCompound aNBT, Object aTag, Object aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        if (aValue == null) {
            return aNBT;
        }
        aNBT.setString(aTag.toString(), aValue.toString());
        return aNBT;
    }

    public static boolean isWearingFullFrostHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            if (GT_Utility.isStackInList(aEntity.getEquipmentInSlot(i), GregTech_API.sFrostHazmatList)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullHeatHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            if (GT_Utility.isStackInList(aEntity.getEquipmentInSlot(i), GregTech_API.sHeatHazmatList)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullBioHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            if (GT_Utility.isStackInList(aEntity.getEquipmentInSlot(i), GregTech_API.sBioHazmatList)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullRadioHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            if (GT_Utility.isStackInList(aEntity.getEquipmentInSlot(i), GregTech_API.sRadioHazmatList)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullElectroHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            if (GT_Utility.isStackInList(aEntity.getEquipmentInSlot(i), GregTech_API.sElectroHazmatList)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullGasHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            if (GT_Utility.isStackInList(aEntity.getEquipmentInSlot(i), GregTech_API.sGasHazmatList)) continue;
            return false;
        }
        return true;
    }

    public static float getHeatDamageFromItem(ItemStack aStack) {
        ItemData tData = GT_OreDictUnificator.getItemData(aStack);
        return tData == null ? 0.0f : (tData.mPrefix == null ? 0.0f : tData.mPrefix.mHeatDamage) + (tData.hasValidMaterialData() ? tData.mMaterial.mMaterial.mHeatDamage : 0.0f);
    }

    public static int getRadioactivityLevel(ItemStack aStack) {
        ItemData tData = GT_OreDictUnificator.getItemData(aStack);
        if (tData != null && tData.hasValidMaterialData()) {
            if (tData.mMaterial.mMaterial.mEnchantmentArmors instanceof Enchantment_Radioactivity) {
                return tData.mMaterial.mMaterial.mEnchantmentArmorsLevel;
            }
            if (tData.mMaterial.mMaterial.mEnchantmentTools instanceof Enchantment_Radioactivity) {
                return tData.mMaterial.mMaterial.mEnchantmentToolsLevel;
            }
        }
        return EnchantmentHelper.getEnchantmentLevel((int)Enchantment_Radioactivity.INSTANCE.effectId, (ItemStack)aStack);
    }

    public static boolean isImmuneToBreathingGasses(EntityLivingBase aEntity) {
        return GT_Utility.isWearingFullGasHazmat(aEntity);
    }

    public static boolean applyHeatDamage(EntityLivingBase aEntity, float aDamage) {
        if (aDamage > 0.0f && aEntity != null && aEntity.getActivePotionEffect(Potion.fireResistance) == null && !GT_Utility.isWearingFullHeatHazmat(aEntity)) {
            aEntity.attackEntityFrom(GT_DamageSources.getHeatDamage(), aDamage);
            return true;
        }
        return false;
    }

    public static boolean applyFrostDamage(EntityLivingBase aEntity, float aDamage) {
        if (aDamage > 0.0f && aEntity != null && !GT_Utility.isWearingFullFrostHazmat(aEntity)) {
            aEntity.attackEntityFrom(GT_DamageSources.getFrostDamage(), aDamage);
            return true;
        }
        return false;
    }

    public static boolean applyElectricityDamage(EntityLivingBase aEntity, long aVoltage, long aAmperage) {
        long aDamage = (long)GT_Utility.getTier(aVoltage) * aAmperage * 4L;
        if (aDamage > 0L && aEntity != null && !GT_Utility.isWearingFullElectroHazmat(aEntity)) {
            aEntity.attackEntityFrom(GT_DamageSources.getElectricDamage(), (float)aDamage);
            return true;
        }
        return false;
    }

    public static boolean applyRadioactivity(EntityLivingBase aEntity, int aLevel, int aAmountOfItems) {
        if (aLevel > 0 && aEntity != null && aEntity.getCreatureAttribute() != EnumCreatureAttribute.UNDEAD && aEntity.getCreatureAttribute() != EnumCreatureAttribute.ARTHROPOD && !GT_Utility.isWearingFullRadioHazmat(aEntity)) {
            PotionEffect tEffect = null;
            tEffect = aEntity.getActivePotionEffect(Potion.moveSlowdown);
            aEntity.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, aLevel * 140 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.getActivePotionEffect(Potion.digSlowdown);
            aEntity.addPotionEffect(new PotionEffect(Potion.digSlowdown.id, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.getActivePotionEffect(Potion.confusion);
            aEntity.addPotionEffect(new PotionEffect(Potion.confusion.id, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.getActivePotionEffect(Potion.weakness);
            aEntity.addPotionEffect(new PotionEffect(Potion.weakness.id, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.getActivePotionEffect(Potion.hunger);
            aEntity.addPotionEffect(new PotionEffect(Potion.hunger.id, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.getActivePotionEffect(Potion.potionTypes[24]);
            aEntity.addPotionEffect(new PotionEffect(24, aLevel * 180 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.getDuration()), Math.max(0, 5 * aLevel / 7)));
            return true;
        }
        return false;
    }

    public static ItemStack setStack(Object aSetStack, Object aToStack) {
        if (GT_Utility.isStackInvalid(aSetStack) || GT_Utility.isStackInvalid(aToStack)) {
            return null;
        }
        ((ItemStack)aSetStack).func_150996_a(((ItemStack)aToStack).getItem());
        ((ItemStack)aSetStack).stackSize = ((ItemStack)aToStack).stackSize;
        Items.feather.setDamage((ItemStack)aSetStack, Items.feather.getDamage((ItemStack)aToStack));
        ((ItemStack)aSetStack).setTagCompound(((ItemStack)aToStack).getTagCompound());
        return (ItemStack)aSetStack;
    }

    public static FluidStack[] copyFluidArray(FluidStack ... aStacks) {
        FluidStack[] rStacks = new FluidStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            if (aStacks[i] == null) continue;
            rStacks[i] = aStacks[i].copy();
        }
        return rStacks;
    }

    public static ItemStack[] copyStackArray(Object ... aStacks) {
        ItemStack[] rStacks = new ItemStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            rStacks[i] = GT_Utility.copy(aStacks[i]);
        }
        return rStacks;
    }

    public static ItemStack copy(Object ... aStacks) {
        for (Object tStack : aStacks) {
            if (!GT_Utility.isStackValid(tStack)) continue;
            return ((ItemStack)tStack).copy();
        }
        return null;
    }

    public static ItemStack copyAmount(long aAmount, Object ... aStacks) {
        ItemStack rStack = GT_Utility.copy(aStacks);
        if (GT_Utility.isStackInvalid(rStack)) {
            return null;
        }
        if (aAmount > 64L) {
            aAmount = 64L;
        } else if (aAmount == -1L) {
            aAmount = 111L;
        } else if (aAmount < 0L) {
            aAmount = 0L;
        }
        rStack.stackSize = (byte)aAmount;
        return rStack;
    }

    public static ItemStack copyMetaData(long aMetaData, Object ... aStacks) {
        ItemStack rStack = GT_Utility.copy(aStacks);
        if (GT_Utility.isStackInvalid(rStack)) {
            return null;
        }
        Items.feather.setDamage(rStack, (int)((short)aMetaData));
        return rStack;
    }

    public static ItemStack copyAmountAndMetaData(long aAmount, long aMetaData, Object ... aStacks) {
        ItemStack rStack = GT_Utility.copyAmount(aAmount, aStacks);
        if (GT_Utility.isStackInvalid(rStack)) {
            return null;
        }
        Items.feather.setDamage(rStack, (int)((short)aMetaData));
        return rStack;
    }

    public static ItemStack mul(long aMultiplier, Object ... aStacks) {
        ItemStack rStack = GT_Utility.copy(aStacks);
        if (rStack == null) {
            return null;
        }
        rStack.stackSize = (int)((long)rStack.stackSize * aMultiplier);
        return rStack;
    }

    public static ItemStack loadItem(NBTTagCompound aNBT, String aTagName) {
        return GT_Utility.loadItem(aNBT.getCompoundTag(aTagName));
    }

    public static FluidStack loadFluid(NBTTagCompound aNBT, String aTagName) {
        return GT_Utility.loadFluid(aNBT.getCompoundTag(aTagName));
    }

    public static ItemStack loadItem(NBTTagCompound aNBT) {
        if (aNBT == null) {
            return null;
        }
        ItemStack rStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)aNBT);
        try {
            if (rStack != null && rStack.getItem().getClass().getName().startsWith("ic2.core.migration")) {
                rStack.getItem().onUpdate(rStack, GT_Values.DW, null, 0, false);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        return GT_OreDictUnificator.get(true, rStack);
    }

    public static FluidStack loadFluid(NBTTagCompound aNBT) {
        if (aNBT == null) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT);
    }

    public static <E> E selectItemInList(int aIndex, E aReplacement, List<E> aList) {
        if (aList == null || aList.isEmpty()) {
            return aReplacement;
        }
        if (aList.size() <= aIndex) {
            return aList.get(aList.size() - 1);
        }
        if (aIndex < 0) {
            return aList.get(0);
        }
        return aList.get(aIndex);
    }

    public static <E> E selectItemInList(int aIndex, E aReplacement, E ... aList) {
        if (aList == null || aList.length == 0) {
            return aReplacement;
        }
        if (aList.length <= aIndex) {
            return aList[aList.length - 1];
        }
        if (aIndex < 0) {
            return aList[0];
        }
        return aList[aIndex];
    }

    public static boolean isStackInList(ItemStack aStack, Collection<GT_ItemStack> aList) {
        if (aStack == null) {
            return false;
        }
        return GT_Utility.isStackInList(new GT_ItemStack(aStack), aList);
    }

    public static boolean isStackInList(GT_ItemStack aStack, Collection<GT_ItemStack> aList) {
        return aStack != null && (aList.contains(aStack) || aList.contains(new GT_ItemStack(aStack.mItem, aStack.mStackSize, 32767L)));
    }

    public static <X, Y> Map<X, Y> reMap(Map<X, Y> aMap) {
        HashMap<X, Y> tMap = new HashMap<X, Y>();
        tMap.putAll(aMap);
        aMap.clear();
        aMap.putAll(tMap);
        return aMap;
    }

    public static <X, Y extends Comparable> LinkedHashMap<X, Y> sortMapByValuesAcending(Map<X, Y> aMap) {
        LinkedList<Map.Entry<X, Y>> tEntrySet = new LinkedList<Map.Entry<X, Y>>(aMap.entrySet());
        Collections.sort(tEntrySet, new Comparator<Map.Entry<X, Y>>(){

            @Override
            public int compare(Map.Entry<X, Y> aValue1, Map.Entry<X, Y> aValue2) {
                return ((Comparable)aValue1.getValue()).compareTo(aValue2.getValue());
            }
        });
        LinkedHashMap rMap = new LinkedHashMap();
        for (Map.Entry entry : tEntrySet) {
            rMap.put(entry.getKey(), entry.getValue());
        }
        return rMap;
    }

    public static <X, Y extends Comparable> LinkedHashMap<X, Y> sortMapByValuesDescending(Map<X, Y> aMap) {
        LinkedList<Map.Entry<X, Y>> tEntrySet = new LinkedList<Map.Entry<X, Y>>(aMap.entrySet());
        Collections.sort(tEntrySet, new Comparator<Map.Entry<X, Y>>(){

            @Override
            public int compare(Map.Entry<X, Y> aValue1, Map.Entry<X, Y> aValue2) {
                return ((Comparable)aValue2.getValue()).compareTo(aValue1.getValue());
            }
        });
        LinkedHashMap rMap = new LinkedHashMap();
        for (Map.Entry entry : tEntrySet) {
            rMap.put(entry.getKey(), entry.getValue());
        }
        return rMap;
    }

    public static long translateMaterialToFluidAmount(long aMaterialAmount, boolean aRoundUp) {
        return GT_Utility.translateMaterialToAmount(aMaterialAmount, 144L, aRoundUp);
    }

    public static long translateMaterialToAmount(long aMaterialAmount, long aAmountPerUnit, boolean aRoundUp) {
        return Math.max(0L, aMaterialAmount * aAmountPerUnit / 3628800L + (long)(aRoundUp && aMaterialAmount * aAmountPerUnit % 3628800L > 0L ? 1 : 0));
    }

    public static boolean isRealDimension(int aDimensionID) {
        if (aDimensionID <= 1 && aDimensionID >= -1 && !GregTech_API.sDimensionalList.contains(aDimensionID)) {
            return true;
        }
        return !GregTech_API.sDimensionalList.contains(aDimensionID) && DimensionManager.isDimensionRegistered((int)aDimensionID);
    }

    public static boolean moveEntityToDimensionAtCoords(Entity entity, int aDimension, double aX, double aY, double aZ) {
        EntityPlayerMP player;
        boolean interDimensional;
        if (entity == null || entity.worldObj.isRemote) {
            return false;
        }
        if (entity.ridingEntity != null) {
            entity.mountEntity(null);
        }
        if (entity.riddenByEntity != null) {
            entity.riddenByEntity.mountEntity(null);
        }
        World startWorld = entity.worldObj;
        WorldServer destinationWorld = FMLCommonHandler.instance().getMinecraftServerInstance().worldServerForDimension(aDimension);
        if (destinationWorld == null) {
            return false;
        }
        boolean bl = interDimensional = startWorld.provider.dimensionId != destinationWorld.provider.dimensionId;
        if (!interDimensional) {
            return false;
        }
        startWorld.updateEntityWithOptionalForce(entity, false);
        if (entity instanceof EntityPlayerMP && interDimensional) {
            player = (EntityPlayerMP)entity;
            player.closeScreen();
            player.dimension = aDimension;
            player.playerNetServerHandler.sendPacket((Packet)new S07PacketRespawn(player.dimension, player.worldObj.difficultySetting, destinationWorld.getWorldInfo().getTerrainType(), player.theItemInWorldManager.getGameType()));
            ((WorldServer)startWorld).getPlayerManager().removePlayer(player);
            startWorld.playerEntities.remove(player);
            startWorld.updateAllPlayersSleepingFlag();
            int i = entity.chunkCoordX;
            int j = entity.chunkCoordZ;
            if (entity.addedToChunk && startWorld.getChunkProvider().chunkExists(i, j)) {
                startWorld.getChunkFromChunkCoords(i, j).removeEntity(entity);
                startWorld.getChunkFromChunkCoords((int)i, (int)j).isModified = true;
            }
            startWorld.loadedEntityList.remove(entity);
            startWorld.onEntityRemoved(entity);
        }
        entity.setLocationAndAngles(aX, aY, aZ, entity.rotationYaw, entity.rotationPitch);
        destinationWorld.theChunkProviderServer.loadChunk((int)aX >> 4, (int)aZ >> 4);
        destinationWorld.theProfiler.startSection("placing");
        if (interDimensional) {
            if (!(entity instanceof EntityPlayer)) {
                NBTTagCompound entityNBT = new NBTTagCompound();
                entity.isDead = false;
                entityNBT.setString("id", EntityList.getEntityString((Entity)entity));
                entity.writeToNBT(entityNBT);
                entity.isDead = true;
                entity = EntityList.createEntityFromNBT((NBTTagCompound)entityNBT, (World)destinationWorld);
                if (entity == null) {
                    return false;
                }
                entity.dimension = destinationWorld.provider.dimensionId;
            }
            destinationWorld.spawnEntityInWorld(entity);
            entity.setWorld((World)destinationWorld);
        }
        entity.setLocationAndAngles(aX, aY, aZ, entity.rotationYaw, entity.rotationPitch);
        destinationWorld.updateEntityWithOptionalForce(entity, false);
        entity.setLocationAndAngles(aX, aY, aZ, entity.rotationYaw, entity.rotationPitch);
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            if (interDimensional) {
                player.mcServer.getConfigurationManager().func_72375_a(player, destinationWorld);
            }
            player.playerNetServerHandler.setPlayerLocation(aX, aY, aZ, player.rotationYaw, player.rotationPitch);
        }
        destinationWorld.updateEntityWithOptionalForce(entity, false);
        if (entity instanceof EntityPlayerMP && interDimensional) {
            player = (EntityPlayerMP)entity;
            player.theItemInWorldManager.setWorld(destinationWorld);
            player.mcServer.getConfigurationManager().updateTimeAndWeatherForPlayer(player, destinationWorld);
            player.mcServer.getConfigurationManager().syncPlayerInventory(player);
            for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                player.playerNetServerHandler.sendPacket((Packet)new S1DPacketEntityEffect(player.getEntityId(), potionEffect));
            }
            player.playerNetServerHandler.sendPacket((Packet)new S1FPacketSetExperience(player.experience, player.experienceTotal, player.experienceLevel));
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, startWorld.provider.dimensionId, destinationWorld.provider.dimensionId);
        }
        entity.setLocationAndAngles(aX, aY, aZ, entity.rotationYaw, entity.rotationPitch);
        destinationWorld.theProfiler.endSection();
        entity.fallDistance = 0.0f;
        return true;
    }

    public static int getScaleCoordinates(double aValue, int aScale) {
        return (int)Math.floor(aValue / (double)aScale);
    }

    public static int getCoordinateScan(ArrayList<String> aList, EntityPlayer aPlayer, World aWorld, int aScanLevel, int aX, int aY, int aZ, int aSide, float aClickX, float aClickY, float aClickZ) {
        Block tBlock;
        TileEntity tTileEntity;
        int rEUAmount;
        ArrayList<String> tList;
        block92: {
            int[] chunkData;
            block91: {
                block75: {
                    if (aList == null) {
                        return 0;
                    }
                    tList = new ArrayList<String>();
                    rEUAmount = 0;
                    tTileEntity = aWorld.getTileEntity(aX, aY, aZ);
                    tBlock = aWorld.getBlock(aX, aY, aZ);
                    tList.add("----- X: " + EnumChatFormatting.AQUA + aX + EnumChatFormatting.RESET + " Y: " + EnumChatFormatting.AQUA + aY + EnumChatFormatting.RESET + " Z: " + EnumChatFormatting.AQUA + aZ + EnumChatFormatting.RESET + " D: " + EnumChatFormatting.AQUA + aWorld.provider.dimensionId + EnumChatFormatting.RESET + " -----");
                    try {
                        if (tTileEntity != null && tTileEntity instanceof IInventory) {
                            tList.add(GT_Utility.trans("162", "Name: ") + EnumChatFormatting.BLUE + ((IInventory)tTileEntity).getInventoryName() + EnumChatFormatting.RESET + GT_Utility.trans("163", " MetaData: ") + EnumChatFormatting.AQUA + aWorld.getBlockMetadata(aX, aY, aZ) + EnumChatFormatting.RESET);
                        } else {
                            tList.add(GT_Utility.trans("162", "Name: ") + EnumChatFormatting.BLUE + tBlock.getUnlocalizedName() + EnumChatFormatting.RESET + GT_Utility.trans("163", " MetaData: ") + EnumChatFormatting.AQUA + aWorld.getBlockMetadata(aX, aY, aZ) + EnumChatFormatting.RESET);
                        }
                        tList.add(GT_Utility.trans("164", "Hardness: ") + EnumChatFormatting.YELLOW + tBlock.getBlockHardness(aWorld, aX, aY, aZ) + EnumChatFormatting.RESET + GT_Utility.trans("165", " Blast Resistance: ") + EnumChatFormatting.YELLOW + tBlock.getExplosionResistance((Entity)aPlayer, aWorld, aX, aY, aZ, aPlayer.posX, aPlayer.posY, aPlayer.posZ) + EnumChatFormatting.RESET);
                        if (tBlock.isBeaconBase((IBlockAccess)aWorld, aX, aY, aZ, aX, aY + 1, aZ)) {
                            tList.add(EnumChatFormatting.GOLD + GT_Utility.trans("166", "Is valid Beacon Pyramid Material") + EnumChatFormatting.RESET);
                        }
                    }
                    catch (Throwable e) {
                        if (!GT_Values.D1) break block75;
                        e.printStackTrace(GT_Log.err);
                    }
                }
                if (tTileEntity != null) {
                    block90: {
                        block89: {
                            block88: {
                                block87: {
                                    block86: {
                                        block85: {
                                            block84: {
                                                block83: {
                                                    block82: {
                                                        block81: {
                                                            block80: {
                                                                block79: {
                                                                    block78: {
                                                                        block77: {
                                                                            block76: {
                                                                                try {
                                                                                    if (tTileEntity instanceof IFluidHandler) {
                                                                                        rEUAmount += 500;
                                                                                        FluidTankInfo[] tTanks = ((IFluidHandler)tTileEntity).getTankInfo(ForgeDirection.getOrientation((int)aSide));
                                                                                        if (tTanks != null) {
                                                                                            for (int i = 0; i < tTanks.length; i = (int)((byte)(i + 1))) {
                                                                                                tList.add(GT_Utility.trans("167", "Tank ") + i + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(tTanks[i].fluid == null ? 0 : tTanks[i].fluid.amount) + EnumChatFormatting.RESET + " L / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(tTanks[i].capacity) + EnumChatFormatting.RESET + " L " + EnumChatFormatting.GOLD + GT_Utility.getFluidName(tTanks[i].fluid, true) + EnumChatFormatting.RESET);
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                                catch (Throwable e) {
                                                                                    if (!GT_Values.D1) break block76;
                                                                                    e.printStackTrace(GT_Log.err);
                                                                                }
                                                                            }
                                                                            try {
                                                                                if (tTileEntity instanceof IReactorChamber) {
                                                                                    rEUAmount += 500;
                                                                                    tTileEntity = (TileEntity)((IReactorChamber)tTileEntity).getReactor();
                                                                                }
                                                                            }
                                                                            catch (Throwable e) {
                                                                                if (!GT_Values.D1) break block77;
                                                                                e.printStackTrace(GT_Log.err);
                                                                            }
                                                                        }
                                                                        try {
                                                                            if (tTileEntity instanceof IReactor) {
                                                                                rEUAmount += 500;
                                                                                tList.add(GT_Utility.trans("168", "Heat: ") + EnumChatFormatting.GREEN + ((IReactor)tTileEntity).getHeat() + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + ((IReactor)tTileEntity).getMaxHeat() + EnumChatFormatting.RESET);
                                                                                tList.add(GT_Utility.trans("169", "HEM: ") + EnumChatFormatting.YELLOW + ((IReactor)tTileEntity).getHeatEffectModifier() + EnumChatFormatting.RESET);
                                                                            }
                                                                        }
                                                                        catch (Throwable e) {
                                                                            if (!GT_Values.D1) break block78;
                                                                            e.printStackTrace(GT_Log.err);
                                                                        }
                                                                    }
                                                                    try {
                                                                        if (tTileEntity instanceof IWrenchable) {
                                                                            rEUAmount += 100;
                                                                            tList.add(GT_Utility.trans("171", "Facing: ") + EnumChatFormatting.GREEN + ((IWrenchable)tTileEntity).getFacing() + EnumChatFormatting.RESET + GT_Utility.trans("172", " / Chance: ") + EnumChatFormatting.YELLOW + ((IWrenchable)tTileEntity).getWrenchDropRate() * 100.0f + EnumChatFormatting.RESET + "%");
                                                                            tList.add(((IWrenchable)tTileEntity).wrenchCanRemove(aPlayer) ? EnumChatFormatting.GREEN + GT_Utility.trans("173", "You can remove this with a Wrench") + EnumChatFormatting.RESET : EnumChatFormatting.RED + GT_Utility.trans("174", "You can NOT remove this with a Wrench") + EnumChatFormatting.RESET);
                                                                        }
                                                                    }
                                                                    catch (Throwable e) {
                                                                        if (!GT_Values.D1) break block79;
                                                                        e.printStackTrace(GT_Log.err);
                                                                    }
                                                                }
                                                                try {
                                                                    if (tTileEntity instanceof IEnergyTile) {
                                                                        rEUAmount += 200;
                                                                    }
                                                                }
                                                                catch (Throwable e) {
                                                                    if (!GT_Values.D1) break block80;
                                                                    e.printStackTrace(GT_Log.err);
                                                                }
                                                            }
                                                            try {
                                                                if (tTileEntity instanceof IEnergySink) {
                                                                    rEUAmount += 400;
                                                                }
                                                            }
                                                            catch (Throwable e) {
                                                                if (!GT_Values.D1) break block81;
                                                                e.printStackTrace(GT_Log.err);
                                                            }
                                                        }
                                                        try {
                                                            if (tTileEntity instanceof IEnergySource) {
                                                                rEUAmount += 400;
                                                            }
                                                        }
                                                        catch (Throwable e) {
                                                            if (!GT_Values.D1) break block82;
                                                            e.printStackTrace(GT_Log.err);
                                                        }
                                                    }
                                                    try {
                                                        if (tTileEntity instanceof IEnergyConductor) {
                                                            rEUAmount += 200;
                                                            tList.add(GT_Utility.trans("175", "Conduction Loss: ") + EnumChatFormatting.YELLOW + ((IEnergyConductor)tTileEntity).getConductionLoss() + EnumChatFormatting.RESET);
                                                        }
                                                    }
                                                    catch (Throwable e) {
                                                        if (!GT_Values.D1) break block83;
                                                        e.printStackTrace(GT_Log.err);
                                                    }
                                                }
                                                try {
                                                    if (tTileEntity instanceof IEnergyStorage) {
                                                        rEUAmount += 200;
                                                        tList.add(GT_Utility.trans("176", "Contained Energy: ") + EnumChatFormatting.YELLOW + ((IEnergyStorage)tTileEntity).getStored() + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + ((IEnergyStorage)tTileEntity).getCapacity() + EnumChatFormatting.RESET + " EU");
                                                    }
                                                }
                                                catch (Throwable e) {
                                                    if (!GT_Values.D1) break block84;
                                                    e.printStackTrace(GT_Log.err);
                                                }
                                            }
                                            try {
                                                if (tTileEntity instanceof IUpgradableMachine) {
                                                    rEUAmount += 500;
                                                    if (((IUpgradableMachine)tTileEntity).hasMufflerUpgrade()) {
                                                        tList.add(EnumChatFormatting.GREEN + GT_Utility.trans("177", "Has Muffler Upgrade") + EnumChatFormatting.RESET);
                                                    }
                                                }
                                            }
                                            catch (Throwable e) {
                                                if (!GT_Values.D1) break block85;
                                                e.printStackTrace(GT_Log.err);
                                            }
                                        }
                                        try {
                                            if (tTileEntity instanceof IMachineProgress) {
                                                rEUAmount += 400;
                                                int tValue = 0;
                                                tValue = ((IMachineProgress)tTileEntity).getMaxProgress();
                                                if (0 < tValue) {
                                                    tList.add(GT_Utility.trans("178", "Progress/Load: ") + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(((IMachineProgress)tTileEntity).getProgress()) + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(tValue) + EnumChatFormatting.RESET);
                                                }
                                            }
                                        }
                                        catch (Throwable e) {
                                            if (!GT_Values.D1) break block86;
                                            e.printStackTrace(GT_Log.err);
                                        }
                                    }
                                    try {
                                        if (tTileEntity instanceof ICoverable) {
                                            rEUAmount += 300;
                                            String tString = ((ICoverable)tTileEntity).getCoverBehaviorAtSide((byte)aSide).getDescription((byte)aSide, ((ICoverable)tTileEntity).getCoverIDAtSide((byte)aSide), ((ICoverable)tTileEntity).getCoverDataAtSide((byte)aSide), (ICoverable)tTileEntity);
                                            if (tString != null && !tString.equals("")) {
                                                tList.add(tString);
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        if (!GT_Values.D1) break block87;
                                        e.printStackTrace(GT_Log.err);
                                    }
                                }
                                try {
                                    if (tTileEntity instanceof IBasicEnergyContainer && ((IBasicEnergyContainer)tTileEntity).getEUCapacity() > 0L) {
                                        tList.add(GT_Utility.trans("179", "Max IN: ") + EnumChatFormatting.RED + ((IBasicEnergyContainer)tTileEntity).getInputVoltage() + " (" + GT_Values.VN[GT_Utility.getTier(((IBasicEnergyContainer)tTileEntity).getInputVoltage())] + ") " + EnumChatFormatting.RESET + GT_Utility.trans("182", " EU at ") + EnumChatFormatting.RED + ((IBasicEnergyContainer)tTileEntity).getInputAmperage() + EnumChatFormatting.RESET + GT_Utility.trans("183", " A"));
                                        tList.add(GT_Utility.trans("181", "Max OUT: ") + EnumChatFormatting.RED + ((IBasicEnergyContainer)tTileEntity).getOutputVoltage() + " (" + GT_Values.VN[GT_Utility.getTier(((IBasicEnergyContainer)tTileEntity).getOutputVoltage())] + ") " + EnumChatFormatting.RESET + GT_Utility.trans("182", " EU at ") + EnumChatFormatting.RED + ((IBasicEnergyContainer)tTileEntity).getOutputAmperage() + EnumChatFormatting.RESET + GT_Utility.trans("183", " A"));
                                        tList.add(GT_Utility.trans("184", "Energy: ") + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(((IBasicEnergyContainer)tTileEntity).getStoredEU()) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(((IBasicEnergyContainer)tTileEntity).getEUCapacity()) + EnumChatFormatting.RESET + " EU");
                                    }
                                }
                                catch (Throwable e) {
                                    if (!GT_Values.D1) break block88;
                                    e.printStackTrace(GT_Log.err);
                                }
                            }
                            try {
                                if (tTileEntity instanceof IGregTechTileEntity) {
                                    tList.add(GT_Utility.trans("186", "Owned by: ") + EnumChatFormatting.BLUE + ((IGregTechTileEntity)tTileEntity).getOwnerName() + EnumChatFormatting.RESET);
                                }
                            }
                            catch (Throwable e) {
                                if (!GT_Values.D1) break block89;
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                        try {
                            if (tTileEntity instanceof IGregTechDeviceInformation && ((IGregTechDeviceInformation)tTileEntity).isGivingInformation()) {
                                tList.addAll(Arrays.asList(((IGregTechDeviceInformation)tTileEntity).getInfoData()));
                            }
                        }
                        catch (Throwable e) {
                            if (!GT_Values.D1) break block90;
                            e.printStackTrace(GT_Log.err);
                        }
                    }
                    try {
                        if (tTileEntity instanceof ICropTile) {
                            if (((ICropTile)tTileEntity).getScanLevel() < 4) {
                                rEUAmount += 10000;
                                ((ICropTile)tTileEntity).setScanLevel((byte)4);
                            }
                            if (((ICropTile)tTileEntity).getID() >= 0 && ((ICropTile)tTileEntity).getID() < Crops.instance.getCropList().length && Crops.instance.getCropList()[((ICropTile)tTileEntity).getID()] != null) {
                                rEUAmount += 1000;
                                tList.add(GT_Utility.trans("187", "Type -- Crop-Name: ") + Crops.instance.getCropList()[((ICropTile)tTileEntity).getID()].name() + GT_Utility.trans("188", "  Growth: ") + ((ICropTile)tTileEntity).getGrowth() + GT_Utility.trans("189", "  Gain: ") + ((ICropTile)tTileEntity).getGain() + GT_Utility.trans("190", "  Resistance: ") + ((ICropTile)tTileEntity).getResistance());
                                tList.add(GT_Utility.trans("191", "Plant -- Fertilizer: ") + ((ICropTile)tTileEntity).getNutrientStorage() + GT_Utility.trans("192", "  Water: ") + ((ICropTile)tTileEntity).getHydrationStorage() + GT_Utility.trans("193", "  Weed-Ex: ") + ((ICropTile)tTileEntity).getWeedExStorage() + GT_Utility.trans("194", "  Scan-Level: ") + ((ICropTile)tTileEntity).getScanLevel());
                                tList.add(GT_Utility.trans("195", "Environment -- Nutrients: ") + ((ICropTile)tTileEntity).getNutrients() + GT_Utility.trans("196", "  Humidity: ") + ((ICropTile)tTileEntity).getHumidity() + GT_Utility.trans("197", "  Air-Quality: ") + ((ICropTile)tTileEntity).getAirQuality());
                                StringBuilder tStringB = new StringBuilder();
                                for (String tAttribute : Crops.instance.getCropList()[((ICropTile)tTileEntity).getID()].attributes()) {
                                    tStringB.append(", ").append(tAttribute);
                                }
                                String tString = tStringB.toString();
                                tList.add(GT_Utility.trans("198", "Attributes:") + tString.replaceFirst(",", ""));
                                tList.add(GT_Utility.trans("199", "Discovered by: ") + Crops.instance.getCropList()[((ICropTile)tTileEntity).getID()].discoveredBy());
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (!GT_Values.D1) break block91;
                        e.printStackTrace(GT_Log.err);
                    }
                }
            }
            if (aPlayer.capabilities.isCreativeMode) {
                FluidStack tFluid = GT_UndergroundOil.undergroundOilReadInformation(aWorld.getChunkFromBlockCoords(aX, aZ));
                if (tFluid != null) {
                    tList.add(EnumChatFormatting.GOLD + tFluid.getLocalizedName() + EnumChatFormatting.RESET + ": " + EnumChatFormatting.YELLOW + tFluid.amount + EnumChatFormatting.RESET + " L");
                } else {
                    tList.add(EnumChatFormatting.GOLD + GT_Utility.trans("201", "Nothing") + EnumChatFormatting.RESET + ": " + EnumChatFormatting.YELLOW + '0' + EnumChatFormatting.RESET + " L");
                }
            }
            if ((chunkData = GT_Proxy.dimensionWiseChunkData.get(aWorld.provider.dimensionId).get(aWorld.getChunkFromBlockCoords(aX, aZ).getChunkCoordIntPair())) != null) {
                if (chunkData[1] > 0) {
                    tList.add(GT_Utility.trans("202", "Pollution in Chunk: ") + EnumChatFormatting.RED + chunkData[1] + EnumChatFormatting.RESET + GT_Utility.trans("203", " gibbl"));
                } else {
                    tList.add(EnumChatFormatting.GREEN + GT_Utility.trans("204", "No Pollution in Chunk! HAYO!") + EnumChatFormatting.RESET);
                }
            } else {
                tList.add(EnumChatFormatting.GREEN + GT_Utility.trans("204", "No Pollution in Chunk! HAYO!") + EnumChatFormatting.RESET);
            }
            try {
                if (tBlock instanceof IDebugableBlock) {
                    rEUAmount += 500;
                    ArrayList<String> temp = ((IDebugableBlock)tBlock).getDebugInfo(aPlayer, aX, aY, aZ, 3);
                    if (temp != null) {
                        tList.addAll(temp);
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block92;
                e.printStackTrace(GT_Log.err);
            }
        }
        BlockScanningEvent tEvent = new BlockScanningEvent(aWorld, aPlayer, aX, aY, aZ, (byte)aSide, aScanLevel, tBlock, tTileEntity, tList, aClickX, aClickY, aClickZ);
        tEvent.mEUCost = rEUAmount;
        MinecraftForge.EVENT_BUS.post((Event)tEvent);
        if (!tEvent.isCanceled()) {
            aList.addAll(tList);
        }
        return tEvent.mEUCost;
    }

    public static String trans(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_" + aKey, aEnglish, false);
    }

    public static float[] getClickedFacingCoords(byte aSide, float aX, float aY, float aZ) {
        switch (aSide) {
            case 0: {
                return new float[]{Math.min(0.99f, Math.max(0.0f, 1.0f - aX)), Math.min(0.99f, Math.max(0.0f, aZ))};
            }
            case 1: {
                return new float[]{Math.min(0.99f, Math.max(0.0f, aX)), Math.min(0.99f, Math.max(0.0f, aZ))};
            }
            case 2: {
                return new float[]{Math.min(0.99f, Math.max(0.0f, 1.0f - aX)), Math.min(0.99f, Math.max(0.0f, 1.0f - aY))};
            }
            case 3: {
                return new float[]{Math.min(0.99f, Math.max(0.0f, aX)), Math.min(0.99f, Math.max(0.0f, 1.0f - aY))};
            }
            case 4: {
                return new float[]{Math.min(0.99f, Math.max(0.0f, aZ)), Math.min(0.99f, Math.max(0.0f, 1.0f - aY))};
            }
            case 5: {
                return new float[]{Math.min(0.99f, Math.max(0.0f, 1.0f - aZ)), Math.min(0.99f, Math.max(0.0f, 1.0f - aY))};
            }
        }
        return new float[]{0.5f, 0.5f};
    }

    public static byte determineWrenchingSide(byte aSide, float aX, float aY, float aZ) {
        byte tBack = GT_Utility.getOppositeSide(aSide);
        switch (aSide) {
            case 0: 
            case 1: {
                if ((double)aX < 0.25) {
                    if ((double)aZ < 0.25) {
                        return tBack;
                    }
                    if ((double)aZ > 0.75) {
                        return tBack;
                    }
                    return 4;
                }
                if ((double)aX > 0.75) {
                    if ((double)aZ < 0.25) {
                        return tBack;
                    }
                    if ((double)aZ > 0.75) {
                        return tBack;
                    }
                    return 5;
                }
                if ((double)aZ < 0.25) {
                    return 2;
                }
                if ((double)aZ > 0.75) {
                    return 3;
                }
                return aSide;
            }
            case 2: 
            case 3: {
                if ((double)aX < 0.25) {
                    if ((double)aY < 0.25) {
                        return tBack;
                    }
                    if ((double)aY > 0.75) {
                        return tBack;
                    }
                    return 4;
                }
                if ((double)aX > 0.75) {
                    if ((double)aY < 0.25) {
                        return tBack;
                    }
                    if ((double)aY > 0.75) {
                        return tBack;
                    }
                    return 5;
                }
                if ((double)aY < 0.25) {
                    return 0;
                }
                if ((double)aY > 0.75) {
                    return 1;
                }
                return aSide;
            }
            case 4: 
            case 5: {
                if ((double)aZ < 0.25) {
                    if ((double)aY < 0.25) {
                        return tBack;
                    }
                    if ((double)aY > 0.75) {
                        return tBack;
                    }
                    return 2;
                }
                if ((double)aZ > 0.75) {
                    if ((double)aY < 0.25) {
                        return tBack;
                    }
                    if ((double)aY > 0.75) {
                        return tBack;
                    }
                    return 3;
                }
                if ((double)aY < 0.25) {
                    return 0;
                }
                if ((double)aY > 0.75) {
                    return 1;
                }
                return aSide;
            }
        }
        return -1;
    }

    public static String formatNumbers(long aNumber) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setGroupingSeparator(' ');
        return formatter.format(aNumber);
    }

    public static boolean consumeItems(EntityPlayer player, ItemStack stack, Item item, int count) {
        if (stack != null && stack.getItem() == item && stack.stackSize >= count) {
            if (!player.capabilities.isCreativeMode && stack.stackSize != 111) {
                stack.stackSize -= count;
            }
            return true;
        }
        return false;
    }

    public static boolean consumeItems(EntityPlayer player, ItemStack stack, Materials mat, int count) {
        if (stack != null && GT_OreDictUnificator.getItemData((ItemStack)stack).mMaterial.mMaterial == mat && stack.stackSize >= count) {
            if (!player.capabilities.isCreativeMode && stack.stackSize != 111) {
                stack.stackSize -= count;
            }
            return true;
        }
        return false;
    }

    public static ArrayList<String> sortByValueToList(Map<String, Integer> map) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o2.getValue() - o1.getValue();
            }
        });
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : list) {
            result.add((String)entry.getKey());
        }
        return result;
    }

    public static String joinListToString(List<String> list) {
        StringBuilder result = new StringBuilder(32);
        for (String s : list) {
            result.append(result.length() == 0 ? s : '|' + s);
        }
        return result.toString();
    }

    public static ItemStack getIntegratedCircuit(int config) {
        return ItemList.Circuit_Integrated.getWithDamage(0L, config, new Object[0]);
    }

    public static float getBlockHardnessAt(World aWorld, int aX, int aY, int aZ) {
        return aWorld.getBlock(aX, aY, aZ).getBlockHardness(aWorld, aX, aY, aZ);
    }

    public static FakePlayer getFakePlayer(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.getWorld() instanceof WorldServer) {
            return FakePlayerFactory.get((WorldServer)((WorldServer)aBaseMetaTileEntity.getWorld()), (GameProfile)new GameProfile(aBaseMetaTileEntity.getOwnerUuid(), aBaseMetaTileEntity.getOwnerName()));
        }
        return null;
    }

    public static boolean eraseBlockByFakePlayer(FakePlayer aPlayer, int aX, int aY, int aZ, boolean isSimulate) {
        if (aPlayer == null) {
            return false;
        }
        World aWorld = aPlayer.worldObj;
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(aX, aY, aZ, aWorld, aWorld.getBlock(aX, aY, aZ), aWorld.getBlockMetadata(aX, aY, aZ), (EntityPlayer)aPlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            if (!isSimulate) {
                return aWorld.setBlockToAir(aX, aY, aZ);
            }
            return true;
        }
        return false;
    }

    public static boolean setBlockByFakePlayer(FakePlayer aPlayer, int aX, int aY, int aZ, Block aBlock, int aMeta, boolean isSimulate) {
        if (aPlayer == null) {
            return false;
        }
        World aWorld = aPlayer.worldObj;
        BlockEvent.PlaceEvent event = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)aPlayer, (BlockSnapshot)new BlockSnapshot(aWorld, aX, aY, aZ, aBlock, aMeta), (ForgeDirection)ForgeDirection.UNKNOWN);
        if (!event.isCanceled()) {
            if (!isSimulate) {
                return aWorld.setBlock(aX, aY, aZ, aBlock, aMeta, 3);
            }
            return true;
        }
        return false;
    }

    public static String toSubscript(long no) {
        char[] chars = Long.toString(no).toCharArray();
        int i = 0;
        while (i < chars.length) {
            int n = i++;
            chars[n] = (char)(chars[n] + 8272);
        }
        return new String(chars);
    }

    public static boolean isPartOfMaterials(ItemStack aStack, Materials aMaterials) {
        return GT_OreDictUnificator.getAssociation(aStack) != null ? GT_OreDictUnificator.getAssociation((ItemStack)aStack).mMaterial.mMaterial.equals(aMaterials) : false;
    }

    public static boolean isPartOfOrePrefix(ItemStack aStack, OrePrefixes aPrefix) {
        return GT_OreDictUnificator.getAssociation(aStack) != null ? GT_OreDictUnificator.getAssociation((ItemStack)aStack).mPrefix.equals((Object)aPrefix) : false;
    }

    static {
        GregTech_API.sItemStackMappings.add(sFilledContainerToData);
        GregTech_API.sItemStackMappings.add(sEmptyContainerToFluidToData);
    }

    public static class GT_EnchantmentHelper {
        private static final BullshitIteratorA mBullshitIteratorA = new BullshitIteratorA();
        private static final BullshitIteratorB mBullshitIteratorB = new BullshitIteratorB();

        private static void applyBullshit(IBullshit aBullshitModifier, ItemStack aStack) {
            NBTTagList nbttaglist;
            if (aStack != null && (nbttaglist = aStack.getEnchantmentTagList()) != null) {
                try {
                    for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                        short short1 = nbttaglist.getCompoundTagAt(i).getShort("id");
                        short short2 = nbttaglist.getCompoundTagAt(i).getShort("lvl");
                        if (Enchantment.enchantmentsList[short1] == null) continue;
                        aBullshitModifier.calculateModifier(Enchantment.enchantmentsList[short1], short2);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private static void applyArrayOfBullshit(IBullshit aBullshitModifier, ItemStack[] aStacks) {
            ItemStack[] aitemstack1 = aStacks;
            int i = aStacks.length;
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = aitemstack1[j];
                GT_EnchantmentHelper.applyBullshit(aBullshitModifier, itemstack);
            }
        }

        public static void applyBullshitA(EntityLivingBase aPlayer, Entity aEntity, ItemStack aStack) {
            GT_EnchantmentHelper.mBullshitIteratorA.mPlayer = aPlayer;
            GT_EnchantmentHelper.mBullshitIteratorA.mEntity = aEntity;
            if (aPlayer != null) {
                GT_EnchantmentHelper.applyArrayOfBullshit(mBullshitIteratorA, aPlayer.getLastActiveItems());
            }
            if (aStack != null) {
                GT_EnchantmentHelper.applyBullshit(mBullshitIteratorA, aStack);
            }
        }

        public static void applyBullshitB(EntityLivingBase aPlayer, Entity aEntity, ItemStack aStack) {
            GT_EnchantmentHelper.mBullshitIteratorB.mPlayer = aPlayer;
            GT_EnchantmentHelper.mBullshitIteratorB.mEntity = aEntity;
            if (aPlayer != null) {
                GT_EnchantmentHelper.applyArrayOfBullshit(mBullshitIteratorB, aPlayer.getLastActiveItems());
            }
            if (aStack != null) {
                GT_EnchantmentHelper.applyBullshit(mBullshitIteratorB, aStack);
            }
        }

        static final class BullshitIteratorB
        implements IBullshit {
            public EntityLivingBase mPlayer;
            public Entity mEntity;

            BullshitIteratorB() {
            }

            @Override
            public void calculateModifier(Enchantment aEnchantment, int aLevel) {
                aEnchantment.func_151368_a(this.mPlayer, this.mEntity, aLevel);
            }
        }

        static final class BullshitIteratorA
        implements IBullshit {
            public EntityLivingBase mPlayer;
            public Entity mEntity;

            BullshitIteratorA() {
            }

            @Override
            public void calculateModifier(Enchantment aEnchantment, int aLevel) {
                aEnchantment.func_151367_b(this.mPlayer, this.mEntity, aLevel);
            }
        }

        static interface IBullshit {
            public void calculateModifier(Enchantment var1, int var2);
        }
    }

    public static class ItemNBT {
        public static void setNBT(ItemStack aStack, NBTTagCompound aNBT) {
            if (aNBT == null) {
                aStack.setTagCompound(null);
                return;
            }
            ArrayList<String> tTagsToRemove = new ArrayList<String>();
            for (Object e : aNBT.func_150296_c()) {
                NBTBase tValue = aNBT.getTag((String)e);
                if (tValue != null && (!(tValue instanceof NBTBase.NBTPrimitive) || ((NBTBase.NBTPrimitive)tValue).func_150291_c() != 0L) && (!(tValue instanceof NBTTagString) || !GT_Utility.isStringInvalid(((NBTTagString)tValue).func_150285_a_()))) continue;
                tTagsToRemove.add((String)e);
            }
            for (Object e : tTagsToRemove) {
                aNBT.removeTag((String)e);
            }
            aStack.setTagCompound(aNBT.hasNoTags() ? null : aNBT);
        }

        public static NBTTagCompound getNBT(ItemStack aStack) {
            NBTTagCompound rNBT = aStack.getTagCompound();
            return rNBT == null ? new NBTTagCompound() : rNBT;
        }

        public static void setPunchCardData(ItemStack aStack, String aPunchCardData) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.setString("GT.PunchCardData", aPunchCardData);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static String getPunchCardData(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            return tNBT.getString("GT.PunchCardData");
        }

        public static void setLighterFuel(ItemStack aStack, long aFuel) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.setLong("GT.LighterFuel", aFuel);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static long getLighterFuel(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            return tNBT.getLong("GT.LighterFuel");
        }

        public static void setMapID(ItemStack aStack, short aMapID) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.setShort("map_id", aMapID);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static short getMapID(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            if (!tNBT.hasKey("map_id")) {
                return -1;
            }
            return tNBT.getShort("map_id");
        }

        public static void setBookTitle(ItemStack aStack, String aTitle) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.setString("title", aTitle);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static String getBookTitle(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            return tNBT.getString("title");
        }

        public static void setBookAuthor(ItemStack aStack, String aAuthor) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.setString("author", aAuthor);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static String getBookAuthor(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            return tNBT.getString("author");
        }

        public static void setProspectionData(ItemStack aStack, int aX, int aY, int aZ, int aDim, FluidStack aFluid, String ... aOres) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            String tData = aX + "," + aY + "," + aZ + "," + aDim + ",";
            if (aFluid != null) {
                tData = tData + aFluid.amount + "," + aFluid.getLocalizedName() + ",";
            }
            for (String tString : aOres) {
                tData = tData + tString + ",";
            }
            tNBT.setString("prospection", tData);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static void setAdvancedProspectionData(byte aTier, ItemStack aStack, int aX, short aY, int aZ, int aDim, ArrayList<String> aOils, ArrayList<String> aOres, int aRadius) {
            ItemNBT.setBookTitle(aStack, "Raw Prospection Data");
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.setByte("prospection_tier", aTier);
            tNBT.setString("prospection_pos", "Dim: " + aDim + "\nX: " + aX + " Y: " + aY + " Z: " + aZ);
            Collections.sort(aOres);
            tNBT.setString("prospection_ores", GT_Utility.joinListToString(aOres));
            ArrayList<String> tOilsTransformed = new ArrayList<String>(aOils.size());
            for (String aStr : aOils) {
                String[] aStats = aStr.split(",");
                tOilsTransformed.add(aStats[0] + ": " + aStats[1] + "L " + aStats[2]);
            }
            tNBT.setString("prospection_oils", GT_Utility.joinListToString(tOilsTransformed));
            String tOilsPosStr = "X: " + Math.floorDiv(aX, 128) * 16 * 8 + " Z: " + Math.floorDiv(aZ, 128) * 16 * 8 + "\n";
            int xOff = aX - Math.floorDiv(aX, 128) * 16 * 8;
            int xOffRemain = 7 - (xOff /= 16);
            int zOff = aZ - Math.floorDiv(aZ, 128) * 16 * 8;
            int zOffRemain = 7 - (zOff /= 16);
            while (zOff > 0) {
                tOilsPosStr = tOilsPosStr.concat("--------\n");
                --zOff;
            }
            while (xOff > 0) {
                tOilsPosStr = tOilsPosStr.concat("-");
                --xOff;
            }
            tOilsPosStr = tOilsPosStr.concat("P");
            while (xOffRemain > 0) {
                tOilsPosStr = tOilsPosStr.concat("-");
                --xOffRemain;
            }
            tOilsPosStr = tOilsPosStr.concat("\n");
            while (zOffRemain > 0) {
                tOilsPosStr = tOilsPosStr.concat("--------\n");
                --zOffRemain;
            }
            tOilsPosStr = tOilsPosStr.concat("            X: " + (Math.floorDiv(aX, 128) + 1) * 16 * 8 + " Z: " + (Math.floorDiv(aZ, 128) + 1) * 16 * 8);
            tNBT.setString("prospection_oils_pos", tOilsPosStr);
            tNBT.setString("prospection_radius", String.valueOf(aRadius));
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static void convertProspectionData(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            byte tTier = tNBT.getByte("prospection_tier");
            if (tTier == 0) {
                String tData = tNBT.getString("prospection");
                String[] tDataArray = tData.split(",");
                if (tDataArray.length > 6) {
                    tNBT.setString("author", " Dim: " + tDataArray[3] + "X: " + tDataArray[0] + " Y: " + tDataArray[1] + " Z: " + tDataArray[2]);
                    NBTTagList tNBTList = new NBTTagList();
                    String tOres = " Prospected Ores: ";
                    for (int i = 6; tDataArray.length > i; ++i) {
                        tOres = tOres + tDataArray[i] + " ";
                    }
                    tNBTList.appendTag((NBTBase)new NBTTagString("Tier " + tTier + " Prospecting Data From: X" + tDataArray[0] + " Z:" + tDataArray[2] + " Dim:" + tDataArray[3] + " Produces " + tDataArray[4] + "L " + tDataArray[5] + " " + tOres));
                    tNBT.setTag("pages", (NBTBase)tNBTList);
                }
                ItemNBT.setNBT(aStack, tNBT);
            } else {
                String tPos = tNBT.getString("prospection_pos");
                String tRadius = tNBT.getString("prospection_radius");
                String tOresStr = tNBT.getString("prospection_ores");
                String tOilsStr = tNBT.getString("prospection_oils");
                String tOilsPosStr = tNBT.getString("prospection_oils_pos");
                String[] tOres = tOresStr.isEmpty() ? null : tOresStr.split("\\|");
                String[] tOils = tOilsStr.isEmpty() ? null : tOilsStr.split("\\|");
                NBTTagList tNBTList = new NBTTagList();
                String tPageText = "Prospector report\n" + tPos + "\n\nOils: " + (tOils != null ? tOils.length : 0) + "\n\nOres within " + tRadius + " blocks\n\nLocation is center of orevein\n\nCheck NEI to confirm orevein type";
                tNBTList.appendTag((NBTBase)new NBTTagString(tPageText));
                if (tOres != null) {
                    ItemNBT.fillBookWithList(tNBTList, "Ores Found %s\n\n", "\n", 7, tOres);
                }
                if (tOils != null) {
                    ItemNBT.fillBookWithList(tNBTList, "Oils%s\n\n", "\n", 9, tOils);
                }
                tPageText = "Oil notes\n\nProspects from NW to SE 576 chunks(9 8x8 oilfields)\n around and gives min-max amount\n\n[1][2][3]\n[4][5][6]\n[7][8][9]\n\n[5] - Prospector in this 8x8 area";
                tNBTList.appendTag((NBTBase)new NBTTagString(tPageText));
                tPageText = "Corners of [5] are \n" + tOilsPosStr + "\nP - Prospector in 8x8 field";
                tNBTList.appendTag((NBTBase)new NBTTagString(tPageText));
                tNBT.setString("author", tPos.replace("\n", " "));
                tNBT.setTag("pages", (NBTBase)tNBTList);
                ItemNBT.setNBT(aStack, tNBT);
            }
        }

        public static void fillBookWithList(NBTTagList aBook, String aPageHeader, String aListDelimiter, int aItemsPerPage, String[] list) {
            String tPageText;
            String aPageFormatter = " %d/%d";
            int tTotalPages = list.length / aItemsPerPage + (list.length % aItemsPerPage > 0 ? 1 : 0);
            int tPage = 0;
            do {
                tPageText = "";
                for (int i = tPage * aItemsPerPage; i < (tPage + 1) * aItemsPerPage && i < list.length; ++i) {
                    tPageText = tPageText + (tPageText.isEmpty() ? "" : aListDelimiter) + list[i];
                }
                if (!tPageText.isEmpty()) {
                    String tPageCounter = tTotalPages > 1 ? String.format(aPageFormatter, tPage + 1, tTotalPages) : "";
                    NBTTagString tPageTag = new NBTTagString(String.format(aPageHeader, tPageCounter) + tPageText);
                    aBook.appendTag((NBTBase)tPageTag);
                }
                ++tPage;
            } while (!tPageText.isEmpty());
        }

        public static void addEnchantment(ItemStack aStack, Enchantment aEnchantment, int aLevel) {
            NBTTagCompound tEnchantmentTag;
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            if (!tNBT.hasKey("ench", 9)) {
                tNBT.setTag("ench", (NBTBase)new NBTTagList());
            }
            NBTTagList tList = tNBT.getTagList("ench", 10);
            boolean temp = true;
            for (int i = 0; i < tList.tagCount(); ++i) {
                tEnchantmentTag = tList.getCompoundTagAt(i);
                if (tEnchantmentTag.getShort("id") != aEnchantment.effectId) continue;
                tEnchantmentTag.setShort("id", (short)aEnchantment.effectId);
                tEnchantmentTag.setShort("lvl", (short)((byte)aLevel));
                temp = false;
                break;
            }
            if (temp) {
                tEnchantmentTag = new NBTTagCompound();
                tEnchantmentTag.setShort("id", (short)aEnchantment.effectId);
                tEnchantmentTag.setShort("lvl", (short)((byte)aLevel));
                tList.appendTag((NBTBase)tEnchantmentTag);
            }
            aStack.setTagCompound(tNBT);
        }
    }
}

