/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;

public class GT_RenderedTexture
implements ITexture,
IColorModulationContainer {
    private final IIconContainer mIconContainer;
    private final boolean mAllowAlpha;
    public short[] mRGBa;

    public GT_RenderedTexture(IIconContainer aIcon, short[] aRGBa, boolean aAllowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GT_RenderedTexture");
        }
        this.mIconContainer = aIcon;
        this.mAllowAlpha = aAllowAlpha;
        this.mRGBa = aRGBa;
    }

    public GT_RenderedTexture(IIconContainer aIcon, short[] aRGBa) {
        this(aIcon, aRGBa, true);
    }

    public GT_RenderedTexture(IIconContainer aIcon) {
        this(aIcon, Dyes._NULL.mRGBa);
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator.instance.setColorRGBA((int)((float)this.mRGBa[0] * 0.6f), (int)((float)this.mRGBa[1] * 0.6f), (int)((float)this.mRGBa[2] * 0.6f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.renderFaceXPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.instance.setColorRGBA(153, 153, 153, 255);
            aRenderer.renderFaceXPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator.instance.setColorRGBA((int)((float)this.mRGBa[0] * 0.6f), (int)((float)this.mRGBa[1] * 0.6f), (int)((float)this.mRGBa[2] * 0.6f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.renderFaceXNeg(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.instance.setColorRGBA(153, 153, 153, 255);
            aRenderer.renderFaceXNeg(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator.instance.setColorRGBA((int)((float)this.mRGBa[0] * 1.0f), (int)((float)this.mRGBa[1] * 1.0f), (int)((float)this.mRGBa[2] * 1.0f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.renderFaceYPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.instance.setColorRGBA(255, 255, 255, 255);
            aRenderer.renderFaceYPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator.instance.setColorRGBA((int)((float)this.mRGBa[0] * 0.5f), (int)((float)this.mRGBa[1] * 0.5f), (int)((float)this.mRGBa[2] * 0.5f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        IIcon aIcon = this.mIconContainer.getIcon();
        float d_16 = 16.0f;
        float d3 = aIcon.getInterpolatedU(aRenderer.renderMaxX * (double)d_16);
        float d4 = aIcon.getInterpolatedU(aRenderer.renderMinX * (double)d_16);
        float d5 = aIcon.getInterpolatedV(aRenderer.renderMinZ * (double)d_16);
        float d6 = aIcon.getInterpolatedV(aRenderer.renderMaxZ * (double)d_16);
        if (aRenderer.renderMinX < 0.0 || aRenderer.renderMaxX > 1.0) {
            d3 = aIcon.getMaxU();
            d4 = aIcon.getMinU();
        }
        if (aRenderer.renderMinZ < 0.0 || aRenderer.renderMaxZ > 1.0) {
            d5 = aIcon.getMinV();
            d6 = aIcon.getMaxV();
        }
        float d11 = (float)aX + (float)aRenderer.renderMinX;
        float d12 = (float)aX + (float)aRenderer.renderMaxX;
        float d13 = (float)aY + (float)aRenderer.renderMinY;
        float d14 = (float)aZ + (float)aRenderer.renderMinZ;
        float d15 = (float)aZ + (float)aRenderer.renderMaxZ;
        Tessellator.instance.addVertexWithUV((double)d11, (double)d13, (double)d15, (double)d3, (double)d6);
        Tessellator.instance.addVertexWithUV((double)d11, (double)d13, (double)d14, (double)d3, (double)d5);
        Tessellator.instance.addVertexWithUV((double)d12, (double)d13, (double)d14, (double)d4, (double)d5);
        Tessellator.instance.addVertexWithUV((double)d12, (double)d13, (double)d15, (double)d4, (double)d6);
        aIcon = this.mIconContainer.getOverlayIcon();
        if (aIcon != null) {
            Tessellator.instance.setColorRGBA(128, 128, 128, 255);
            Tessellator.instance.addVertexWithUV((double)d11, (double)d13, (double)d15, (double)d3, (double)d6);
            Tessellator.instance.addVertexWithUV((double)d11, (double)d13, (double)d14, (double)d3, (double)d5);
            Tessellator.instance.addVertexWithUV((double)d12, (double)d13, (double)d14, (double)d4, (double)d5);
            Tessellator.instance.addVertexWithUV((double)d12, (double)d13, (double)d15, (double)d4, (double)d6);
        }
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator.instance.setColorRGBA((int)((float)this.mRGBa[0] * 0.8f), (int)((float)this.mRGBa[1] * 0.8f), (int)((float)this.mRGBa[2] * 0.8f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.renderFaceZPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.instance.setColorRGBA(204, 204, 204, 255);
            aRenderer.renderFaceZPos(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator.instance.setColorRGBA((int)((float)this.mRGBa[0] * 0.8f), (int)((float)this.mRGBa[1] * 0.8f), (int)((float)this.mRGBa[2] * 0.8f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.renderFaceZNeg(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.instance.setColorRGBA(204, 204, 204, 255);
            aRenderer.renderFaceZNeg(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public short[] getRGBA() {
        return this.mRGBa;
    }

    @Override
    public boolean isValidTexture() {
        return this.mIconContainer != null;
    }
}

