/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class GT_MetaTileEntity_Buffer
extends GT_MetaTileEntity_TieredMachineBlock {
    public boolean bOutput = false;
    public boolean bRedstoneIfFull = false;
    public boolean bInvert = false;
    public boolean bStockingMode = false;
    public int mSuccess = 0;
    public int mTargetStackSize = 0;

    public GT_MetaTileEntity_Buffer(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_Buffer(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String[] aDescription) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_Buffer(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Buffer(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[6][17][];
        ITexture tIcon = this.getOverlayIcon();
        GT_RenderedTexture tOut = new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT);
        GT_RenderedTexture tUp = new GT_RenderedTexture(Textures.BlockIcons.ARROW_UP);
        GT_RenderedTexture tDown = new GT_RenderedTexture(Textures.BlockIcons.ARROW_DOWN);
        GT_RenderedTexture tLeft = new GT_RenderedTexture(Textures.BlockIcons.ARROW_LEFT);
        GT_RenderedTexture tRight = new GT_RenderedTexture(Textures.BlockIcons.ARROW_RIGHT);
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], tOut};
            rTextures[1][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], tRight, tIcon};
            rTextures[2][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], tDown, tIcon};
            rTextures[3][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], tLeft, tIcon};
            rTextures[4][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], tUp, tIcon};
            rTextures[5][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], tIcon};
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return this.mTextures[5][aColorIndex + 1];
        }
        if (GT_Utility.getOppositeSide(aSide) == aFacing) {
            return this.mTextures[0][aColorIndex + 1];
        }
        switch (aFacing) {
            case 0: {
                return this.mTextures[4][aColorIndex + 1];
            }
            case 1: {
                return this.mTextures[2][aColorIndex + 1];
            }
            case 2: {
                switch (aSide) {
                    case 0: {
                        return this.mTextures[2][aColorIndex + 1];
                    }
                    case 1: {
                        return this.mTextures[2][aColorIndex + 1];
                    }
                    case 4: {
                        return this.mTextures[1][aColorIndex + 1];
                    }
                    case 5: {
                        return this.mTextures[3][aColorIndex + 1];
                    }
                }
            }
            case 3: {
                switch (aSide) {
                    case 0: {
                        return this.mTextures[4][aColorIndex + 1];
                    }
                    case 1: {
                        return this.mTextures[4][aColorIndex + 1];
                    }
                    case 4: {
                        return this.mTextures[3][aColorIndex + 1];
                    }
                    case 5: {
                        return this.mTextures[1][aColorIndex + 1];
                    }
                }
            }
            case 4: {
                switch (aSide) {
                    case 0: {
                        return this.mTextures[3][aColorIndex + 1];
                    }
                    case 1: {
                        return this.mTextures[1][aColorIndex + 1];
                    }
                    case 2: {
                        return this.mTextures[3][aColorIndex + 1];
                    }
                    case 3: {
                        return this.mTextures[1][aColorIndex + 1];
                    }
                }
            }
            case 5: {
                switch (aSide) {
                    case 0: {
                        return this.mTextures[1][aColorIndex + 1];
                    }
                    case 1: {
                        return this.mTextures[3][aColorIndex + 1];
                    }
                    case 2: {
                        return this.mTextures[1][aColorIndex + 1];
                    }
                    case 3: {
                        return this.mTextures[3][aColorIndex + 1];
                    }
                }
            }
        }
        return this.mTextures[5][aColorIndex + 1];
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex < this.mInventory.length - 1;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return !this.isOutputFacing(aSide);
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return this.getBaseMetaTileEntity().getBackFacing() == aSide;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return 512L;
    }

    @Override
    public long maxEUStore() {
        return 512L + GT_Values.V[this.mTier] * 50L;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxEUOutput() {
        return this.bOutput ? GT_Values.V[this.mTier] : 0L;
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public long maxAmperesOut() {
        return 2L;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public abstract ITexture getOverlayIcon();

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.setBoolean("bInvert", this.bInvert);
        aNBT.setBoolean("bOutput", this.bOutput);
        aNBT.setBoolean("bRedstoneIfFull", this.bRedstoneIfFull);
        aNBT.setBoolean("bStockingMode", this.bStockingMode);
        aNBT.setInteger("mTargetStackSize", this.mTargetStackSize);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.bInvert = aNBT.getBoolean("bInvert");
        this.bOutput = aNBT.getBoolean("bOutput");
        this.bRedstoneIfFull = aNBT.getBoolean("bRedstoneIfFull");
        if (aNBT.hasKey("bStockingMode")) {
            this.bStockingMode = aNBT.getBoolean("bStockingMode");
        }
        this.mTargetStackSize = aNBT.getInteger("mTargetStackSize");
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        if (this.mTargetStackSize > 0) {
            aNBT.setInteger("mTargetStackSize", this.mTargetStackSize);
        }
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aSide == this.getBaseMetaTileEntity().getBackFacing()) {
            this.mTargetStackSize = (byte)((this.mTargetStackSize + (aPlayer.isSneaking() ? -1 : 1)) % 65);
            if (this.mTargetStackSize < 0) {
                this.mTargetStackSize = 64;
            }
            if (this.mTargetStackSize == 0) {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("098", "Do not regulate Item Stack Size"));
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("099", "Regulate Item Stack Size to: ") + this.mTargetStackSize);
            }
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isUniversalEnergyStored(this.getMinimumStoredEU()) && (aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified() || aTimer % 200L == 0L || this.mSuccess > 0)) {
            byte b;
            --this.mSuccess;
            this.moveItems(aBaseMetaTileEntity, aTimer);
            for (b = 0; b < 6; b = (byte)(b + 1)) {
                aBaseMetaTileEntity.setInternalOutputRedstoneSignal(b, this.bInvert ? (byte)15 : 0);
            }
            if (this.bRedstoneIfFull) {
                for (b = 0; b < 6; b = (byte)(b + 1)) {
                    aBaseMetaTileEntity.setInternalOutputRedstoneSignal(b, this.bInvert ? (byte)0 : 15);
                }
                for (int i = 0; i < this.mInventory.length; ++i) {
                    if (!this.isValidSlot(i) || this.mInventory[i] != null) continue;
                    for (byte b2 = 0; b2 < 6; b2 = (byte)(b2 + 1)) {
                        aBaseMetaTileEntity.setInternalOutputRedstoneSignal(b2, this.bInvert ? (byte)15 : 0);
                    }
                    aBaseMetaTileEntity.decreaseStoredEnergyUnits(1L, true);
                    break;
                }
            }
        }
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        for (byte b = 0; b < 6; b = (byte)(b + 1)) {
            aBaseMetaTileEntity.setInternalOutputRedstoneSignal(b, (byte)0);
        }
    }

    protected void moveItems(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        byte tCost = this.bStockingMode ? GT_Utility.moveOneItemStack(aBaseMetaTileEntity, aBaseMetaTileEntity.getTileEntityAtSide(aBaseMetaTileEntity.getBackFacing()), aBaseMetaTileEntity.getBackFacing(), aBaseMetaTileEntity.getFrontFacing(), null, false, (byte)(this.mTargetStackSize == 0 ? 64 : (byte)this.mTargetStackSize), this.mTargetStackSize == 0 ? (byte)1 : (byte)this.mTargetStackSize, (byte)64, (byte)1) : GT_Utility.moveOneItemStack(aBaseMetaTileEntity, aBaseMetaTileEntity.getTileEntityAtSide(aBaseMetaTileEntity.getBackFacing()), aBaseMetaTileEntity.getBackFacing(), aBaseMetaTileEntity.getFrontFacing(), null, false, (byte)64, (byte)1, (byte)(this.mTargetStackSize == 0 ? 64 : (byte)this.mTargetStackSize), this.mTargetStackSize == 0 ? (byte)1 : (byte)this.mTargetStackSize);
        if (tCost > 0 || aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.mSuccess = 50;
            aBaseMetaTileEntity.decreaseStoredEnergyUnits(Math.abs(tCost), true);
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return true;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide != aBaseMetaTileEntity.getBackFacing();
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return true;
    }
}

