/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.GT_Mod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetaTileEntityItemPipe;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Client;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaPipeEntity_Item
extends MetaPipeEntity
implements IMetaTileEntityItemPipe {
    public final float mThickNess;
    public final Materials mMaterial;
    public final int mStepSize;
    public final int mTickTime;
    public int mTransferredItems = 0;
    public byte mLastReceivedFrom = 0;
    public byte oLastReceivedFrom = 0;
    public boolean mIsRestrictive = false;

    public GT_MetaPipeEntity_Item(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, int aInvSlotCount, int aStepSize, boolean aIsRestrictive, int aTickTime) {
        super(aID, aName, aNameRegional, aInvSlotCount, false);
        this.mIsRestrictive = aIsRestrictive;
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mStepSize = aStepSize;
        this.mTickTime = aTickTime;
        this.addInfo(aID);
    }

    public GT_MetaPipeEntity_Item(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, int aInvSlotCount, int aStepSize, boolean aIsRestrictive) {
        this(aID, aName, aNameRegional, aThickNess, aMaterial, aInvSlotCount, aStepSize, aIsRestrictive, 20);
    }

    public GT_MetaPipeEntity_Item(String aName, float aThickNess, Materials aMaterial, int aInvSlotCount, int aStepSize, boolean aIsRestrictive, int aTickTime) {
        super(aName, aInvSlotCount);
        this.mIsRestrictive = aIsRestrictive;
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mStepSize = aStepSize;
        this.mTickTime = aTickTime;
    }

    @Override
    public byte getTileEntityBaseType() {
        return (byte)(this.mMaterial == null ? 4 : 4 + Math.max(0, Math.min(3, this.mMaterial.mToolQuality)));
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaPipeEntity_Item(this.mName, this.mThickNess, this.mMaterial, this.mInventory.length, this.mStepSize, this.mIsRestrictive, this.mTickTime);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aConnections, byte aColorIndex, boolean aConnected, boolean aRedstone) {
        if (this.mIsRestrictive) {
            if (aConnected) {
                float tThickNess = this.getThickNess();
                if (tThickNess < 0.124f) {
                    return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
                }
                if (tThickNess < 0.374f) {
                    return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeTiny.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
                }
                if (tThickNess < 0.499f) {
                    return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeSmall.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
                }
                if (tThickNess < 0.749f) {
                    return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeMedium.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
                }
                if (tThickNess < 0.874f) {
                    return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeLarge.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
                }
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeHuge.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
            }
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.PIPE_RESTRICTOR)};
        }
        if (aConnected) {
            float tThickNess = this.getThickNess();
            if (tThickNess < 0.124f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            if (tThickNess < 0.374f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeTiny.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            if (tThickNess < 0.499f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeSmall.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            if (tThickNess < 0.749f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeMedium.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            if (tThickNess < 0.874f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeLarge.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeHuge.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
        }
        return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public final boolean renderInside(byte aSide) {
        return false;
    }

    @Override
    public int getProgresstime() {
        return this.getPipeContent() * 64;
    }

    @Override
    public int maxProgresstime() {
        return this.getMaxPipeCapacity() * 64;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.setByte("mLastReceivedFrom", this.mLastReceivedFrom);
        if (GT_Mod.gregtechproxy.gt6Pipe) {
            aNBT.setByte("mConnections", this.mConnections);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mLastReceivedFrom = aNBT.getByte("mLastReceivedFrom");
        if (GT_Mod.gregtechproxy.gt6Pipe) {
            this.mConnections = aNBT.getByte("mConnections");
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick % 10L == 0L) {
            if (aTick % (long)this.mTickTime == 0L) {
                this.mTransferredItems = 0;
            }
            if (!GT_Mod.gregtechproxy.gt6Pipe || this.mCheckConnections) {
                this.checkConnections();
            }
            if (this.oLastReceivedFrom == this.mLastReceivedFrom) {
                this.doTickProfilingInThisTick = false;
                ArrayList<IMetaTileEntityItemPipe> tPipeList = new ArrayList<IMetaTileEntityItemPipe>();
                boolean temp = true;
                block0: while (temp && !this.isInventoryEmpty() && this.pipeCapacityCheck()) {
                    temp = false;
                    tPipeList.clear();
                    for (IMetaTileEntityItemPipe tTileEntity : GT_Utility.sortMapByValuesAcending(IMetaTileEntityItemPipe.Util.scanPipes(this, new ConcurrentHashMap<IMetaTileEntityItemPipe, Long>(), 0L, false, false)).keySet()) {
                        if (temp) continue block0;
                        tPipeList.add(tTileEntity);
                        while (!temp && !this.isInventoryEmpty() && tTileEntity.sendItemStack(aBaseMetaTileEntity)) {
                            for (IMetaTileEntityItemPipe tPipe : tPipeList) {
                                if (tPipe.incrementTransferCounter(1)) continue;
                                temp = true;
                            }
                        }
                    }
                }
            }
            if (this.isInventoryEmpty()) {
                this.mLastReceivedFrom = (byte)6;
            }
            this.oLastReceivedFrom = this.mLastReceivedFrom;
        } else if (aBaseMetaTileEntity.isClientSide() && GT_Client.changeDetected == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    @Override
    public boolean onWrenchRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GT_Mod.gregtechproxy.gt6Pipe) {
            byte tSide = GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ);
            if (!this.isConnectedAtSide(tSide)) {
                if (this.connect(tSide) > 0) {
                    GT_Utility.sendChatToPlayer(aPlayer, this.trans("214", "Connected"));
                }
            } else {
                this.disconnect(tSide);
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("215", "Disconnected"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean letsIn(GT_CoverBehavior coverBehavior, byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsItemsIn(aSide, aCoverID, aCoverVariable, -1, aTileEntity);
    }

    @Override
    public boolean letsOut(GT_CoverBehavior coverBehavior, byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsItemsOut(aSide, aCoverID, aCoverVariable, -1, aTileEntity);
    }

    @Override
    public boolean canConnect(byte aSide, TileEntity tTileEntity) {
        IGregTechTileEntity gTileEntity;
        if (tTileEntity == null) {
            return false;
        }
        byte tSide = GT_Utility.getOppositeSide(aSide);
        boolean connectable = GT_Utility.isConnectableNonInventoryPipe(tTileEntity, tSide);
        IGregTechTileEntity iGregTechTileEntity = gTileEntity = tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
        if (gTileEntity != null) {
            if (gTileEntity.getMetaTileEntity() == null) {
                return false;
            }
            if (gTileEntity.getMetaTileEntity().connectsToItemPipe(tSide)) {
                return true;
            }
            connectable = true;
        }
        if (tTileEntity instanceof IInventory) {
            if (((IInventory)tTileEntity).getSizeInventory() <= 0) {
                return false;
            }
            connectable = true;
        }
        if (tTileEntity instanceof ISidedInventory) {
            int[] tSlots = ((ISidedInventory)tTileEntity).getAccessibleSlotsFromSide((int)tSide);
            if (tSlots == null || tSlots.length <= 0) {
                return false;
            }
            connectable = true;
        }
        return connectable;
    }

    @Override
    public boolean getGT6StyleConnection() {
        return GT_Mod.gregtechproxy.gt6Pipe;
    }

    @Override
    public boolean incrementTransferCounter(int aIncrement) {
        this.mTransferredItems += aIncrement;
        return this.pipeCapacityCheck();
    }

    @Override
    public boolean sendItemStack(Object aSender) {
        if (this.pipeCapacityCheck()) {
            byte tOffset = (byte)this.getBaseMetaTileEntity().getRandomNumber(6);
            byte tSide = 0;
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                tSide = (byte)((i + tOffset) % 6);
                if (!this.isConnectedAtSide(tSide) || !this.isInventoryEmpty() && tSide == this.mLastReceivedFrom && aSender == this.getBaseMetaTileEntity() || !this.insertItemStackIntoTileEntity(aSender, tSide)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean insertItemStackIntoTileEntity(Object aSender, byte aSide) {
        TileEntity tInventory;
        if (this.getBaseMetaTileEntity().getCoverBehaviorAtSide(aSide).letsItemsOut(aSide, this.getBaseMetaTileEntity().getCoverIDAtSide(aSide), this.getBaseMetaTileEntity().getCoverDataAtSide(aSide), -1, this.getBaseMetaTileEntity()) && (tInventory = this.getBaseMetaTileEntity().getTileEntityAtSide(aSide)) != null && !(tInventory instanceof BaseMetaPipeEntity) && (!(tInventory instanceof TileEntityHopper) && !(tInventory instanceof TileEntityDispenser) || this.getBaseMetaTileEntity().getMetaIDAtSide(aSide) != GT_Utility.getOppositeSide(aSide))) {
            return GT_Utility.moveOneItemStack(aSender, tInventory, (byte)6, GT_Utility.getOppositeSide(aSide), null, false, (byte)64, (byte)1, (byte)64, (byte)1) > 0;
        }
        return false;
    }

    @Override
    public boolean pipeCapacityCheck() {
        return this.mTransferredItems <= 0 || this.getPipeContent() < this.getMaxPipeCapacity();
    }

    private int getPipeContent() {
        return this.mTransferredItems;
    }

    private int getMaxPipeCapacity() {
        return Math.max(1, this.getPipeCapacity());
    }

    public int getPipeCapacity() {
        return this.mInventory.length;
    }

    @Override
    public int getStepSize() {
        return this.mStepSize;
    }

    @Override
    public boolean canInsertItem(int aIndex, ItemStack aStack, int aSide) {
        return this.isConnectedAtSide(aSide) && super.canInsertItem(aIndex, aStack, aSide);
    }

    @Override
    public boolean canExtractItem(int aIndex, ItemStack aStack, int aSide) {
        return this.isConnectedAtSide(aSide);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return this.isConnectedAtSide(aSide);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (!this.isConnectedAtSide(aSide)) {
            return false;
        }
        if (this.isInventoryEmpty()) {
            this.mLastReceivedFrom = aSide;
        }
        return this.mLastReceivedFrom == aSide && this.mInventory[aIndex] == null;
    }

    @Override
    public String[] getDescription() {
        if (this.mTickTime == 20) {
            return new String[]{"Item Capacity: %%%" + this.getMaxPipeCapacity() + "%%% Stacks/sec", "Routing Value: %%%" + this.mStepSize};
        }
        if (this.mTickTime % 20 == 0) {
            return new String[]{"Item Capacity: %%%" + this.getMaxPipeCapacity() + "%%% Stacks/%%%" + this.mTickTime / 20 + "%%% sec", "Routing Value: %%%" + this.mStepSize};
        }
        return new String[]{"Item Capacity: %%%" + this.getMaxPipeCapacity() + "%%% Stacks/%%%" + this.mTickTime + "%%% ticks", "Routing Value: %%%" + this.mStepSize};
    }

    private boolean isInventoryEmpty() {
        for (ItemStack tStack : this.mInventory) {
            if (tStack == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public float getThickNess() {
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 1) != 0) {
            return 0.0625f;
        }
        return this.mThickNess;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 2) != 0) {
            return AxisAlignedBB.getBoundingBox((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
        }
        return this.getActualCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
    }

    private AxisAlignedBB getActualCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        byte tConn;
        float tSpace;
        float tSide0 = tSpace = (1.0f - this.mThickNess) / 2.0f;
        float tSide1 = 1.0f - tSpace;
        float tSide2 = tSpace;
        float tSide3 = 1.0f - tSpace;
        float tSide4 = tSpace;
        float tSide5 = 1.0f - tSpace;
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)0) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)1) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)2) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)3) != 0) {
            tSide4 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)4) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)5) != 0) {
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (((tConn = ((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections) & 1 << ForgeDirection.DOWN.ordinal()) != 0) {
            tSide0 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.UP.ordinal()) != 0) {
            tSide1 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.NORTH.ordinal()) != 0) {
            tSide2 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.SOUTH.ordinal()) != 0) {
            tSide3 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.WEST.ordinal()) != 0) {
            tSide4 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.EAST.ordinal()) != 0) {
            tSide5 = 1.0f;
        }
        return AxisAlignedBB.getBoundingBox((double)((float)aX + tSide4), (double)((float)aY + tSide0), (double)((float)aZ + tSide2), (double)((float)aX + tSide5), (double)((float)aY + tSide1), (double)((float)aZ + tSide3));
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        AxisAlignedBB aabb;
        super.addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 2) != 0 && inputAABB.intersectsWith(aabb = this.getActualCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ))) {
            outputAABB.add(aabb);
        }
    }
}

