/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import appeng.api.parts.IPartHost;
import appeng.tile.powersink.IC2;
import cofh.api.energy.IEnergyReceiver;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.Loader;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetaTileEntityCable;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_GC_Compat;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Client;
import gregtech.common.covers.GT_Cover_SolarPanel;
import gregtech.loaders.postload.PartP2PGTPower;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.reactor.IReactorChamber;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaPipeEntity_Cable
extends MetaPipeEntity
implements IMetaTileEntityCable {
    public final float mThickNess;
    public final Materials mMaterial;
    public final long mCableLossPerMeter;
    public final long mAmperage;
    public final long mVoltage;
    public final boolean mInsulated;
    public final boolean mCanShock;
    public int mTransferredAmperage = 0;
    public int mTransferredAmperageLast20 = 0;
    public int mTransferredAmperageLast20OK = 0;
    public int mTransferredAmperageOK = 0;
    public long mTransferredVoltageLast20 = 0L;
    public long mTransferredVoltage = 0L;
    public long mTransferredVoltageLast20OK = 0L;
    public long mTransferredVoltageOK = 0L;
    public long mRestRF;
    public int mOverheat;
    public static short mMaxOverheat = (short)(GT_Mod.gregtechproxy.mWireHeatingTicks * 100);
    private int[] lastAmperage;
    private long lastWorldTick;

    public GT_MetaPipeEntity_Cable(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aID, aName, aNameRegional, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mAmperage = aAmperage;
        this.mVoltage = aVoltage;
        this.mInsulated = aInsulated;
        this.mCanShock = aCanShock;
        this.mCableLossPerMeter = aCableLossPerMeter;
    }

    public GT_MetaPipeEntity_Cable(String aName, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aName, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mAmperage = aAmperage;
        this.mVoltage = aVoltage;
        this.mInsulated = aInsulated;
        this.mCanShock = aCanShock;
        this.mCableLossPerMeter = aCableLossPerMeter;
    }

    @Override
    public byte getTileEntityBaseType() {
        return (byte)(this.mInsulated ? 9 : 8);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaPipeEntity_Cable(this.mName, this.mThickNess, this.mMaterial, this.mCableLossPerMeter, this.mAmperage, this.mVoltage, this.mInsulated, this.mCanShock);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aConnections, byte aColorIndex, boolean aConnected, boolean aRedstone) {
        if (!this.mInsulated) {
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
        }
        if (aConnected) {
            float tThickNess = this.getThickNess();
            if (tThickNess < 0.124f) {
                return new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.374f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_TINY, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.499f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_SMALL, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.624f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_MEDIUM, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.749f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_MEDIUM_PLUS, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.874f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_LARGE, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_HUGE, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
        }
        return new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        if (this.mCanShock && (((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections & 0xFFFFFF80) == 0 && aEntity instanceof EntityLivingBase && !this.isCoverOnSide((BaseMetaPipeEntity)this.getBaseMetaTileEntity(), (EntityLivingBase)aEntity)) {
            GT_Utility.applyElectricityDamage((EntityLivingBase)aEntity, this.mTransferredVoltageLast20, this.mTransferredAmperageLast20);
        }
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public final boolean renderInside(byte aSide) {
        return false;
    }

    @Override
    public int getProgresstime() {
        return this.mTransferredAmperage * 64;
    }

    @Override
    public int maxProgresstime() {
        return (int)this.mAmperage * 64;
    }

    @Override
    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (!this.isConnectedAtSide(aSide) && aSide != 6) {
            return 0L;
        }
        if (!this.getBaseMetaTileEntity().getCoverBehaviorAtSide(aSide).letsEnergyIn(aSide, this.getBaseMetaTileEntity().getCoverIDAtSide(aSide), this.getBaseMetaTileEntity().getCoverDataAtSide(aSide), this.getBaseMetaTileEntity())) {
            return 0L;
        }
        return this.transferElectricity(aSide, aVoltage, aAmperage, Sets.newHashSet((Object[])new TileEntity[]{(TileEntity)this.getBaseMetaTileEntity()}));
    }

    @Override
    @Deprecated
    public long transferElectricity(byte aSide, long aVoltage, long aAmperage, ArrayList<TileEntity> aAlreadyPassedTileEntityList) {
        return this.transferElectricity(aSide, aVoltage, aAmperage, new HashSet<TileEntity>(aAlreadyPassedTileEntityList));
    }

    @Override
    public long transferElectricity(byte aSide, long aVoltage, long aAmperage, HashSet<TileEntity> aAlreadyPassedSet) {
        if (!this.isConnectedAtSide(aSide) && aSide != 6) {
            return 0L;
        }
        long rUsedAmperes = 0L;
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        byte i = (byte)((aSide / 2 * 2 + 2) % 6);
        if ((aVoltage -= this.mCableLossPerMeter) > 0L) {
            for (int j = 0; j < 6 && aAmperage > rUsedAmperes; j = (int)((byte)(j + 1))) {
                TileEntity tTileEntity;
                if (i != aSide && this.isConnectedAtSide(i) && baseMetaTile.getCoverBehaviorAtSide(i).letsEnergyOut(i, baseMetaTile.getCoverIDAtSide(i), baseMetaTile.getCoverDataAtSide(i), baseMetaTile) && (tTileEntity = baseMetaTile.getTileEntityAtSide(i)) != null && aAlreadyPassedSet.add(tTileEntity)) {
                    IMetaTileEntity tMeta;
                    byte tSide = GT_Utility.getOppositeSide(i);
                    IGregTechTileEntity tBaseMetaTile = tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
                    IMetaTileEntity iMetaTileEntity = tMeta = tBaseMetaTile != null ? tBaseMetaTile.getMetaTileEntity() : null;
                    if (tMeta instanceof IMetaTileEntityCable) {
                        if (tBaseMetaTile.getCoverBehaviorAtSide(tSide).letsEnergyIn(tSide, tBaseMetaTile.getCoverIDAtSide(tSide), tBaseMetaTile.getCoverDataAtSide(tSide), tBaseMetaTile) && ((IGregTechTileEntity)tTileEntity).getTimer() > 50L) {
                            rUsedAmperes += ((IMetaTileEntityCable)((IGregTechTileEntity)tTileEntity).getMetaTileEntity()).transferElectricity(tSide, aVoltage, aAmperage - rUsedAmperes, aAlreadyPassedSet);
                        }
                    } else {
                        rUsedAmperes += this.insertEnergyInto(tTileEntity, tSide, aVoltage, aAmperage - rUsedAmperes);
                    }
                }
                i = (byte)((i + 1) % 6);
            }
        }
        this.mTransferredVoltage = Math.max(this.mTransferredVoltage, aVoltage);
        this.mTransferredAmperage = (int)((long)this.mTransferredAmperage + rUsedAmperes);
        this.mTransferredVoltageLast20 = Math.max(this.mTransferredVoltageLast20, aVoltage);
        this.mTransferredAmperageLast20 = Math.max(this.mTransferredAmperageLast20, this.mTransferredAmperage);
        if (aVoltage > this.mVoltage) {
            this.mOverheat += Math.max(100, 100 * GT_Utility.getTier(aVoltage) - GT_Utility.getTier(this.mVoltage));
        }
        if ((long)this.mTransferredAmperage > this.mAmperage) {
            return aAmperage;
        }
        return rUsedAmperes;
    }

    private long insertEnergyInto(TileEntity tTileEntity, byte tSide, long aVoltage, long aAmperage) {
        TileEntity tIc2Acceptor;
        long gc;
        if (aAmperage == 0L || tTileEntity == null) {
            return 0L;
        }
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        ForgeDirection tDirection = ForgeDirection.getOrientation((int)tSide);
        if (tTileEntity instanceof IEnergyConnected) {
            return ((IEnergyConnected)tTileEntity).injectEnergyUnits(tSide, aVoltage, aAmperage);
        }
        if (GT_Mod.gregtechproxy.mAE2Integration && tTileEntity instanceof IC2) {
            if (((IC2)tTileEntity).acceptsEnergyFrom((TileEntity)baseMetaTile, tDirection)) {
                long rUsedAmperes;
                for (rUsedAmperes = 0L; aAmperage > rUsedAmperes && ((IC2)tTileEntity).getDemandedEnergy() > 0.0 && ((IC2)tTileEntity).injectEnergy(tDirection, (double)aVoltage, (double)aVoltage) <= (double)aVoltage; ++rUsedAmperes) {
                }
                return rUsedAmperes;
            }
            return 0L;
        }
        if (Loader.isModLoaded((String)"GalacticraftCore") && (gc = GT_GC_Compat.insertEnergyInto(tTileEntity, aVoltage, tDirection)) != 2L) {
            return gc;
        }
        TileEntity tileEntity = tIc2Acceptor = tTileEntity instanceof IEnergyTile || EnergyNet.instance == null ? tTileEntity : EnergyNet.instance.getTileEntity(tTileEntity.getWorldObj(), tTileEntity.xCoord, tTileEntity.yCoord, tTileEntity.zCoord);
        if (tIc2Acceptor instanceof IEnergySink && ((IEnergySink)tIc2Acceptor).acceptsEnergyFrom((TileEntity)baseMetaTile, tDirection)) {
            long rUsedAmperes;
            for (rUsedAmperes = 0L; aAmperage > rUsedAmperes && ((IEnergySink)tIc2Acceptor).getDemandedEnergy() > 0.0 && ((IEnergySink)tIc2Acceptor).injectEnergy(tDirection, (double)aVoltage, (double)aVoltage) <= (double)aVoltage; ++rUsedAmperes) {
            }
            return rUsedAmperes;
        }
        if (GregTech_API.mOutputRF && tTileEntity instanceof IEnergyReceiver) {
            int rfOut;
            IEnergyReceiver rfReceiver = (IEnergyReceiver)tTileEntity;
            long rfOUT = aVoltage * (long)GregTech_API.mEUtoRF / 100L;
            long rUsedAmperes = 0L;
            int n = rfOut = rfOUT > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)rfOUT;
            if (rfReceiver.receiveEnergy(tDirection, rfOut, true) == rfOut) {
                rfReceiver.receiveEnergy(tDirection, rfOut, false);
                ++rUsedAmperes;
            } else if (rfReceiver.receiveEnergy(tDirection, rfOut, true) > 0) {
                if (this.mRestRF == 0L) {
                    int RFtrans = rfReceiver.receiveEnergy(tDirection, rfOut, false);
                    ++rUsedAmperes;
                    this.mRestRF = rfOut - RFtrans;
                } else {
                    int RFtrans = rfReceiver.receiveEnergy(tDirection, (int)this.mRestRF, false);
                    this.mRestRF -= (long)RFtrans;
                }
            }
            if (GregTech_API.mRFExplosions && rfReceiver.getMaxEnergyStored(tDirection) < rfOut * 600 && rfOut > 32 * GregTech_API.mEUtoRF / 100) {
                this.doExplosion(rfOut);
            }
            return rUsedAmperes;
        }
        return 0L;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.lastAmperage = new int[16];
            this.lastWorldTick = aBaseMetaTileEntity.getWorld().getTotalWorldTime() - 1L;
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            int i;
            long worldTick = aBaseMetaTileEntity.getWorld().getTotalWorldTime();
            int tickDiff = (int)(worldTick - this.lastWorldTick);
            this.lastWorldTick = worldTick;
            if (tickDiff >= 16) {
                for (i = 0; i <= 14; ++i) {
                    this.lastAmperage[i] = 0;
                }
            } else {
                System.arraycopy(this.lastAmperage, tickDiff, this.lastAmperage, 0, 16 - tickDiff);
                for (i = 14; i >= 0 && --tickDiff > 0; --i) {
                    this.lastAmperage[i] = 0;
                }
            }
            this.lastAmperage[15] = this.mTransferredAmperage;
            if ((long)this.lastAmperage[15] > this.mAmperage) {
                for (i = 0; i <= 14; ++i) {
                    if ((long)this.lastAmperage[i] >= this.mAmperage) continue;
                    this.lastAmperage[15] = this.lastAmperage[15] - ((int)this.mAmperage - this.lastAmperage[i]);
                    this.lastAmperage[i] = (int)this.mAmperage;
                    if ((long)this.lastAmperage[15] <= this.mAmperage) break;
                }
                if ((long)this.lastAmperage[15] > this.mAmperage) {
                    this.mOverheat = (int)((long)this.mOverheat + 100L * ((long)this.lastAmperage[15] - this.mAmperage));
                    this.lastAmperage[15] = (int)this.mAmperage;
                } else if ((long)this.lastAmperage[15] < this.mAmperage) {
                    this.lastAmperage[i] = this.lastAmperage[15];
                    this.lastAmperage[15] = (int)this.mAmperage;
                }
            }
            if (this.mOverheat >= mMaxOverheat) {
                aBaseMetaTileEntity.setToFire();
            } else if (this.mOverheat > 0) {
                --this.mOverheat;
            }
            this.mTransferredVoltageOK = this.mTransferredVoltage;
            this.mTransferredVoltage = 0L;
            this.mTransferredAmperageOK = this.mTransferredAmperage;
            this.mTransferredAmperage = 0;
            if (aTick % 20L == 0L) {
                this.mTransferredVoltageLast20OK = this.mTransferredVoltageLast20;
                this.mTransferredVoltageLast20 = 0L;
                this.mTransferredAmperageLast20OK = this.mTransferredAmperageLast20;
                this.mTransferredAmperageLast20 = 0;
                if (!GT_Mod.gregtechproxy.gt6Cable || this.mCheckConnections) {
                    this.checkConnections();
                }
            }
        } else if (aBaseMetaTileEntity.isClientSide() && GT_Client.changeDetected == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    @Override
    public boolean onWireCutterRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GT_Mod.gregtechproxy.gt6Cable && GT_ModHandler.damageOrDechargeItem(aPlayer.inventory.getCurrentItem(), 1, 500, (EntityLivingBase)aPlayer)) {
            if (this.isConnectedAtSide(aWrenchingSide)) {
                this.disconnect(aWrenchingSide);
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("215", "Disconnected"));
            } else if (!GT_Mod.gregtechproxy.costlyCableConnection && this.connect(aWrenchingSide) > 0) {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("214", "Connected"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onSolderingToolRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GT_Mod.gregtechproxy.gt6Cable && GT_ModHandler.damageOrDechargeItem(aPlayer.inventory.getCurrentItem(), 1, 500, (EntityLivingBase)aPlayer)) {
            if (this.isConnectedAtSide(aWrenchingSide)) {
                this.disconnect(aWrenchingSide);
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("215", "Disconnected"));
            } else if ((!GT_Mod.gregtechproxy.costlyCableConnection || GT_ModHandler.consumeSolderingMaterial(aPlayer)) && this.connect(aWrenchingSide) > 0) {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("214", "Connected"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean letsIn(GT_CoverBehavior coverBehavior, byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsEnergyIn(aSide, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    public boolean letsOut(GT_CoverBehavior coverBehavior, byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsEnergyOut(aSide, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    public boolean canConnect(byte aSide, TileEntity tTileEntity) {
        TileEntity ic2Energy;
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        GT_CoverBehavior coverBehavior = baseMetaTile.getCoverBehaviorAtSide(aSide);
        byte tSide = GT_Utility.getOppositeSide(aSide);
        ForgeDirection tDir = ForgeDirection.getOrientation((int)tSide);
        if (tTileEntity instanceof IEnergyConnected && (((IEnergyConnected)tTileEntity).inputEnergyFrom(tSide, false) || ((IEnergyConnected)tTileEntity).outputsEnergyTo(tSide, false))) {
            return true;
        }
        if (coverBehavior instanceof GT_Cover_SolarPanel) {
            return true;
        }
        if (Loader.isModLoaded((String)"GalacticraftCore") && GT_GC_Compat.canConnect(tTileEntity, tDir)) {
            return true;
        }
        if (GT_Mod.gregtechproxy.mAE2Integration) {
            if (tTileEntity instanceof IEnergySource && tTileEntity instanceof IPartHost && ((IPartHost)tTileEntity).getPart(tDir) instanceof PartP2PGTPower && ((IEnergySource)tTileEntity).emitsEnergyTo((TileEntity)baseMetaTile, tDir)) {
                return true;
            }
            if (tTileEntity instanceof IC2 && ((IC2)tTileEntity).acceptsEnergyFrom((TileEntity)baseMetaTile, tDir)) {
                return true;
            }
        }
        if (tTileEntity instanceof IReactorChamber) {
            ic2Energy = (TileEntity)((IReactorChamber)tTileEntity).getReactor();
        } else {
            TileEntity tileEntity = ic2Energy = tTileEntity == null || tTileEntity instanceof IEnergyTile || EnergyNet.instance == null ? tTileEntity : EnergyNet.instance.getTileEntity(tTileEntity.getWorldObj(), tTileEntity.xCoord, tTileEntity.yCoord, tTileEntity.zCoord);
        }
        if (ic2Energy instanceof IEnergySink && ((IEnergySink)ic2Energy).acceptsEnergyFrom((TileEntity)baseMetaTile, tDir)) {
            return true;
        }
        if (GT_Mod.gregtechproxy.ic2EnergySourceCompat && ic2Energy instanceof IEnergySource && ((IEnergySource)ic2Energy).emitsEnergyTo((TileEntity)baseMetaTile, tDir)) {
            return true;
        }
        if (GregTech_API.mOutputRF && tTileEntity instanceof IEnergyReceiver && ((IEnergyReceiver)tTileEntity).canConnectEnergy(tDir)) {
            return true;
        }
        return GregTech_API.mInputRF && tTileEntity instanceof IEnergyEmitter && ((IEnergyEmitter)tTileEntity).emitsEnergyTo((TileEntity)baseMetaTile, tDir);
    }

    @Override
    public boolean getGT6StyleConnection() {
        return GT_Mod.gregtechproxy.gt6Cable;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Max Voltage: %%%" + EnumChatFormatting.GREEN + this.mVoltage + " (" + GT_Values.VN[GT_Utility.getTier(this.mVoltage)] + ")" + EnumChatFormatting.GRAY, "Max Amperage: %%%" + EnumChatFormatting.YELLOW + this.mAmperage + EnumChatFormatting.GRAY, "Loss/Meter/Ampere: %%%" + EnumChatFormatting.RED + this.mCableLossPerMeter + EnumChatFormatting.GRAY + "%%% EU-Volt"};
    }

    @Override
    public float getThickNess() {
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 1) != 0) {
            return 0.0625f;
        }
        return this.mThickNess;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        if (GT_Mod.gregtechproxy.gt6Cable) {
            aNBT.setByte("mConnections", this.mConnections);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (GT_Mod.gregtechproxy.gt6Cable) {
            this.mConnections = aNBT.getByte("mConnections");
        }
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"Heat: " + EnumChatFormatting.RED + this.mOverheat + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + mMaxOverheat + EnumChatFormatting.RESET, "Max Load (1t):", EnumChatFormatting.GREEN + Integer.toString(this.mTransferredAmperageOK) + EnumChatFormatting.RESET + " A / " + EnumChatFormatting.YELLOW + Long.toString(this.mAmperage) + EnumChatFormatting.RESET + " A", "Max EU/p (1t):", EnumChatFormatting.GREEN + Long.toString(this.mTransferredVoltageOK) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + Long.toString(this.mVoltage) + EnumChatFormatting.RESET + " EU", "Max Load (20t): " + EnumChatFormatting.GREEN + Integer.toString(this.mTransferredAmperageLast20OK) + EnumChatFormatting.RESET + " A", "Max EU/p (20t): " + EnumChatFormatting.GREEN + Long.toString(this.mTransferredVoltageLast20OK) + EnumChatFormatting.RESET + " EU"};
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 2) != 0) {
            return AxisAlignedBB.getBoundingBox((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
        }
        return this.getActualCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
    }

    private AxisAlignedBB getActualCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        byte tConn;
        float tSpace;
        float tSide0 = tSpace = (1.0f - this.mThickNess) / 2.0f;
        float tSide1 = 1.0f - tSpace;
        float tSide2 = tSpace;
        float tSide3 = 1.0f - tSpace;
        float tSide4 = tSpace;
        float tSide5 = 1.0f - tSpace;
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)0) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)1) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)2) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)3) != 0) {
            tSide4 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)4) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)5) != 0) {
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (((tConn = ((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections) & 1 << ForgeDirection.DOWN.ordinal()) != 0) {
            tSide0 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.UP.ordinal()) != 0) {
            tSide1 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.NORTH.ordinal()) != 0) {
            tSide2 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.SOUTH.ordinal()) != 0) {
            tSide3 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.WEST.ordinal()) != 0) {
            tSide4 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.EAST.ordinal()) != 0) {
            tSide5 = 1.0f;
        }
        return AxisAlignedBB.getBoundingBox((double)((float)aX + tSide4), (double)((float)aY + tSide0), (double)((float)aZ + tSide2), (double)((float)aX + tSide5), (double)((float)aY + tSide1), (double)((float)aZ + tSide3));
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        AxisAlignedBB aabb;
        super.addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 2) != 0 && inputAABB.intersectsWith(aabb = this.getActualCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ))) {
            outputAABB.add(aabb);
        }
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        if (!GT_Mod.gregtechproxy.ic2EnergySourceCompat) {
            return false;
        }
        if (this.mConnections != 0) {
            IGregTechTileEntity baseMeta = this.getBaseMetaTileEntity();
            for (byte aSide = 0; aSide < 6; aSide = (byte)(aSide + 1)) {
                TileEntity tEmitter;
                if (!this.isConnectedAtSide(aSide)) continue;
                TileEntity tTileEntity = baseMeta.getTileEntityAtSide(aSide);
                TileEntity tileEntity = tEmitter = tTileEntity == null || tTileEntity instanceof IEnergyTile || EnergyNet.instance == null ? tTileEntity : EnergyNet.instance.getTileEntity(tTileEntity.getWorldObj(), tTileEntity.xCoord, tTileEntity.yCoord, tTileEntity.zCoord);
                if (!(tEmitter instanceof IEnergyEmitter)) continue;
                return true;
            }
        }
        return false;
    }
}

