/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import cpw.mods.fml.common.eventhandler.Event;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.TileIC2EnergySink;
import gregtech.api.net.GT_Packet_Block_Event;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class BaseTileEntity
extends TileEntity
implements IHasWorldObjectAndCoords {
    private final TileEntity[] mBufferedTileEntities = new TileEntity[6];
    public boolean ignoreUnloadedChunks = true;
    public boolean isDead = false;
    protected TileIC2EnergySink ic2EnergySink = null;
    protected boolean joinedIc2Enet = false;

    private final void clearNullMarkersFromTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            if (this.mBufferedTileEntities[i] != this) continue;
            this.mBufferedTileEntities[i] = null;
        }
    }

    protected final void clearTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            this.mBufferedTileEntities[i] = null;
        }
    }

    @Override
    public final World getWorld() {
        return this.worldObj;
    }

    @Override
    public final int getXCoord() {
        return this.xCoord;
    }

    @Override
    public final short getYCoord() {
        return (short)this.yCoord;
    }

    @Override
    public final int getZCoord() {
        return this.zCoord;
    }

    @Override
    public final int getOffsetX(byte aSide, int aMultiplier) {
        return this.xCoord + ForgeDirection.getOrientation((int)aSide).offsetX * aMultiplier;
    }

    @Override
    public final short getOffsetY(byte aSide, int aMultiplier) {
        return (short)(this.yCoord + ForgeDirection.getOrientation((int)aSide).offsetY * aMultiplier);
    }

    @Override
    public final int getOffsetZ(byte aSide, int aMultiplier) {
        return this.zCoord + ForgeDirection.getOrientation((int)aSide).offsetZ * aMultiplier;
    }

    @Override
    public final boolean isServerSide() {
        return !this.worldObj.isRemote;
    }

    @Override
    public final boolean isClientSide() {
        return this.worldObj.isRemote;
    }

    @Override
    public final boolean openGUI(EntityPlayer aPlayer) {
        return this.openGUI(aPlayer, 0);
    }

    @Override
    public final boolean openGUI(EntityPlayer aPlayer, int aID) {
        if (aPlayer == null) {
            return false;
        }
        aPlayer.openGui((Object)GT_Values.GT, aID, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    public final int getRandomNumber(int aRange) {
        return ThreadLocalRandom.current().nextInt(aRange);
    }

    @Override
    public final BiomeGenBase getBiome(int aX, int aZ) {
        return this.worldObj.getBiomeGenForCoords(aX, aZ);
    }

    @Override
    public final BiomeGenBase getBiome() {
        return this.getBiome(this.xCoord, this.zCoord);
    }

    @Override
    public final Block getBlockOffset(int aX, int aY, int aZ) {
        return this.getBlock(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public final Block getBlockAtSide(byte aSide) {
        return this.getBlockAtSideAndDistance(aSide, 1);
    }

    @Override
    public final Block getBlockAtSideAndDistance(byte aSide, int aDistance) {
        return this.getBlock(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final byte getMetaIDOffset(int aX, int aY, int aZ) {
        return this.getMetaID(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public final byte getMetaIDAtSide(byte aSide) {
        return this.getMetaIDAtSideAndDistance(aSide, 1);
    }

    @Override
    public final byte getMetaIDAtSideAndDistance(byte aSide, int aDistance) {
        return this.getMetaID(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final byte getLightLevelOffset(int aX, int aY, int aZ) {
        return this.getLightLevel(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public final byte getLightLevelAtSide(byte aSide) {
        return this.getLightLevelAtSideAndDistance(aSide, 1);
    }

    @Override
    public final byte getLightLevelAtSideAndDistance(byte aSide, int aDistance) {
        return this.getLightLevel(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final boolean getOpacityOffset(int aX, int aY, int aZ) {
        return this.getOpacity(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public final boolean getOpacityAtSide(byte aSide) {
        return this.getOpacityAtSideAndDistance(aSide, 1);
    }

    @Override
    public final boolean getOpacityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getOpacity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final boolean getSkyOffset(int aX, int aY, int aZ) {
        return this.getSky(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public final boolean getSkyAtSide(byte aSide) {
        return this.getSkyAtSideAndDistance(aSide, 1);
    }

    @Override
    public final boolean getSkyAtSideAndDistance(byte aSide, int aDistance) {
        return this.getSky(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final boolean getAirOffset(int aX, int aY, int aZ) {
        return this.getAir(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public final boolean getAirAtSide(byte aSide) {
        return this.getAirAtSideAndDistance(aSide, 1);
    }

    @Override
    public final boolean getAirAtSideAndDistance(byte aSide, int aDistance) {
        return this.getAir(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final TileEntity getTileEntityOffset(int aX, int aY, int aZ) {
        return this.getTileEntity(this.xCoord + aX, this.yCoord + aY, this.zCoord + aZ);
    }

    @Override
    public final TileEntity getTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        if (aDistance == 1) {
            return this.getTileEntityAtSide(aSide);
        }
        return this.getTileEntity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public final IInventory getIInventory(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IInventory getIInventoryOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IInventory getIInventoryAtSide(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSide(aSide);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IInventory getIInventoryAtSideAndDistance(byte aSide, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, aDistance);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainer(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainerOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainerAtSide(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSide(aSide);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainerAtSideAndDistance(byte aSide, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, aDistance);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntity(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSide(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSide(aSide);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, aDistance);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final Block getBlock(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return Blocks.air;
        }
        return this.worldObj.getBlock(aX, aY, aZ);
    }

    @Override
    public final byte getMetaID(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return 0;
        }
        return (byte)this.worldObj.getBlockMetadata(aX, aY, aZ);
    }

    @Override
    public final byte getLightLevel(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return 0;
        }
        return (byte)(this.worldObj.getLightBrightness(aX, aY, aZ) * 15.0f);
    }

    @Override
    public final boolean getSky(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return true;
        }
        return this.worldObj.canBlockSeeTheSky(aX, aY, aZ);
    }

    @Override
    public final boolean getOpacity(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return false;
        }
        return GT_Utility.isOpaqueBlock(this.worldObj, aX, aY, aZ);
    }

    @Override
    public final boolean getAir(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return true;
        }
        return GT_Utility.isBlockAir(this.worldObj, aX, aY, aZ);
    }

    @Override
    public final TileEntity getTileEntity(int aX, int aY, int aZ) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.worldObj.blockExists(aX, aY, aZ)) {
            return null;
        }
        return this.worldObj.getTileEntity(aX, aY, aZ);
    }

    @Override
    public final TileEntity getTileEntityAtSide(byte aSide) {
        if (aSide < 0 || aSide >= 6 || this.mBufferedTileEntities[aSide] == this) {
            return null;
        }
        int tX = this.getOffsetX(aSide, 1);
        short tY = this.getOffsetY(aSide, 1);
        int tZ = this.getOffsetZ(aSide, 1);
        if (this.crossedChunkBorder(tX, tZ)) {
            this.mBufferedTileEntities[aSide] = null;
            if (this.ignoreUnloadedChunks && !this.worldObj.blockExists(tX, (int)tY, tZ)) {
                return null;
            }
        }
        if (this.mBufferedTileEntities[aSide] == null) {
            this.mBufferedTileEntities[aSide] = this.worldObj.getTileEntity(tX, (int)tY, tZ);
            if (this.mBufferedTileEntities[aSide] == null) {
                this.mBufferedTileEntities[aSide] = this;
                return null;
            }
            return this.mBufferedTileEntities[aSide];
        }
        if (this.mBufferedTileEntities[aSide].isInvalid()) {
            this.mBufferedTileEntities[aSide] = null;
            return this.getTileEntityAtSide(aSide);
        }
        if (this.mBufferedTileEntities[aSide].xCoord == tX && this.mBufferedTileEntities[aSide].yCoord == tY && this.mBufferedTileEntities[aSide].zCoord == tZ) {
            return this.mBufferedTileEntities[aSide];
        }
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound aNBT) {
        super.writeToNBT(aNBT);
    }

    @Override
    public boolean isDead() {
        return this.isDead || this.isInvalidTileEntity();
    }

    public void validate() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.validate();
    }

    public void invalidate() {
        this.leaveEnet();
        this.clearNullMarkersFromTileEntityBuffer();
        super.invalidate();
    }

    public void onChunkUnload() {
        this.leaveEnet();
        this.clearNullMarkersFromTileEntityBuffer();
        super.onChunkUnload();
        this.isDead = true;
    }

    public void updateEntity() {
        this.isDead = false;
    }

    public final void onAdjacentBlockChange(int aX, int aY, int aZ) {
        this.clearNullMarkersFromTileEntityBuffer();
    }

    public void updateNeighbours(int mStrongRedstone, int oStrongRedstone) {
        Block thisBlock = this.getBlockOffset(0, 0, 0);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int x1 = this.xCoord + dir.offsetX;
            int y1 = this.yCoord + dir.offsetY;
            int z1 = this.zCoord + dir.offsetZ;
            if (!this.worldObj.blockExists(x1, y1, z1)) continue;
            this.worldObj.notifyBlockOfNeighborChange(x1, y1, z1, thisBlock);
            if (((mStrongRedstone | oStrongRedstone) >>> dir.ordinal() & 1) == 0 || !this.getBlock(x1, y1, z1).isNormalCube()) continue;
            int skipUpdateSide = dir.getOpposite().ordinal();
            for (ForgeDirection dir2 : ForgeDirection.VALID_DIRECTIONS) {
                int x2 = x1 + dir2.offsetX;
                int y2 = y1 + dir2.offsetY;
                int z2 = z1 + dir2.offsetZ;
                if (dir2.ordinal() == skipUpdateSide || !this.worldObj.blockExists(x2, y2, z2)) continue;
                this.worldObj.notifyBlockOfNeighborChange(x2, y2, z2, thisBlock);
            }
        }
    }

    @Override
    public final void sendBlockEvent(byte aID, byte aValue) {
        GT_Values.NW.sendPacketToAllPlayersInRange(this.worldObj, new GT_Packet_Block_Event(this.xCoord, (short)this.yCoord, this.zCoord, aID, aValue), this.xCoord, this.zCoord);
    }

    private boolean crossedChunkBorder(int aX, int aZ) {
        return aX >> 4 != this.xCoord >> 4 || aZ >> 4 != this.zCoord >> 4;
    }

    public final void setOnFire() {
        GT_Utility.setCoordsOnFire(this.worldObj, this.xCoord, this.yCoord, this.zCoord, false);
    }

    public final void setToFire() {
        this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, (Block)Blocks.fire);
    }

    public void markDirty() {
    }

    public String trans(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_" + aKey, aEnglish, false);
    }

    public IMetaTileEntity getMetaTileEntity() {
        return null;
    }

    protected void createIc2Sink() {
        if (this.ic2EnergySink == null && this.isServerSide() && this.shouldJoinIc2Enet()) {
            this.ic2EnergySink = new TileIC2EnergySink((IGregTechTileEntity)((Object)this));
        }
    }

    public void doEnetUpdate() {
        this.leaveEnet();
        this.joinEnet();
    }

    protected void joinEnet() {
        if (this.joinedIc2Enet || !this.shouldJoinIc2Enet()) {
            return;
        }
        if (this.ic2EnergySink == null) {
            this.createIc2Sink();
        }
        if (this.ic2EnergySink != null) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this.ic2EnergySink));
            this.joinedIc2Enet = true;
        }
    }

    protected void leaveEnet() {
        if (this.joinedIc2Enet && this.ic2EnergySink != null && this.isServerSide()) {
            this.joinedIc2Enet = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this.ic2EnergySink));
        }
    }

    public boolean shouldJoinIc2Enet() {
        IMetaTileEntity meta = this.getMetaTileEntity();
        return meta != null && meta.shouldJoinIc2Enet();
    }
}

