/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.items.GT_Tool_Item;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_Spray_Ice_Item
extends GT_Tool_Item {
    public GT_Spray_Ice_Item(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage) {
        super(aUnlocalized, aEnglish, "Very effective against Slimes", aMaxDamage, aEntityDamage, true);
        for (Object tName : Arrays.asList(OrePrefixes.bucket.get(Materials.Water), OrePrefixes.cell.get(Materials.Water), OrePrefixes.capsule.get(Materials.Water))) {
            GT_ModHandler.addShapelessCraftingRecipe(new ItemStack(Blocks.ice, 1, 0), new Object[]{new ItemStack((Item)this, 1, Short.MAX_VALUE), tName});
        }
    }

    public boolean onItemUseFirst(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        super.onItemUseFirst(aStack, aPlayer, aWorld, aX, aY, aZ, aSide, hitX, hitY, hitZ);
        if (aWorld.isRemote) {
            return false;
        }
        Block aBlock = aWorld.getBlock(aX += ForgeDirection.getOrientation((int)aSide).offsetX, aY += ForgeDirection.getOrientation((int)aSide).offsetY, aZ += ForgeDirection.getOrientation((int)aSide).offsetZ);
        if (aBlock == null) {
            return false;
        }
        byte aMeta = (byte)aWorld.getBlockMetadata(aX, aY, aZ);
        if (aBlock == Blocks.water || aBlock == Blocks.flowing_water) {
            if (aMeta == 0 && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, (EntityLivingBase)aPlayer)) {
                GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(102), 1.0f, -1.0f, aX, aY, aZ);
                aWorld.setBlock(aX, aY, aZ, Blocks.ice, 0, 3);
                return true;
            }
            return false;
        }
        if (aBlock == Blocks.lava || aBlock == Blocks.flowing_lava) {
            if (aMeta == 0 && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, (EntityLivingBase)aPlayer)) {
                GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(102), 1.0f, -1.0f, aX, aY, aZ);
                aWorld.setBlock(aX, aY, aZ, Blocks.obsidian, 0, 3);
                return true;
            }
            return false;
        }
        return false;
    }
}

