/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.IProjectileItem;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class GT_Generic_Item
extends Item
implements IProjectileItem {
    private final String mName;
    private final String mTooltip;
    protected IIcon mIcon;

    public GT_Generic_Item(String aUnlocalized, String aEnglish, String aEnglishTooltip) {
        this(aUnlocalized, aEnglish, aEnglishTooltip, true);
    }

    public GT_Generic_Item(String aUnlocalized, String aEnglish, String aEnglishTooltip, boolean aWriteToolTipIntoLangFile) {
        this.mName = "gt." + aUnlocalized;
        GT_LanguageManager.addStringLocalization(this.mName + ".name", aEnglish);
        if (GT_Utility.isStringValid(aEnglishTooltip)) {
            this.mTooltip = this.mName + ".tooltip_main";
            GT_LanguageManager.addStringLocalization(this.mTooltip, aEnglishTooltip, aWriteToolTipIntoLangFile);
        } else {
            this.mTooltip = null;
        }
        this.setCreativeTab(GregTech_API.TAB_GREGTECH);
        GameRegistry.registerItem((Item)this, (String)this.mName, (String)"gregtech");
        BlockDispenser.dispenseBehaviorRegistry.putObject((Object)this, (Object)new GT_Item_Dispense());
    }

    public final Item setUnlocalizedName(String aName) {
        return this;
    }

    public final String getUnlocalizedName() {
        return this.mName;
    }

    public String getUnlocalizedName(ItemStack aStack) {
        return this.getHasSubtypes() ? this.mName + "." + this.getDamage(aStack) : this.mName;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aIconRegister) {
        this.mIcon = aIconRegister.registerIcon("gregtech:" + (GT_Config.troll ? "troll" : this.mName));
    }

    public boolean doesSneakBypassUse(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        return true;
    }

    public IIcon getIconFromDamage(int par1) {
        return this.mIcon;
    }

    public int getTier(ItemStack aStack) {
        return 0;
    }

    public void addInformation(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        if (this.getMaxDamage() > 0 && !this.getHasSubtypes()) {
            aList.add(aStack.getMaxDamage() - this.getDamage(aStack) + " / " + aStack.getMaxDamage());
        }
        if (this.mTooltip != null) {
            aList.add(GT_LanguageManager.getTranslation(this.mTooltip));
        }
        if (GT_ModHandler.isElectricItem(aStack)) {
            aList.add("Tier: " + this.getTier(aStack));
        }
        this.addAdditionalToolTips(aList, aStack, aPlayer);
    }

    protected void addAdditionalToolTips(List aList, ItemStack aStack, EntityPlayer aPlayer) {
    }

    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        this.isItemStackUsable(aStack);
    }

    public boolean isItemStackUsable(ItemStack aStack) {
        return true;
    }

    public ItemStack onDispense(IBlockSource aSource, ItemStack aStack) {
        EnumFacing enumfacing = BlockDispenser.func_149937_b((int)aSource.getBlockMetadata());
        IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)aSource);
        ItemStack itemstack1 = aStack.splitStack(1);
        BehaviorDefaultDispenseItem.doDispense((World)aSource.getWorld(), (ItemStack)itemstack1, (int)6, (EnumFacing)enumfacing, (IPosition)iposition);
        return aStack;
    }

    @Override
    public EntityArrow getProjectile(SubTag aProjectileType, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        return null;
    }

    @Override
    public EntityArrow getProjectile(SubTag aProjectileType, ItemStack aStack, World aWorld, EntityLivingBase aEntity, float aSpeed) {
        return null;
    }

    @Override
    public boolean hasProjectile(SubTag aProjectileType, ItemStack aStack) {
        return false;
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    public boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack) != null;
    }

    public String trans(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_" + aKey, aEnglish, false);
    }

    public static class GT_Item_Dispense
    extends BehaviorProjectileDispense {
        public ItemStack dispenseStack(IBlockSource aSource, ItemStack aStack) {
            return ((GT_Generic_Item)aStack.getItem()).onDispense(aSource, aStack);
        }

        protected IProjectile getProjectileEntity(World aWorld, IPosition aPosition) {
            return null;
        }
    }
}

