/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyMutation;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.GenericRatings;
import forestry.core.genetics.IndividualLiving;
import forestry.core.utils.StringUtil;
import forestry.lepidopterology.genetics.ButterflyGenome;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.EntityCreature;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class Butterfly
extends IndividualLiving
implements IButterfly {
    private static final Random rand = new Random();
    private IButterflyGenome genome;
    private IButterflyGenome mate;

    public Butterfly(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Butterfly(IButterflyGenome genome) {
        super(genome.getLifespan());
        this.genome = genome;
    }

    @Override
    public void addTooltip(List<String> list) {
        IAlleleButterflySpecies primary = this.genome.getPrimary();
        IAlleleButterflySpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumButterflyChromosome.SPECIES)) {
            list.add(EnumChatFormatting.BLUE + StringUtil.localize("butterflies.hybrid").replaceAll("%PRIMARY", primary.getName()).replaceAll("%SECONDARY", secondary.getName()));
        }
        if (this.getMate() != null) {
            list.add(EnumChatFormatting.RED + StringUtil.localize("gui.fecundated").toUpperCase(Locale.ENGLISH));
        }
        list.add(EnumChatFormatting.YELLOW + this.genome.getActiveAllele(EnumButterflyChromosome.SIZE).getName());
        list.add(EnumChatFormatting.DARK_GREEN + this.genome.getActiveAllele(EnumButterflyChromosome.SPEED).getName());
        list.add(this.genome.getActiveAllele(EnumButterflyChromosome.LIFESPAN).getName() + ' ' + StringUtil.localize("gui.life"));
        IAlleleTolerance tempTolerance = (IAlleleTolerance)this.getGenome().getActiveAllele(EnumButterflyChromosome.TEMPERATURE_TOLERANCE);
        list.add(EnumChatFormatting.GREEN + "T: " + AlleleManager.climateHelper.toDisplay(this.genome.getPrimary().getTemperature()) + " / " + tempTolerance.getName());
        IAlleleTolerance humidTolerance = (IAlleleTolerance)this.getGenome().getActiveAllele(EnumButterflyChromosome.TEMPERATURE_TOLERANCE);
        list.add(EnumChatFormatting.GREEN + "H: " + AlleleManager.climateHelper.toDisplay(this.genome.getPrimary().getHumidity()) + " / " + humidTolerance.getName());
        list.add(EnumChatFormatting.RED + GenericRatings.rateActivityTime(this.genome.getNocturnal(), this.genome.getPrimary().isNocturnal()));
        if (this.genome.getTolerantFlyer()) {
            list.add(EnumChatFormatting.WHITE + StringUtil.localize("gui.flyer.tooltip"));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound == null) {
            this.genome = ButterflyManager.butterflyRoot.templateAsGenome(ButterflyManager.butterflyRoot.getDefaultTemplate());
            return;
        }
        super.readFromNBT(nbttagcompound);
        this.genome = nbttagcompound.func_74764_b("Genome") ? new ButterflyGenome(nbttagcompound.func_74775_l("Genome")) : ButterflyManager.butterflyRoot.templateAsGenome(ButterflyManager.butterflyRoot.getDefaultTemplate());
        if (nbttagcompound.func_74764_b("Mate")) {
            this.mate = new ButterflyGenome(nbttagcompound.func_74775_l("Mate"));
        }
    }

    @Override
    public IButterfly copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Butterfly(nbttagcompound);
    }

    @Override
    public IButterflyGenome getGenome() {
        return this.genome;
    }

    @Override
    public IButterflyGenome getMate() {
        return this.mate;
    }

    @Override
    public boolean canSpawn(World world, double x, double y, double z) {
        block3: {
            boolean noneMatched;
            block5: {
                BiomeGenBase biome;
                block4: {
                    if (!this.canFly(world)) {
                        return false;
                    }
                    biome = world.getBiomeGenForCoordsBody((int)x, (int)z);
                    if (this.getGenome().getPrimary().getSpawnBiomes().size() <= 0) break block3;
                    noneMatched = true;
                    if (!this.getGenome().getPrimary().strictSpawnMatch()) break block4;
                    BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
                    if (types.length != 1 || !this.getGenome().getPrimary().getSpawnBiomes().contains(types[0])) break block5;
                    noneMatched = false;
                    break block5;
                }
                for (BiomeDictionary.Type type : this.getGenome().getPrimary().getSpawnBiomes()) {
                    if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)type)) continue;
                    noneMatched = false;
                    break;
                }
            }
            if (noneMatched) {
                return false;
            }
        }
        return this.isAcceptedEnvironment(world, x, y, z);
    }

    @Override
    public boolean canTakeFlight(World world, double x, double y, double z) {
        if (!this.canFly(world)) {
            return false;
        }
        return this.isAcceptedEnvironment(world, x, y, z);
    }

    private boolean canFly(World world) {
        if (world.func_72896_J() && !this.getGenome().getTolerantFlyer()) {
            return false;
        }
        return this.isActiveThisTime(world.func_72935_r());
    }

    @Override
    public boolean isAcceptedEnvironment(World world, double x, double y, double z) {
        return this.isAcceptedEnvironment(world, (int)x, (int)y, (int)z);
    }

    private boolean isAcceptedEnvironment(World world, int x, int y, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        EnumTemperature biomeTemperature = EnumTemperature.getFromBiome(biome, x, y, z);
        EnumHumidity biomeHumidity = EnumHumidity.getFromValue(biome.field_76751_G);
        return AlleleManager.climateHelper.isWithinLimits(biomeTemperature, biomeHumidity, this.getGenome().getPrimary().getTemperature(), this.getGenome().getToleranceTemp(), this.getGenome().getPrimary().getHumidity(), this.getGenome().getToleranceHumid());
    }

    @Override
    public IButterfly spawnCaterpillar(IButterflyNursery nursery) {
        IChromosome[] mutated2;
        if (this.mate == null) {
            return null;
        }
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated1 = Butterfly.mutateSpecies(nursery, this.genome, this.mate);
        if (mutated1 != null) {
            parent1 = mutated1;
        }
        if ((mutated2 = Butterfly.mutateSpecies(nursery, this.mate, this.genome)) != null) {
            parent2 = mutated2;
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome(rand, parent1[i], parent2[i]);
        }
        return new Butterfly(new ButterflyGenome(chromosomes));
    }

    private static IChromosome[] mutateSpecies(IButterflyNursery nursery, IGenome genomeOne, IGenome genomeTwo) {
        IGenome genome1;
        IGenome genome0;
        IAllele allele1;
        IAllele allele0;
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (rand.nextBoolean()) {
            allele0 = parent1[EnumButterflyChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent2[EnumButterflyChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = parent2[EnumButterflyChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent1[EnumButterflyChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        for (IButterflyMutation mutation : ButterflyManager.butterflyRoot.getMutations(true)) {
            float chance = mutation.getChance(nursery, allele0, allele1, genome0, genome1, nursery);
            if (!(chance > rand.nextFloat() * 100.0f)) continue;
            return ButterflyManager.butterflyRoot.templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    private boolean isActiveThisTime(boolean isDayTime) {
        if (this.getGenome().getNocturnal()) {
            return true;
        }
        return isDayTime != this.getGenome().getPrimary().isNocturnal();
    }

    @Override
    public float getSize() {
        return this.getGenome().getSize();
    }

    @Override
    public void mate(IIndividual individual) {
        if (!(individual instanceof IButterfly)) {
            return;
        }
        this.mate = ((IButterfly)individual).getGenome();
    }

    @Override
    public ItemStack[] getLootDrop(IEntityButterfly entity, boolean playerKill, int lootLevel) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        EntityCreature creature = entity.getEntity();
        float metabolism = (float)this.getGenome().getMetabolism() / 10.0f;
        for (Map.Entry<ItemStack, Float> entry : this.getGenome().getPrimary().getButterflyLoot().entrySet()) {
            if (!(creature.field_70170_p.field_73012_v.nextFloat() < entry.getValue().floatValue() * metabolism)) continue;
            drop.add(entry.getKey().func_77946_l());
        }
        return drop.toArray(new ItemStack[drop.size()]);
    }

    @Override
    public ItemStack[] getCaterpillarDrop(IButterflyNursery nursery, boolean playerKill, int lootLevel) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        float metabolism = (float)this.getGenome().getMetabolism() / 10.0f;
        for (Map.Entry<ItemStack, Float> entry : this.getGenome().getPrimary().getCaterpillarLoot().entrySet()) {
            if (!(rand.nextFloat() < entry.getValue().floatValue() * metabolism)) continue;
            drop.add(entry.getKey().func_77946_l());
        }
        return drop.toArray(new ItemStack[drop.size()]);
    }
}

