/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.network.packets;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IActivatable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketActiveUpdate
extends PacketCoordinates
implements IForestryPacketClient {
    private boolean active;

    public PacketActiveUpdate() {
    }

    public PacketActiveUpdate(IActivatable tile) {
        super(tile.getCoordinates());
        this.active = tile.isActive();
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.TILE_FORESTRY_ACTIVE;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.active);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.active = data.readBoolean();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) {
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof IActivatable) {
            ((IActivatable)tile).setActive(this.active);
        }
    }
}

