/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.tiles;

import forestry.api.mail.IStamps;
import forestry.api.mail.PostManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.mail.gui.ContainerStampCollector;
import forestry.mail.gui.GuiStampCollector;
import forestry.mail.inventory.InventoryStampCollector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class TileStampCollector
extends TileBase
implements IInventory {
    public TileStampCollector() {
        super("philatelist");
        this.setInternalInventory(new InventoryStampCollector(this));
    }

    @Override
    public void updateServerSide() {
        if (!this.updateOnInterval(20)) {
            return;
        }
        ItemStack stamp = null;
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(0) == null) {
            stamp = PostManager.postRegistry.getPostOffice(this.worldObj).getAnyStamp(1);
        } else {
            ItemStack filter = inventory.getStackInSlot(0);
            if (filter.getItem() instanceof IStamps) {
                stamp = PostManager.postRegistry.getPostOffice(this.worldObj).getAnyStamp(((IStamps)filter.getItem()).getPostage(filter), 1);
            }
        }
        if (stamp == null) {
            return;
        }
        InventoryUtil.stowInInventory(stamp, (IInventory)inventory, true, 1, 27);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiStampCollector(player.inventory, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerStampCollector(player.inventory, this);
    }
}

