/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.inventory;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.api.mail.ILetter;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemWithGui;
import forestry.core.utils.SlotUtil;
import forestry.mail.Letter;
import forestry.mail.LetterProperties;
import forestry.mail.items.ItemStamps;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemInventoryLetter
extends ItemInventory
implements IErrorSource,
IHintSource {
    private ILetter letter;

    public ItemInventoryLetter(EntityPlayer player, ItemStack itemstack) {
        super(player, 0, itemstack);
    }

    public ILetter getLetter() {
        return this.letter;
    }

    public void onLetterClosed() {
        ItemStack parent = this.getParent();
        if (parent == null) {
            return;
        }
        LetterProperties.closeLetter(parent, this.letter);
    }

    public void onLetterOpened() {
        ItemStack parent = this.getParent();
        if (parent == null) {
            return;
        }
        LetterProperties.openLetter(parent);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound == null) {
            return;
        }
        this.letter = new Letter(nbttagcompound);
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        ItemStack result = this.letter.decrStackSize(i, j);
        this.letter.writeToNBT(this.getParent().getTagCompound());
        return result;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.letter.setInventorySlotContents(i, itemstack);
        this.letter.writeToNBT(this.getParent().getTagCompound());
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.letter.getStackInSlot(i);
    }

    @Override
    public int getSizeInventory() {
        return this.letter.getSizeInventory();
    }

    @Override
    public String getInventoryName() {
        return this.letter.getInventoryName();
    }

    @Override
    public int getInventoryStackLimit() {
        return this.letter.getInventoryStackLimit();
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.letter.isUseableByPlayer(entityplayer);
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.letter.getStackInSlotOnClosing(slot);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (this.letter.isProcessed()) {
            return false;
        }
        if (SlotUtil.isSlotInRange(slotIndex, 18, 4)) {
            Item item = itemStack.getItem();
            return item instanceof ItemStamps;
        }
        if (SlotUtil.isSlotInRange(slotIndex, 0, 18)) {
            return !(itemStack.getItem() instanceof ItemWithGui);
        }
        return false;
    }

    @Override
    public ImmutableSet<IErrorState> getErrorStates() {
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        if (!this.letter.hasRecipient()) {
            errorStates.add((Object)EnumErrorCode.NO_RECIPIENT);
        }
        if (!this.letter.isProcessed() && !this.letter.isPostPaid()) {
            errorStates.add((Object)EnumErrorCode.NOT_POST_PAID);
        }
        return errorStates.build();
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"letter");
    }
}

