/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpeciesCustom;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.core.genetics.alleles.AlleleSpecies;
import java.awt.Color;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public class AlleleButterflySpecies
extends AlleleSpecies
implements IAlleleButterflySpeciesCustom {
    private final String texture;
    private final Color serumColour;
    private float rarity = 0.1f;
    private float flightDistance = 5.0f;
    private boolean isActualNocturnal = false;
    private final EnumSet<BiomeDictionary.Type> spawnBiomes = EnumSet.noneOf(BiomeDictionary.Type.class);
    private final Map<ItemStack, Float> butterflyLoot = new HashMap<ItemStack, Float>();
    private final Map<ItemStack, Float> caterpillarLoot = new HashMap<ItemStack, Float>();

    public AlleleButterflySpecies(String uid, String unlocalizedName, String authority, String unlocalizedDescription, String texturePath, boolean isDominant, IClassification branch, String binomial, Color serumColour) {
        super(uid, unlocalizedName, authority, unlocalizedDescription, isDominant, branch, binomial);
        this.serumColour = serumColour;
        this.texture = texturePath;
    }

    @Override
    public IButterflyRoot getRoot() {
        return ButterflyManager.butterflyRoot;
    }

    @Override
    public AlleleButterflySpecies setRarity(float rarity) {
        this.rarity = rarity;
        return this;
    }

    @Override
    public AlleleButterflySpecies setFlightDistance(float flightDistance) {
        this.flightDistance = flightDistance;
        return this;
    }

    @Override
    public AlleleButterflySpecies setNocturnal() {
        this.isActualNocturnal = true;
        return this;
    }

    public AlleleButterflySpecies addSpawnBiomes(EnumSet<BiomeDictionary.Type> biomeTags) {
        this.spawnBiomes.addAll(biomeTags);
        return this;
    }

    public AlleleButterflySpecies addSpawnBiome(BiomeDictionary.Type biomeTag) {
        this.spawnBiomes.add(biomeTag);
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return null;
    }

    @Override
    public String getEntityTexture() {
        return this.texture;
    }

    @Override
    public EnumSet<BiomeDictionary.Type> getSpawnBiomes() {
        return this.spawnBiomes;
    }

    @Override
    public boolean strictSpawnMatch() {
        return false;
    }

    @Override
    public int getComplexity() {
        return (int)((double)(1.35f / this.rarity) * 1.5);
    }

    @Override
    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        if (itemstack.getItem() == Items.glass_bottle) {
            return 0.9f;
        }
        for (ItemStack stack : this.butterflyLoot.keySet()) {
            if (!stack.isItemEqual(itemstack)) continue;
            return 1.0f;
        }
        for (ItemStack stack : this.caterpillarLoot.keySet()) {
            if (!stack.isItemEqual(itemstack)) continue;
            return 1.0f;
        }
        return super.getResearchSuitability(itemstack);
    }

    @Override
    public ItemStack[] getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        return new ItemStack[]{this.getRoot().getMemberStack(individual.copy(), EnumFlutterType.SERUM.ordinal())};
    }

    @Override
    public boolean isSecret() {
        return this.rarity < 0.8f;
    }

    @Override
    public float getRarity() {
        return this.rarity;
    }

    @Override
    public float getFlightDistance() {
        return this.flightDistance;
    }

    @Override
    public boolean isNocturnal() {
        return this.isActualNocturnal;
    }

    @Override
    public Map<ItemStack, Float> getButterflyLoot() {
        return this.butterflyLoot;
    }

    @Override
    public Map<ItemStack, Float> getCaterpillarLoot() {
        return this.caterpillarLoot;
    }

    @Override
    public int getIconColour(int renderPass) {
        if (renderPass > 0) {
            return 0xFFFFFF;
        }
        return this.serumColour.getRGB() & 0xFFFFFF;
    }
}

