/*
 * Decompiled with CFR 0.152.
 */
package forestry.food.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.food.IBeverageEffect;
import forestry.core.config.Config;
import forestry.core.items.ItemForestryFood;
import forestry.core.items.ItemOverlay;
import forestry.food.BeverageEffect;
import forestry.food.items.EnumBeverage;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBeverage
extends ItemForestryFood {
    public final IBeverageInfo[] beverages;

    public ItemBeverage() {
        super(1, 0.2f);
        this.setMaxStackSize(8);
        this.beverages = EnumBeverage.VALUES;
    }

    public boolean getShareTag() {
        return true;
    }

    public ItemStack onEaten(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        List<IBeverageEffect> effects = BeverageEffect.loadEffects(itemstack);
        ItemStack container = new ItemStack(Items.glass_bottle, 1);
        --itemstack.stackSize;
        if (!entityplayer.inventory.addItemStackToInventory(container)) {
            entityplayer.dropPlayerItemWithRandomChoice(container, false);
        } else {
            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, container);
        }
        entityplayer.inventory.markDirty();
        entityplayer.getFoodStats().func_151686_a((ItemFood)this, itemstack);
        world.playSoundAtEntity((Entity)entityplayer, "random.burp", 0.5f, world.rand.nextFloat() * 0.1f + 0.9f);
        if (world.isRemote) {
            return itemstack;
        }
        for (IBeverageEffect effect : effects) {
            effect.doEffect(world, entityplayer);
        }
        return itemstack;
    }

    public int func_150905_g(ItemStack itemstack) {
        int meta = itemstack.getItemDamage();
        IBeverageInfo beverage = this.beverages[meta];
        return beverage.getHeal();
    }

    public float func_150906_h(ItemStack itemstack) {
        int meta = itemstack.getItemDamage();
        IBeverageInfo beverage = this.beverages[meta];
        return beverage.getSaturation();
    }

    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 32;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.drink;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        int meta = itemstack.getItemDamage();
        IBeverageInfo beverage = this.beverages[meta];
        if (entityplayer.canEat(beverage.isAlwaysEdible())) {
            entityplayer.setItemInUse(itemstack, this.getMaxItemUseDuration(itemstack));
        }
        return itemstack;
    }

    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < this.beverages.length; ++i) {
            if (!Config.isDebug && this.beverages[i].isSecret()) continue;
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }

    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        List<IBeverageEffect> effects = BeverageEffect.loadEffects(itemstack);
        for (IBeverageEffect effect : effects) {
            if (effect.getDescription() == null) continue;
            list.add(effect.getDescription());
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        return super.getUnlocalizedName(stack) + "." + this.beverages[stack.getItemDamage()].getName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        for (IBeverageInfo info : this.beverages) {
            info.registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int i, int j) {
        if (j > 0 && this.beverages[i].getSecondaryColor() != 0) {
            return this.beverages[i].getIconBottle();
        }
        return this.beverages[i].getIconContents();
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public int getColorFromItemStack(ItemStack itemstack, int j) {
        if (j == 0 || this.beverages[itemstack.getItemDamage()].getSecondaryColor() == 0) {
            return this.beverages[itemstack.getItemDamage()].getPrimaryColor();
        }
        return this.beverages[itemstack.getItemDamage()].getSecondaryColor();
    }

    public ItemStack get(EnumBeverage beverage, int amount) {
        return new ItemStack((Item)this, amount, beverage.ordinal());
    }

    public static interface IBeverageInfo
    extends ItemOverlay.IOverlayInfo {
        public int getHeal();

        public float getSaturation();

        public boolean isAlwaysEdible();

        public void registerIcons(IIconRegister var1);

        public IIcon getIconBottle();

        public IIcon getIconContents();
    }
}

