/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.render;

import forestry.core.utils.ItemStackUtil;
import forestry.farming.blocks.BlockFarm;
import forestry.farming.render.EnumFarmBlockTexture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderFarmItem
implements IItemRenderer {
    private static void renderFarmBlock(RenderBlocks render, ItemStack item, float translateX, float translateY, float translateZ) {
        Tessellator tessellator = Tessellator.instance;
        BlockFarm block = (BlockFarm)ItemStackUtil.getBlock(item);
        if (block == null) {
            return;
        }
        block.setBlockBoundsForItemRender();
        render.setRenderBoundsFromBlock((Block)block);
        EnumFarmBlockTexture type = EnumFarmBlockTexture.getFromCompound(item.getTagCompound());
        GL11.glTranslatef((float)translateX, (float)translateY, (float)translateZ);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        render.renderFaceYNeg((Block)block, 0.0, 0.0, 0.0, BlockFarm.getBlockTextureForSide(type, 0));
        render.renderFaceYNeg((Block)block, 0.0, 0.0, 0.0, BlockFarm.getOverlayTextureForBlock(0, item.getItemDamage()));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        render.renderFaceYPos((Block)block, 0.0, 0.0, 0.0, BlockFarm.getBlockTextureForSide(type, 1));
        render.renderFaceYPos((Block)block, 0.0, 0.0, 0.0, BlockFarm.getOverlayTextureForBlock(1, item.getItemDamage()));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        render.renderFaceZNeg((Block)block, 0.0, 0.0, 0.0, BlockFarm.getBlockTextureForSide(type, 2));
        render.renderFaceZNeg((Block)block, 0.0, 0.0, 0.0, BlockFarm.getOverlayTextureForBlock(2, item.getItemDamage()));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        render.renderFaceZPos((Block)block, 0.0, 0.0, 0.0, BlockFarm.getBlockTextureForSide(type, 3));
        render.renderFaceZPos((Block)block, 0.0, 0.0, 0.0, BlockFarm.getOverlayTextureForBlock(3, item.getItemDamage()));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        render.renderFaceXNeg((Block)block, 0.0, 0.0, 0.0, BlockFarm.getBlockTextureForSide(type, 4));
        render.renderFaceXNeg((Block)block, 0.0, 0.0, 0.0, BlockFarm.getOverlayTextureForBlock(4, item.getItemDamage()));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        render.renderFaceXPos((Block)block, 0.0, 0.0, 0.0, BlockFarm.getBlockTextureForSide(type, 5));
        render.renderFaceXPos((Block)block, 0.0, 0.0, 0.0, BlockFarm.getOverlayTextureForBlock(5, item.getItemDamage()));
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        switch (type) {
            case ENTITY: {
                RenderFarmItem.renderFarmBlock((RenderBlocks)data[0], item, -0.5f, -0.5f, -0.5f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: {
                RenderFarmItem.renderFarmBlock((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
            case INVENTORY: {
                RenderFarmItem.renderFarmBlock((RenderBlocks)data[0], item, -0.5f, -0.5f, -0.5f);
                break;
            }
        }
        GL11.glPopAttrib();
    }
}

