/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.Farmables;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.FarmLogicArboreal;
import forestry.farming.logic.FarmableReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class FarmLogicShroom
extends FarmLogicArboreal {
    public FarmLogicShroom(IFarmHousing housing) {
        super(housing, new ItemStack((Block)Blocks.mycelium), new ItemStack((Block)Blocks.mycelium), (Iterable<IFarmable>)Farmables.farmables.get(FarmableReference.Shroom.get()));
    }

    @Override
    public String getName() {
        if (this.isManual) {
            return "Manual Shroom Farm";
        }
        return "Managed Shroom Farm";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Blocks.red_mushroom.getBlockTextureFromSide(0);
    }

    @Override
    public int getFertilizerConsumption() {
        return 20;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(80.0f * hydrationModifier);
    }

    @Override
    public Collection<ItemStack> collect() {
        List products = this.produce;
        this.produce = new ArrayList();
        return products;
    }
}

