/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.core.blocks.BlockSoil;
import forestry.core.proxy.Proxies;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.Crop;
import forestry.plugins.PluginCore;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CropPeat
extends Crop {
    public CropPeat(World world, Vect position) {
        super(world, position);
    }

    @Override
    protected boolean isCrop(Vect pos) {
        Block block = this.getBlock(pos);
        if (!(block instanceof BlockSoil)) {
            return false;
        }
        BlockSoil blockSoil = (BlockSoil)block;
        BlockSoil.SoilType soilType = blockSoil.getTypeFromMeta(this.getBlockMeta(pos));
        return soilType == BlockSoil.SoilType.PEAT;
    }

    @Override
    protected Collection<ItemStack> harvestBlock(Vect pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(PluginCore.items.peat.getItemStack());
        Proxies.common.addBlockDestroyEffects(this.world, pos.x, pos.y, pos.z, this.world.getBlock(pos.x, pos.y, pos.z), 0);
        this.setBlock(pos, Blocks.dirt, 0);
        return drops;
    }
}

