/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.core.proxy.Proxies;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.Crop;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CropBasicAgriCraft
extends Crop {
    private final Block block;
    private final int meta;

    public CropBasicAgriCraft(World world, Block block, int meta, Vect position) {
        super(world, position);
        this.block = block;
        this.meta = meta;
    }

    @Override
    protected boolean isCrop(Vect pos) {
        return this.getBlock(pos) == this.block && this.getBlockMeta(pos) == this.meta;
    }

    @Override
    protected Collection<ItemStack> harvestBlock(Vect pos) {
        ArrayList harvest = this.block.getDrops(this.world, pos.x, pos.y, pos.z, this.meta, 0);
        if (harvest.size() > 1) {
            harvest.remove(1);
        }
        harvest.remove(0);
        Proxies.common.addBlockDestroyEffects(this.world, pos.x, pos.y, pos.z, Blocks.melon_block, 0);
        this.world.setBlockMetadataWithNotify(pos.x, pos.y, pos.z, 0, 2);
        harvest.removeAll(Collections.singleton(null));
        return harvest;
    }

    public String toString() {
        return String.format("CropBasicAgriCraft [ position: [ %s ]; block: %s; meta: %s ]", this.position.toString(), this.block.getUnlocalizedName(), this.meta);
    }
}

