/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.core.IErrorLogic;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IVariableFermentable;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.gui.ContainerFermenter;
import forestry.factory.gui.GuiFermenter;
import forestry.factory.inventory.InventoryFermenter;
import forestry.factory.recipes.FermenterRecipeManager;
import forestry.factory.triggers.FactoryTriggers;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileFermenter
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
IFluidHandler {
    private final FilteredTank resourceTank;
    private final FilteredTank productTank;
    private final TankManager tankManager;
    private IFermenterRecipe currentRecipe;
    private float currentResourceModifier;
    private int fermentationTime = 0;
    private int fermentationTotalTime = 0;
    private int fuelBurnTime = 0;
    private int fuelTotalTime = 0;
    private int fuelCurrentFerment = 0;

    public TileFermenter() {
        super("fermenter", 2000, 8000);
        this.setEnergyPerWorkCycle(4200);
        this.setInternalInventory(new InventoryFermenter(this));
        this.resourceTank = new FilteredTank(10000, FermenterRecipeManager.recipeFluidInputs);
        this.resourceTank.tankMode = StandardTank.TankMode.INPUT;
        this.productTank = new FilteredTank(10000, FermenterRecipeManager.recipeFluidOutputs);
        this.productTank.tankMode = StandardTank.TankMode.OUTPUT;
        this.tankManager = new TankManager(this, this.resourceTank, this.productTank);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("FermentationTime", this.fermentationTime);
        nbttagcompound.setInteger("FermentationTotalTime", this.fermentationTotalTime);
        nbttagcompound.setInteger("FuelBurnTime", this.fuelBurnTime);
        nbttagcompound.setInteger("FuelTotalTime", this.fuelTotalTime);
        nbttagcompound.setInteger("FuelCurrentFerment", this.fuelCurrentFerment);
        this.tankManager.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.fermentationTime = nbttagcompound.getInteger("FermentationTime");
        this.fermentationTotalTime = nbttagcompound.getInteger("FermentationTotalTime");
        this.fuelBurnTime = nbttagcompound.getInteger("FuelBurnTime");
        this.fuelTotalTime = nbttagcompound.getInteger("FuelTotalTime");
        this.fuelCurrentFerment = nbttagcompound.getInteger("FuelCurrentFerment");
        this.tankManager.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 4);
            FluidStack fluidStack = this.productTank.getFluid();
            if (fluidStack != null) {
                FluidHelper.fillContainers(this.tankManager, (IInventory)this, 3, 2, fluidStack.getFluid());
            }
        }
    }

    @Override
    public boolean workCycle() {
        int fermented = Math.min(this.fermentationTime, this.fuelCurrentFerment);
        int productAmount = Math.round((float)fermented * this.currentRecipe.getModifier() * this.currentResourceModifier);
        this.productTank.fill(new FluidStack(this.currentRecipe.getOutput(), productAmount), true);
        --this.fuelBurnTime;
        this.resourceTank.drain(this.fuelCurrentFerment, true);
        this.fermentationTime -= this.fuelCurrentFerment;
        if (this.fermentationTime > 0) {
            return false;
        }
        this.currentRecipe = null;
        return true;
    }

    private void checkRecipe() {
        if (this.currentRecipe != null) {
            return;
        }
        ItemStack resource = this.getStackInSlot(0);
        FluidStack fluid = this.resourceTank.getFluid();
        this.currentRecipe = FermenterRecipeManager.findMatchingRecipe(resource, fluid);
        this.fermentationTime = this.currentRecipe == null ? 0 : this.currentRecipe.getFermentationValue();
        this.fermentationTotalTime = this.fermentationTime;
        if (this.currentRecipe != null) {
            this.currentResourceModifier = TileFermenter.determineResourceMod(resource);
            this.decrStackSize(0, 1);
        }
    }

    private void checkFuel() {
        if (this.fuelBurnTime > 0) {
            return;
        }
        ItemStack fuel = this.getStackInSlot(1);
        if (fuel == null) {
            return;
        }
        FermenterFuel fermenterFuel = FuelManager.fermenterFuel.get(fuel);
        if (fermenterFuel == null) {
            return;
        }
        this.fuelBurnTime = this.fuelTotalTime = fermenterFuel.burnDuration;
        this.fuelCurrentFerment = fermenterFuel.fermentPerCycle;
        this.decrStackSize(1, 1);
    }

    private static float determineResourceMod(ItemStack itemstack) {
        if (!(itemstack.getItem() instanceof IVariableFermentable)) {
            return 1.0f;
        }
        return ((IVariableFermentable)itemstack.getItem()).getFermentationModifier(itemstack);
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        ItemStack fermentationStack = this.getStackInSlot(0);
        if (fermentationStack == null) {
            return false;
        }
        return (float)fermentationStack.stackSize / (float)fermentationStack.getMaxStackSize() > percentage;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        ItemStack fuelStack = this.getStackInSlot(1);
        if (fuelStack == null) {
            return false;
        }
        return (float)fuelStack.stackSize / (float)fuelStack.getMaxStackSize() > percentage;
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        this.checkFuel();
        boolean hasRecipe = this.currentRecipe != null;
        boolean hasFuel = this.fuelBurnTime > 0;
        boolean hasResource = this.fermentationTime > 0 || this.getStackInSlot(0) != null;
        boolean hasFluidResource = this.resourceTank.canDrain(this.fuelCurrentFerment);
        boolean hasFluidSpace = true;
        if (hasRecipe) {
            int fermented = Math.min(this.fermentationTime, this.fuelCurrentFerment);
            int productAmount = Math.round((float)fermented * this.currentRecipe.getModifier() * this.currentResourceModifier);
            hasFluidSpace = this.productTank.canFill(this.currentRecipe.getOutput(), productAmount);
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!hasFuel, EnumErrorCode.NO_FUEL);
        errorLogic.setCondition(!hasResource, EnumErrorCode.NO_RESOURCE);
        errorLogic.setCondition(!hasFluidResource, EnumErrorCode.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(!hasFluidSpace, EnumErrorCode.NO_SPACE_TANK);
        return hasRecipe && hasFuel && hasResource && hasFluidResource && hasFluidSpace;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.fuelTotalTime == 0) {
            return 0;
        }
        return this.fuelBurnTime * i / this.fuelTotalTime;
    }

    public int getFermentationProgressScaled(int i) {
        if (this.fermentationTotalTime == 0) {
            return 0;
        }
        return this.fermentationTime * i / this.fermentationTotalTime;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return new TankRenderInfo((IFluidTank)this.productTank);
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fuelBurnTime = j;
                break;
            }
            case 1: {
                this.fuelTotalTime = j;
                break;
            }
            case 2: {
                this.fermentationTime = j;
                break;
            }
            case 3: {
                this.fermentationTotalTime = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.sendProgressBarUpdate(container, 0, this.fuelBurnTime);
        iCrafting.sendProgressBarUpdate(container, 1, this.fuelTotalTime);
        iCrafting.sendProgressBarUpdate(container, 2, this.fermentationTime);
        iCrafting.sendProgressBarUpdate(container, 3, this.fermentationTotalTime);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.resourceTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.tankManager.drain(from, quantityMax, doEmpty);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(FactoryTriggers.lowResource25);
        res.add(FactoryTriggers.lowResource10);
        return res;
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiFermenter(player.inventory, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerFermenter(player.inventory, this);
    }
}

