/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IVariableFermentable;
import forestry.api.recipes.RecipeManagers;
import forestry.core.recipes.nei.NEIUtils;
import forestry.core.recipes.nei.PositionedFluidTank;
import forestry.core.recipes.nei.RecipeHandlerBase;
import forestry.factory.gui.GuiFermenter;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class NEIHandlerFermenter
extends RecipeHandlerBase {
    private static Class<? extends GuiContainer> guiClass;

    @Override
    public void prepare() {
        guiClass = GuiFermenter.class;
        API.setGuiOffset(guiClass, (int)5, (int)15);
    }

    @Override
    public String getRecipeID() {
        return "forestry.fermenter";
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.for.factory.3.name");
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/fermenter.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(76, 27, 14, 12);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiClass;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)25, (int)0, (int)30, (int)15, (int)116, (int)65);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(69, 17, 176, 60, 4, 18, 40, 11);
        this.drawProgressBar(93, 31, 176, 78, 4, 18, 80, 11);
    }

    private List<CachedFermenterRecipe> getCachedRecipes(IFermenterRecipe recipe, boolean generatePermutations) {
        if (recipe.getResource() != null && recipe.getResource().getItem() instanceof IVariableFermentable) {
            ArrayList<CachedFermenterRecipe> crecipes = new ArrayList<CachedFermenterRecipe>();
            for (ItemStack stack : NEIUtils.getItemVariations(recipe.getResource())) {
                crecipes.add(new CachedFermenterRecipe(recipe, stack, generatePermutations));
            }
            return crecipes;
        }
        return Collections.singletonList(new CachedFermenterRecipe(recipe, recipe.getResource(), generatePermutations));
    }

    @Override
    public void loadAllRecipes() {
        for (IFermenterRecipe recipe : RecipeManagers.fermenterManager.recipes()) {
            this.arecipes.addAll(this.getCachedRecipes(recipe, true));
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (IFermenterRecipe recipe : RecipeManagers.fermenterManager.recipes()) {
            FluidStack output = new FluidStack(recipe.getOutput(), 1000);
            if (!NEIUtils.areFluidsSameType(output, result)) continue;
            this.arecipes.addAll(this.getCachedRecipes(recipe, true));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        super.loadUsageRecipes(ingred);
        for (IFermenterRecipe recipe : RecipeManagers.fermenterManager.recipes()) {
            if (recipe.getResource() != null) {
                for (ItemStack stack : NEIUtils.getItemVariations(recipe.getResource())) {
                    if ((!stack.hasTagCompound() || !NEIServerUtils.areStacksSameType((ItemStack)stack, (ItemStack)ingred)) && (stack.hasTagCompound() || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)ingred))) continue;
                    CachedFermenterRecipe crecipe = new CachedFermenterRecipe(recipe, stack, true);
                    this.arecipes.add(crecipe);
                }
            }
            for (FermenterFuel fuel : FuelManager.fermenterFuel.values()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)fuel.item, (ItemStack)ingred)) continue;
                for (CachedFermenterRecipe crecipe : this.getCachedRecipes(recipe, true)) {
                    crecipe.setIngredientPermutation(crecipe.inputItems, ingred);
                    this.arecipes.add(crecipe);
                }
            }
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingred) {
        for (IFermenterRecipe recipe : RecipeManagers.fermenterManager.recipes()) {
            if (!NEIUtils.areFluidsSameType(recipe.getFluidResource(), ingred)) continue;
            this.arecipes.addAll(this.getCachedRecipes(recipe, true));
        }
    }

    public class CachedFermenterRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedFluidTank> tanks = new ArrayList<PositionedFluidTank>();
        public PositionedStack resource;
        public List<PositionedStack> inputItems = new ArrayList<PositionedStack>();

        public CachedFermenterRecipe(IFermenterRecipe recipe, ItemStack fermentable, boolean genPerms) {
            if (recipe.getFluidResource() != null) {
                FluidStack input = recipe.getFluidResource().copy();
                input.amount = recipe.getFermentationValue();
                this.tanks.add(new PositionedFluidTank(input, 10000, new Rectangle(30, 4, 16, 58), NEIHandlerFermenter.this.getGuiTexture(), new Point(176, 0)));
            }
            if (recipe.getOutput() != null) {
                int amount = Math.round((float)recipe.getFermentationValue() * recipe.getModifier());
                if (fermentable.getItem() instanceof IVariableFermentable) {
                    amount = (int)((float)amount * ((IVariableFermentable)fermentable.getItem()).getFermentationModifier(fermentable));
                }
                FluidStack output = new FluidStack(recipe.getOutput(), amount);
                this.tanks.add(new PositionedFluidTank(output, 10000, new Rectangle(120, 4, 16, 58), NEIHandlerFermenter.this.getGuiTexture(), new Point(176, 0)));
            }
            this.inputItems.add(new PositionedStack((Object)fermentable, 80, 8));
            ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
            for (FermenterFuel fuel : FuelManager.fermenterFuel.values()) {
                fuels.add(fuel.item);
            }
            this.inputItems.add(new PositionedStack(fuels, 70, 42));
            if (genPerms) {
                this.generatePermutations();
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIHandlerFermenter.this.cycleticks / 40, this.inputItems);
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public List<PositionedFluidTank> getFluidTanks() {
            return this.tanks;
        }

        public void generatePermutations() {
            for (PositionedStack p : this.inputItems) {
                p.generatePermutations();
            }
        }
    }
}

