/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import cpw.mods.fml.common.gameevent.PlayerEvent;
import forestry.core.gui.ContainerTile;
import forestry.core.gui.IContainerCrafting;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotCraftMatrix;
import forestry.core.gui.slots.SlotCrafter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.factory.inventory.InventoryCraftingForestry;
import forestry.factory.network.packets.PacketWorktableMemoryUpdate;
import forestry.factory.network.packets.PacketWorktableRecipeUpdate;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.TileWorktable;
import java.lang.reflect.Method;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerWorktable
extends ContainerTile<TileWorktable>
implements IContainerCrafting,
IGuiSelectable {
    private static final Method craftingEventHandler;
    private static final Object craftingEventHandlerInstance;
    private final InventoryCraftingForestry craftMatrix = new InventoryCraftingForestry(this);
    private long lastMemoryUpdate;
    private boolean craftMatrixChanged = false;

    private static void callBQCraftingHandler(PlayerEvent.ItemCraftedEvent event) {
        if (craftingEventHandler != null) {
            try {
                craftingEventHandler.invoke(craftingEventHandlerInstance, event);
            }
            catch (ReflectiveOperationException e) {
                Log.logThrowable("Error calling BQ3 crafting event handler", e, new Object[0]);
            }
        }
    }

    public ContainerWorktable(EntityPlayer player, TileWorktable tile) {
        super(tile, player.inventory, 8, 136);
        int i;
        IInventory craftingDisplay = tile.getCraftingDisplay();
        IInventoryAdapter internalInventory = tile.getInternalInventory();
        for (i = 0; i < 2; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlotToContainer(new Slot((IInventory)internalInventory, 0 + k + i * 9, 8 + k * 18, 90 + i * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 3; ++k1) {
                this.addSlotToContainer(new SlotCraftMatrix(this, craftingDisplay, k1 + l * 3, 11 + k1 * 18, 20 + l * 18));
            }
        }
        this.addSlotToContainer((Slot)new SlotCrafter(player, craftingDisplay, tile, 9, 77, 38));
        for (i = 0; i < this.craftMatrix.getSizeInventory(); ++i) {
            this.onCraftMatrixChanged(tile.getCraftingDisplay(), i);
        }
    }

    @Override
    public void detectAndSendChanges() {
        if (this.craftMatrixChanged) {
            this.craftMatrixChanged = false;
            ((TileWorktable)this.tile).setCurrentRecipe(this.craftMatrix);
            this.sendPacketToCrafters(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
        }
        super.detectAndSendChanges();
        if (this.lastMemoryUpdate != ((TileWorktable)this.tile).getMemory().getLastUpdate()) {
            this.lastMemoryUpdate = ((TileWorktable)this.tile).getMemory().getLastUpdate();
            this.sendPacketToCrafters(new PacketWorktableMemoryUpdate((TileWorktable)this.tile));
        }
    }

    private void updateCraftMatrix() {
        IInventory crafting = ((TileWorktable)this.tile).getCraftingDisplay();
        for (int i = 0; i < crafting.getSizeInventory(); ++i) {
            this.onCraftMatrixChanged(crafting, i);
        }
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory, int slot) {
        ItemStack currentStack;
        if (slot >= this.craftMatrix.getSizeInventory()) {
            return;
        }
        ItemStack stack = iinventory.getStackInSlot(slot);
        if (!ItemStackUtil.isIdenticalItem(stack, currentStack = this.craftMatrix.getStackInSlot(slot))) {
            this.craftMatrix.setInventorySlotContents(slot, stack);
        }
    }

    public void onCraftMatrixChanged(IInventory iinventory) {
        this.craftMatrixChanged = true;
    }

    public static void clearRecipe() {
        ContainerWorktable.sendRecipeClick(-1, 0);
    }

    public static void sendRecipeClick(int mouseButton, int recipeIndex) {
        Proxies.net.sendToServer(new PacketGuiSelectRequest(mouseButton, recipeIndex));
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex) {
        Object o;
        ItemStack transferred = super.transferStackInSlot(player, slotIndex);
        if (!player.worldObj.isRemote && (o = this.inventorySlots.get(slotIndex)) instanceof SlotCrafter) {
            ContainerWorktable.callBQCraftingHandler(new PlayerEvent.ItemCraftedEvent(player, transferred, ((SlotCrafter)((Object)o)).inventory));
        }
        return transferred;
    }

    @Override
    public void handleSelectionRequest(EntityPlayerMP player, PacketGuiSelectRequest packet) {
        int primary = packet.getPrimaryIndex();
        int secondary = packet.getSecondaryIndex();
        switch (primary) {
            case -1: {
                ((TileWorktable)this.tile).clearCraftMatrix();
                this.updateCraftMatrix();
                this.sendPacketToCrafters(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
                break;
            }
            case 0: {
                ((TileWorktable)this.tile).chooseRecipeMemory(secondary);
                this.updateCraftMatrix();
                this.sendPacketToCrafters(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
                break;
            }
            case 1: {
                long time = player.worldObj.getTotalWorldTime();
                RecipeMemory memory = ((TileWorktable)this.tile).getMemory();
                memory.toggleLock(time, secondary);
                break;
            }
            case 100: {
                ((TileWorktable)this.tile).choosePreviousConflictRecipe();
                this.sendPacketToCrafters(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
                break;
            }
            case 101: {
                ((TileWorktable)this.tile).chooseNextConflictRecipe();
                this.sendPacketToCrafters(new PacketWorktableRecipeUpdate((TileWorktable)this.tile));
            }
        }
    }

    static {
        Object instance;
        Method method;
        try {
            Class<?> clazz = Class.forName("bq_standard.handlers.EventHandler");
            method = clazz.getMethod("onItemCrafted", PlayerEvent.ItemCraftedEvent.class);
            method.setAccessible(true);
            instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            method = null;
            instance = null;
        }
        if (instance != null) {
            Log.fine("BetterQuesting 3 Standard Expansion crafting quest compat enabled.");
        }
        craftingEventHandlerInstance = instance;
        craftingEventHandler = method;
    }
}

