/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes.nei;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SetRecipeCommandHandler {
    private final Class<? extends Container> containerClass;
    private final Class<? extends Slot> slotClass;

    public SetRecipeCommandHandler(Class<? extends Container> containerClass, Class<? extends Slot> slotClass) {
        this.containerClass = containerClass;
        this.slotClass = slotClass;
    }

    public void handle(NBTTagCompound data, EntityPlayerMP player) {
        NBTTagList stacks = data.getTagList("stacks", 10);
        Container cont = player.openContainer;
        if (!this.containerClass.isInstance(cont)) {
            return;
        }
        HashMap<Integer, ItemStack> stmap = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < stacks.tagCount(); ++i) {
            NBTTagCompound itemdata = stacks.getCompoundTagAt(i);
            stmap.put(itemdata.getInteger("slot"), ItemStack.loadItemStackFromNBT((NBTTagCompound)itemdata));
        }
        for (Object slotobj : cont.inventorySlots) {
            if (!this.slotClass.isInstance(slotobj)) continue;
            Slot slot = (Slot)slotobj;
            if (stmap.containsKey(slot.getSlotIndex())) {
                slot.putStack((ItemStack)stmap.get(slot.getSlotIndex()));
                continue;
            }
            slot.putStack(null);
        }
    }
}

