/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import forestry.Forestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.ILocatedPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class ProxyNetwork {
    public <P extends IForestryPacketClient & ILocatedPacket> void sendNetworkPacket(P packet, World world) {
        if (packet == null || !(world instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)world;
        PlayerManager playerManager = worldServer.getPlayerManager();
        int chunkX = ((ILocatedPacket)packet).getPosX() >> 4;
        int chunkZ = ((ILocatedPacket)packet).getPosZ() >> 4;
        for (Object playerObj : world.playerEntities) {
            EntityPlayerMP player;
            if (!(playerObj instanceof EntityPlayerMP) || !playerManager.isPlayerWatchingChunk(player = (EntityPlayerMP)playerObj, chunkX, chunkZ)) continue;
            this.sendToPlayer(packet, (EntityPlayer)player);
        }
    }

    public void sendToPlayer(IForestryPacketClient packet, EntityPlayer entityplayer) {
        if (!(entityplayer instanceof EntityPlayerMP) || entityplayer instanceof FakePlayer) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityplayer;
        Forestry.packetHandler.sendPacket(packet.getPacket(), player);
    }

    public void sendToServer(IForestryPacketServer packet) {
    }

    public void inventoryChangeNotify(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
        }
    }
}

