/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.config.Config;
import forestry.core.items.ItemForestry;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemOverlay
extends ItemForestry {
    protected final IOverlayInfo[] overlays;
    @SideOnly(value=Side.CLIENT)
    private IIcon primaryIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon secondaryIcon;

    public ItemOverlay(CreativeTabs tab, IOverlayInfo ... overlays) {
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.setCreativeTab(tab);
        this.overlays = overlays;
    }

    public boolean isDamageable() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < this.overlays.length; ++i) {
            if (!Config.isDebug && this.overlays[i].isSecret()) continue;
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.primaryIcon = TextureManager.registerTex(register, StringUtil.cleanItemName(this) + ".0");
        if (this.overlays[0].getSecondaryColor() != 0) {
            this.secondaryIcon = TextureManager.registerTex(register, StringUtil.cleanItemName(this) + ".1");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int i, int j) {
        if (i < 0 || i >= this.overlays.length) {
            return null;
        }
        if (j > 0 && this.overlays[i].getSecondaryColor() != 0) {
            return this.secondaryIcon;
        }
        return this.primaryIcon;
    }

    public int getRenderPasses(int metadata) {
        return metadata < 0 || metadata >= this.overlays.length ? 0 : (this.overlays[metadata].getSecondaryColor() != 0 ? 2 : 1);
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public String getUnlocalizedName(ItemStack stack) {
        if (stack.getItemDamage() < 0 || stack.getItemDamage() >= this.overlays.length) {
            return null;
        }
        return super.getUnlocalizedName(stack) + "." + this.overlays[stack.getItemDamage()].getName();
    }

    public int getColorFromItemStack(ItemStack itemstack, int j) {
        if (itemstack.getItemDamage() < 0 || itemstack.getItemDamage() >= this.overlays.length) {
            return 0;
        }
        IOverlayInfo overlayInfo = this.overlays[itemstack.getItemDamage()];
        if (j == 0 || overlayInfo.getSecondaryColor() == 0) {
            return overlayInfo.getPrimaryColor();
        }
        return overlayInfo.getSecondaryColor();
    }

    public static interface IOverlayInfo {
        public String getName();

        public int getPrimaryColor();

        public int getSecondaryColor();

        public boolean isSecret();
    }
}

