/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.items.ItemForestry;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.StringUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemCrated
extends ItemForestry {
    private final ItemStack contained;
    private final boolean usesOreDict;

    public ItemCrated(ItemStack contained, boolean usesOreDict) {
        this.contained = contained;
        this.usesOreDict = usesOreDict;
    }

    public boolean usesOreDict() {
        return this.usesOreDict;
    }

    public ItemStack getContained() {
        return this.contained;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.isRemote) {
            if (this.contained == null || itemstack.stackSize == 0) {
                return itemstack;
            }
            --itemstack.stackSize;
            ItemStack dropStack = this.contained.copy();
            dropStack.stackSize = 9;
            ItemStackUtil.dropItemStackAsEntity(dropStack, world, entityplayer.posX, entityplayer.posY, entityplayer.posZ, 40);
        }
        return itemstack;
    }

    public String getItemStackDisplayName(ItemStack itemstack) {
        if (this.contained == null) {
            return StatCollector.translateToLocal((String)"item.for.crate.name");
        }
        String containedName = Proxies.common.getDisplayName(this.contained);
        return StringUtil.localizeAndFormat("item.crated.grammar", containedName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        String textureName = this.contained == null ? "crate" : "crate-filled";
        this.itemIcon = TextureManager.registerTex(register, textureName);
    }
}

