/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.items.ItemBlockNBT;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockForestry
extends ItemBlock {
    public ItemBlockForestry(Block block) {
        super(block);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    public int getMetadata(int i) {
        return i;
    }

    protected Block getBlock() {
        return this.field_150939_a;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int meta) {
        return this.getBlock().getIcon(1, meta);
    }

    public String getUnlocalizedName(ItemStack itemstack) {
        return this.getBlock().getUnlocalizedName() + "." + itemstack.getItemDamage();
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean placed = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        TileForestry tile = TileUtil.getTile((IBlockAccess)world, x, y, z, TileForestry.class);
        if (tile != null) {
            if (stack.getItem() instanceof ItemBlockNBT && stack.hasTagCompound()) {
                tile.readFromNBT(stack.getTagCompound());
                tile.xCoord = x;
                tile.yCoord = y;
                tile.zCoord = z;
            }
            tile.rotateAfterPlacement(player, side);
        }
        return placed;
    }
}

