/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.api.core.IToolPipette;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.farming.gui.ContainerFarm;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class TankWidget
extends Widget {
    private int overlayTexX = 176;
    private int overlayTexY = 0;
    private int slot = 0;
    protected boolean drawOverlay = true;

    public TankWidget(WidgetManager manager, int xPos, int yPos, int slot) {
        super(manager, xPos, yPos);
        this.slot = slot;
        this.height = 58;
    }

    public TankWidget setOverlayOrigin(int x, int y) {
        this.overlayTexX = x;
        this.overlayTexY = y;
        return this;
    }

    public IFluidTank getTank() {
        Container container = this.manager.gui.inventorySlots;
        if (container instanceof IContainerLiquidTanks) {
            return ((IContainerLiquidTanks)container).getTank(this.slot);
        }
        if (container instanceof ContainerFarm) {
            return ((ContainerFarm)container).getTank(this.slot);
        }
        return null;
    }

    @Override
    public void draw(int startX, int startY) {
        IFluidTank tank = this.getTank();
        if (tank == null || tank.getCapacity() <= 0) {
            return;
        }
        FluidStack contents = tank.getFluid();
        if (contents == null || contents.amount <= 0 || contents.getFluid() == null) {
            return;
        }
        IIcon liquidIcon = contents.getFluid().getIcon(contents);
        if (liquidIcon == null) {
            return;
        }
        int scaledLiquid = contents.amount * this.height / tank.getCapacity();
        if (scaledLiquid > this.height) {
            scaledLiquid = this.height;
        }
        Proxies.render.bindTexture(SpriteSheet.BLOCKS);
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int start = 0;
        while (scaledLiquid > 0) {
            int x;
            if (scaledLiquid > 16) {
                x = 16;
                scaledLiquid -= 16;
            } else {
                x = scaledLiquid;
                scaledLiquid = 0;
            }
            this.manager.gui.drawTexturedModelRectFromIcon(startX + this.xPos, startY + this.yPos + this.height - x - start, liquidIcon, 16, x);
            start += 16;
        }
        if (this.drawOverlay) {
            Proxies.render.bindTexture(this.manager.gui.textureFile);
            this.manager.gui.drawTexturedModalRect(startX + this.xPos, startY + this.yPos, this.overlayTexX, this.overlayTexY, 16, 60);
        }
        GL11.glPopAttrib();
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        IFluidTank tank = this.getTank();
        if (!(tank instanceof StandardTank)) {
            return null;
        }
        return ((StandardTank)tank).getToolTip();
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        EntityClientPlayerMP player = this.manager.minecraft.thePlayer;
        ItemStack itemstack = player.inventory.getItemStack();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.getItem();
        Container container = this.manager.gui.inventorySlots;
        if (held instanceof IToolPipette && container instanceof IContainerLiquidTanks) {
            ((IContainerLiquidTanks)container).handlePipetteClickClient(this.slot, (EntityPlayer)player);
        }
    }
}

