/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.access.IAccessHandler;
import forestry.core.blocks.BlockForestry;
import forestry.core.blocks.IMachineProperties;
import forestry.core.circuits.ISocketable;
import forestry.core.fluids.FluidHelper;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.MachineDefinition;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.PlayerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockBase<T extends IMachineProperties>
extends BlockForestry {
    private final List<MachineDefinition> definitions = new ArrayList<MachineDefinition>();
    private final boolean hasTESR;

    public BlockBase() {
        this(false);
    }

    public BlockBase(boolean hasTESR) {
        super(Material.iron);
        this.hasTESR = hasTESR;
        this.opaque = this.isOpaqueCube();
        this.lightOpacity = this.isOpaqueCube() ? 255 : 0;
    }

    public void addDefinitions(MachineDefinition ... definitions) {
        for (MachineDefinition definition : definitions) {
            this.addDefinition(definition);
        }
    }

    public void addDefinition(MachineDefinition definition) {
        definition.setBlock((Block)this);
        while (this.definitions.size() <= definition.getMeta()) {
            this.definitions.add(null);
        }
        this.definitions.set(definition.getMeta(), definition);
    }

    public boolean isOpaqueCube() {
        return !this.hasTESR;
    }

    public boolean renderAsNormalBlock() {
        return !this.hasTESR;
    }

    public int getRenderType() {
        if (this.hasTESR) {
            return Proxies.render.getByBlockModelRenderId();
        }
        return 0;
    }

    private MachineDefinition getDefinition(IBlockAccess world, int x, int y, int z) {
        if (!(world.getBlock(x, y, z) instanceof BlockBase)) {
            return null;
        }
        int meta = world.getBlockMetadata(x, y, z);
        return this.getDefinition(meta);
    }

    private MachineDefinition getDefinition(int metadata) {
        if (metadata < 0 || metadata >= this.definitions.size()) {
            return null;
        }
        return this.definitions.get(metadata);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        MachineDefinition definition = this.getDefinition((IBlockAccess)world, x, y, z);
        if (definition == null) {
            return super.getCollisionBoundingBoxFromPool(world, x, y, z);
        }
        return definition.getBoundingBox(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        MachineDefinition definition = this.getDefinition((IBlockAccess)world, x, y, z);
        if (definition == null) {
            return super.getCollisionBoundingBoxFromPool(world, x, y, z);
        }
        return definition.getBoundingBox(x, y, z);
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        MachineDefinition definition = this.getDefinition((IBlockAccess)world, x, y, z);
        if (definition == null) {
            return super.collisionRayTrace(world, x, y, z, startVec, endVec);
        }
        return definition.collisionRayTrace(world, x, y, z, startVec, endVec);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (MachineDefinition definition : this.definitions) {
            if (definition == null) continue;
            definition.getSubBlocks(item, tab, list);
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        MachineDefinition definition = this.getDefinition(metadata);
        if (definition == null) {
            return null;
        }
        return definition.createMachine();
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return this.createTileEntity(world, meta);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        MachineDefinition definition = this.getDefinition(world, x, y, z);
        return definition != null && definition.isSolidOnSide(world, x, y, z, side.ordinal());
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        if (player.isSneaking()) {
            return false;
        }
        TileBase tile = (TileBase)world.getTileEntity(x, y, z);
        if (!TileUtil.isUsableByPlayer(player, tile)) {
            return false;
        }
        IAccessHandler access = tile.getAccessHandler();
        ItemStack current = player.getCurrentEquippedItem();
        if (current != null && current.getItem() != Items.bucket && tile instanceof IFluidHandler && access.allowsAlteration(player) && FluidHelper.handleRightClick((IFluidHandler)tile, ForgeDirection.getOrientation((int)side), player, true, tile.canDrainWithBucket())) {
            return true;
        }
        if (world.isRemote) {
            return true;
        }
        if (access.allowsViewing(player)) {
            tile.openGui(player);
        } else {
            player.addChatMessage((IChatComponent)new ChatComponentTranslation("for.chat.accesslocked", new Object[]{PlayerUtil.getOwnerName(access)}));
        }
        return true;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        MachineDefinition definition = this.getDefinition((IBlockAccess)world, x, y, z);
        if (definition == null) {
            return super.rotateBlock(world, x, y, z, axis);
        }
        return definition.rotateBlock(world, x, y, z, axis);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        if (world.isRemote) {
            return;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            InventoryUtil.dropInventory(inventory, world, x, y, z);
            if (tile instanceof TileForestry) {
                ((TileForestry)tile).onRemoval();
            }
            if (tile instanceof ISocketable) {
                InventoryUtil.dropSockets((ISocketable)tile, tile.getWorldObj(), tile.xCoord, tile.yCoord, tile.zCoord);
            }
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    public int damageDropped(int metadata) {
        return metadata;
    }

    public void init() {
        for (MachineDefinition def : this.definitions) {
            if (def == null) continue;
            def.register();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        for (MachineDefinition def : this.definitions) {
            if (def == null) continue;
            def.registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metadata) {
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            return null;
        }
        return this.definitions.get(metadata).getBlockTextureForSide(side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            metadata = 0;
        }
        return this.definitions.get(metadata).getIcon(world, x, y, z, side);
    }

    public boolean getUseNeighborBrightness() {
        return this.hasTESR;
    }

    public final ItemStack get(T type) {
        return new ItemStack((Block)this, 1, type.getMeta());
    }
}

