/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenMaple
extends WorldGenTree {
    public WorldGenMaple(ITreeGenData tree) {
        super(tree, 7, 5);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        ArrayList<ChunkCoordinates> branchCoords = new ArrayList<ChunkCoordinates>();
        for (int yBranch = 2; yBranch < this.height - 2; ++yBranch) {
            branchCoords.addAll(this.generateBranches(world, yBranch, 0, 0, 0.15f, 0.25f, Math.round((float)(this.height - yBranch) * 0.25f), 1, 0.25f));
        }
        for (ChunkCoordinates branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd.posY, branchEnd.posX, branchEnd.posZ, 2.0f, 2, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
        int leafSpawn = this.height + 1;
        float diameterchange = 1.0f / (float)this.height;
        int leafSpawned = 2;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.0f, 1, this.leaf);
        while (leafSpawn > 1) {
            this.generateAdjustedCylinder(world, leafSpawn--, 3.0f * diameterchange * (float)leafSpawned, 1, this.leaf);
            this.generateAdjustedCylinder(world, leafSpawn--, 2.0f * diameterchange * (float)leafSpawned, 1, this.leaf);
            leafSpawned += 2;
        }
    }
}

