/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.world.World;

public class WorldGenEbony
extends WorldGenTree {
    public WorldGenEbony(ITreeGenData tree) {
        super(tree, 10, 4);
    }

    @Override
    public void generate(World world) {
        int offset = (this.girth - 1) / 2;
        int trunksgenerated = 0;
        for (int x = -offset; x < -offset + this.girth; ++x) {
            for (int z = -offset; z < -offset + this.girth; ++z) {
                int i;
                if (world.rand.nextFloat() < 0.6f) {
                    for (i = 0; i < this.height; ++i) {
                        this.addWood(world, x, i, z, WorldGenBase.EnumReplaceMode.ALL);
                        if (i > this.height / 2 && world.rand.nextFloat() < 0.1f * (float)(10 / this.height)) break;
                    }
                    ++trunksgenerated;
                    continue;
                }
                for (i = 0; i < 1; ++i) {
                    this.clearBlock(world, x, i, z);
                }
            }
        }
        if (trunksgenerated <= 0) {
            this.generateTreeTrunk(world, this.height, 1, 0.6f);
        }
        for (int times = 0; times < 2 * this.height; ++times) {
            int h = 2 * this.girth + world.rand.nextInt(this.height - this.girth);
            if (world.rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + world.rand.nextInt(this.height / 2);
            }
            int x_off = -this.girth + world.rand.nextInt(2 * this.girth);
            int y_off = -this.girth + world.rand.nextInt(2 * this.girth);
            WorldGenBase.Vector center = new WorldGenBase.Vector(x_off, h, y_off);
            int radius = 1 + world.rand.nextInt(this.girth);
            this.generateSphere(world, center, radius, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
    }
}

